/***************************************************************************
 *
 *  $Id: kzensynchronize.cpp,v 1.8 2005/07/03 18:27:52 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qapplication.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>

#include <kdebug.h>
#include <klocale.h>
#include <kprogress.h>

#include "kzenexplorer.h"
#include "kzentrack.h"
#include "kzenconfig.h"
#include "kzenmediafiles.h"
#include "kzenplaylist.h"

#include "kzensynchronize.h"

KZenSynchronize::KZenSynchronize()
{
  
}

KZenSynchronize::~KZenSynchronize()
{
  
}

void KZenSynchronize::synchronize()
{
  if (!KZenConfig::get()->syncLibrary() && !KZenConfig::get()->syncPlayLists()) return;

  bool cs = KZenConfig::get()->caseSensitiveSearch();
  bool exact = KZenConfig::get()->exactSearch();

  QPtrList<KZenMediaFiles::Track> mtracks;
  mtracks.setAutoDelete(true);
  QPtrList<KZenMediaFiles::Track> mtrackssync;
  mtrackssync.setAutoDelete(false);
  QPtrList<KZenTrack> trackssync;
  trackssync.setAutoDelete(false);
  QPtrList<KZenTrack> trackssyncup;
  trackssync.setAutoDelete(false);
  QStringList m3ulist;

  KZenMediaFiles::Track * mtrack;
  KZenMediaFiles::Track * mtrackt;
  KZenTrack * track = 0;
  
  KZenMediaFiles::getMediaFiles(KZenConfig::get()->localLibrary(), mtracks);
  KZenMediaFiles::getM3UList(KZenConfig::get()->localLibrary(), m3ulist);

  bool found = false;
  bool valid;
  
  KProgressDialog progress(gExplorer, "progress",
			   i18n("Synchronization"),
			   i18n("Scanning local library"),
			   true);
  progress.progressBar()->setTotalSteps(mtracks.count());
  progress.progressBar()->setProgress(0);
  progress.setAutoClose(false);
  progress.show();
  qApp->processEvents();

  bool cancelled = false;

  KURL url;

  for (mtrack=mtracks.first();mtrack;mtrack=mtracks.next()) {
    progress.progressBar()->advance(1);
    qApp->processEvents();
    cancelled = progress.wasCancelled();
    if (cancelled) break;
    
    if (!mtrack->fExclude) {
      mtrack->readTag();
    }
  }
  
  if (KZenConfig::get()->syncLibrary()) {
    progress.progressBar()->setTotalSteps(mtracks.count());
    progress.progressBar()->setProgress(0);
    progress.setLabel(i18n("Local library -> Jukebox"));
    qApp->processEvents();
    
    for (mtrack=mtracks.first();mtrack;mtrack=mtracks.next()) {
      progress.progressBar()->advance(1);
      if (!mtrack->fExclude) {
	mtrack->readTag();
	qApp->processEvents();
	cancelled = progress.wasCancelled();
	if (cancelled) break;

	KZenTrack * track;
	bool found = false;
	for (uint i=0;i<gExplorer->getTracks()->count();i++) {
	  track = gExplorer->getTracks()->at(i);

	  if (exact) {
	    if (track->getArtist()==mtrack->fArtist &&
		track->getTitle()==mtrack->fTitle &&
		track->getAlbum()==mtrack->fAlbum) found = true;
	  } else {
	    if ((track->getArtist().startsWith(mtrack->fArtist, cs) ||
		 mtrack->fArtist.startsWith(track->getArtist(), cs)) &&
		(track->getTitle().startsWith(mtrack->fTitle, cs) ||
		 mtrack->fTitle.startsWith(track->getTitle(), cs)) &&
		(track->getAlbum().startsWith(mtrack->fAlbum, cs) ||
		 mtrack->fAlbum.startsWith(track->getAlbum(), cs))) found = true;
	  }
	  
	  if (found) break;
	}

	if (!found) {
	  mtrackssync.append(mtrack);
	}
      }
    }

    if (cancelled) return;

    progress.progressBar()->setTotalSteps(gExplorer->getTracks()->count());
    progress.progressBar()->setProgress(0);
    progress.setLabel(i18n("Jukebox -> Local library"));
    qApp->processEvents();

    for (uint i=0;i<gExplorer->getTracks()->count();i++) {
      track = gExplorer->getTracks()->at(i);

      progress.progressBar()->advance(1);
      qApp->processEvents();
      cancelled = progress.wasCancelled();
      if (cancelled) break;
    
      for (mtrack=mtracks.first();mtrack;mtrack=mtracks.next()) {
	mtrack->readTag();
      
	if (!mtrack->fExclude) {
	  if (exact) {
	    if (track->getArtist()==mtrack->fArtist &&
		track->getTitle()==mtrack->fTitle &&
		track->getAlbum()==mtrack->fAlbum) found = true;
	  } else {
	    if ((track->getArtist().startsWith(mtrack->fArtist, cs) ||
		 mtrack->fArtist.startsWith(track->getArtist(), cs)) &&
		(track->getTitle().startsWith(mtrack->fTitle, cs) ||
		 mtrack->fTitle.startsWith(track->getTitle(), cs)) &&
		(track->getAlbum().startsWith(mtrack->fAlbum, cs) ||
		 mtrack->fAlbum.startsWith(track->getAlbum(), cs))) found = true;
	  }

	  if (found) break;
	}
      }
      
      if (!found) {
	KURL su = KZenMediaFiles::saveFilename(track, KZenConfig::get()->localLibrary(), valid, false);
	bool exclude = false;
	if (valid) {
	  for (uint e=0;e<KZenConfig::get()->excludeFromSync().count();e++) {
	    if (su.path().startsWith(KZenConfig::get()->excludeFromSync()[e])) exclude = true;
	  }
	
	  if (!exclude) {
	    trackssync.append(track);
	  }
	}
      }
    }
  
    if (cancelled) return;
  
  }
  
  if (KZenConfig::get()->syncPlayLists()) {
    
    progress.progressBar()->setTotalSteps(gExplorer->getSmartPlayLists()->count());
    progress.progressBar()->setProgress(0);
    progress.setLabel(i18n("Synchronizing smart playlists"));
    qApp->processEvents();

    KZenSmartPlayList * spl;
    for (uint i=0;i<gExplorer->getSmartPlayLists()->count();i++) {
      spl = gExplorer->getSmartPlayLists()->at(i);
    
      url = KZenConfig::get()->localLibrary();
      url.addPath(spl->getName() + ".m3u");

      m3ulist.remove(url.path());

      kdDebug() << url.url() << endl;
    
      progress.progressBar()->advance(1);
      qApp->processEvents();
      cancelled = progress.wasCancelled();
      if (cancelled) break;

      QFile m3u(url.path());
      if (m3u.open(IO_WriteOnly)) {
	QTextStream stream(&m3u);
      
	stream << "#EXTM3U" << endl;
      
	for (uint i=0;i<spl->getTrackList()->count();i++) {
	  track = spl->getTrackList()->at(i);
	
	  found = false;
	  for (mtrack=mtracks.first();mtrack;mtrack=mtracks.next()) {
	    mtrack->readTag();

	    qApp->processEvents();
	    cancelled = progress.wasCancelled();
	    if (cancelled) return;
	  
	    if (track->getTitle()==mtrack->fTitle &&
		track->getArtist()==mtrack->fArtist &&
		track->getAlbum()==mtrack->fAlbum) found = true;
	  
	    if (found) break;
	  }

	  if (found) {
	    url = mtrack->fURL;
	    valid = true;
	  } else {
	    trackssync.append(track);
	    url = KZenMediaFiles::saveFilename(track, KZenConfig::get()->localLibrary(), valid, false);
	  }
	
	  if (valid) {
	    stream << "#EXTINF:";
	    stream << track->getLength();
	    stream << ",";
	    stream << track->getTitle() << endl;
	  
	    stream << url.path() << endl;	  
	  }
	}
	m3u.close();
      }
    }

    if (cancelled) return;

    progress.progressBar()->setTotalSteps(gExplorer->getSmartPlayLists()->count());
    progress.progressBar()->setProgress(0);
    progress.setLabel(i18n("Synchronizing playlists"));
    qApp->processEvents();

    KZenPlayList * pl = 0;
    for (uint i=0;i<gExplorer->getPlayListList()->count();i++) {
      pl = gExplorer->getPlayListList()->at(i);
    
      url = KZenConfig::get()->localLibrary();
      url.addPath(pl->getName() + ".m3u");

      kdDebug() << url.url() << endl;
    
      progress.progressBar()->advance(1);
      qApp->processEvents();
      cancelled = progress.wasCancelled();
      if (cancelled) break;
    
      QFile m3u(url.path());

      if (m3u.exists() && !KZenConfig::get()->playListOverride()) continue;

      m3ulist.remove(url.path());
    
      if (m3u.open(IO_WriteOnly)) {
	QTextStream stream(&m3u);
      
	stream << "#EXTM3U" << endl;
      
	for (uint i=0;i<pl->getTrackList()->count();i++) {
	  track = pl->getTrackList()->at(i);
	
	  found = false;
	  for (mtrack=mtracks.first();mtrack;mtrack=mtracks.next()) {
	    mtrack->readTag();

	    qApp->processEvents();
	    cancelled = progress.wasCancelled();
	    if (cancelled) return;
	  
	    if (track->getTitle()==mtrack->fTitle &&
		track->getArtist()==mtrack->fArtist &&
		track->getAlbum()==mtrack->fAlbum) found = true;
	  
	    if (found) break;
	  }

	  if (found) {
	    url = mtrack->fURL;
	    valid = true;
	  } else {
	    trackssync.append(track);
	    url = KZenMediaFiles::saveFilename(track, KZenConfig::get()->localLibrary(), valid, false);
	  }
	
	  if (valid) {
	    stream << "#EXTINF:";
	    stream << track->getLength();
	    stream << ",";
	    stream << track->getTitle() << endl;
	  
	    stream << url.path() << endl;	  
	  }
	}
	m3u.close();
      }
    }

    if (cancelled) return;
  
    progress.progressBar()->setTotalSteps(m3ulist.count());
    progress.progressBar()->setProgress(0);
    progress.setLabel(i18n("Synchronizing local playlists"));
    qApp->processEvents();

    for (uint i=0;i<m3ulist.count();i++) {
      QString fn = m3ulist[i];
      QFile m3u(fn);
      QFileInfo fi(m3u);

      progress.progressBar()->advance(1);
      qApp->processEvents();
      cancelled = progress.wasCancelled();
      if (cancelled) break;

      kdDebug() << fi.baseName() << endl;

      found = false;
      for (uint i=0;i<gExplorer->getSmartPlayLists()->count();i++) {
	spl = gExplorer->getSmartPlayLists()->at(i);
	if (spl->getName()==fi.baseName()) found = true;
	if (found) break;
      }
    
      if (found) continue;

      found = false;
      for (uint i=0;i<gExplorer->getPlayListList()->count();i++) {
	pl = gExplorer->getPlayListList()->at(i);
	if (pl->getName()==fi.baseName()) found = true;
	if (found) break;
      }
    
      if (found) {
	if (KZenConfig::get()->playListOverride()) {
	  continue;
	} else {
	  pl->getTrackList()->clear();
	}
      } else { 
	pl = new KZenPlayList(fi.baseName());

	gExplorer->commandThread()->newPlayList(pl);
      }

      QStringList files;
      if (m3u.open(IO_ReadOnly)) {
	QTextStream stream(&m3u);
	QString line;
	int i = 1;
	while (!stream.atEnd()) {
	  line = stream.readLine().stripWhiteSpace();
	  if (!line.startsWith("#EXT")) {
	    printf( "%3d: %s\n", i++, line.latin1() );
	    url.setPath(line);

	    if (KZenMediaFiles::isMP3(url)) {
	      files += line;
	    }
	  }
	}
	m3u.close();
      }

      if (files.size()==0) continue;
    
      for (QStringList::Iterator it = files.begin(); it != files.end(); ++it) {
	url.setPath(*it);
      
	found = false;
	for (mtrack=mtracks.first();mtrack;mtrack=mtracks.next()) {
	  if (mtrack->fURL==url) found = true;
	  if (found) break;
	}
      
	if (found) {
	  mtrack->readTag();

	  qApp->processEvents();
	  cancelled = progress.wasCancelled();
	  if (cancelled) return;
	
	  found = false;
	  for (uint i=0;i<gExplorer->getTracks()->count();i++) {
	    track = gExplorer->getTracks()->at(i);
	  
	    if (track->getTitle()==mtrack->fTitle &&
		track->getArtist()==mtrack->fArtist &&
		track->getAlbum()==mtrack->fAlbum) found = true;
	    if (found) break;
	  }

	  if (!found) {
	    found = false;
	    for (mtrackt=mtrackssync.first();mtrackt;mtrackt=mtrackssync.next()) {
	      if (mtrackt->fTitle==mtrack->fTitle &&
		  mtrackt->fArtist==mtrack->fArtist &&
		  mtrackt->fAlbum==mtrack->fAlbum) found = true;
	      if (found) break;
	    }

	    if (found) {
	      mtrackssync.remove(mtrackt);
	    }
	  
	    track = KZenMediaFiles::createTrackMP3(url);
	    if (track) {
	      trackssyncup.append(track);
	      track->setFileName(url.path());
	      pl->addTrack(track);
	    }
	  } else {
	    pl->addTrack(track);
	  }
	}
      } 
    
      gExplorer->addPlayList(pl);
      gExplorer->getView()->addPlayList(pl, false);
    }

  }

  progress.close();

  gExplorer->commandThread()->lock();

  for (uint i=0;i<trackssyncup.count();i++) {
    track = trackssyncup.at(i);
    
    url.setPath(track->getFileName());

    gExplorer->progressDialog()->addTrack(track, true);
    gExplorer->commandThread()->addTrack(track, url, 0);
    qApp->processEvents();
  }
  
  for (mtrack=mtrackssync.first();mtrack;mtrack=mtrackssync.next()) {
    KZenTrack * newTrack = KZenMediaFiles::createTrackMP3(mtrack->fURL);
    if (newTrack) {
      gExplorer->progressDialog()->addTrack(newTrack, true);
      gExplorer->commandThread()->addTrack(newTrack,mtrack->fURL, 0);
      qApp->processEvents();
    }
  }

  for (uint i=0;i<trackssync.count();i++) {
    track = trackssync.at(i);

    gExplorer->progressDialog()->addTrack(track, false);
    gExplorer->commandThread()->saveTrack(track, KZenConfig::get()->localLibrary());
    qApp->processEvents();
  }

  gExplorer->commandThread()->unlock();
}
