/***************************************************************************
 *
 *  $Id: kzensearchcondition.h,v 1.3 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENSEARCHCONDITION_H
#define KZENSEARCHCONDITION_H

#include <qvariant.h>
#include <qdatastream.h>

class KZenTrack;

class KZenSearchCondition
{
 public:
  
  enum FieldType { 
    FArtist      = 0,
    FAlbum       = 1,
    FTitle       = 2,
    FTracknumber = 3,
    FGenre       = 4,
    FYear        = 5,
    FRating      = 6,
    FCategory    = 7,
    FUnknown
  };

  enum Operation {
    OEQUAL         = 0,
    ONOTEQUAL      = 1,
    OCONTAINS      = 2,
    ONOTCONTAINS   = 3,
    OLESS          = 4,
    OLESSEQUAL     = 5,
    OMORE          = 6,
    OMOREEQUAL     = 7,
    OUnknown
  };
  
  KZenSearchCondition();
  KZenSearchCondition(KZenSearchCondition *);
  KZenSearchCondition(FieldType field, Operation op, bool cs, QVariant value);
  virtual ~KZenSearchCondition();
  
  FieldType                   getField() { return fField; }
  void                        setField(FieldType type) { fField = type; }

  Operation                   getOperation() { return fOperation; }
  void                        setOperation(Operation op) { fOperation = op; }

  bool                        getCaseSensitive() { return fCaseSensitive; }
  void                        setCaseSensitive(bool cs) { fCaseSensitive = cs; }

  QVariant &                  getValue() { return fValue; }
  void                        setValue(const QVariant &);

  virtual bool                checkTrack(KZenTrack*);

  void                        assign(KZenSearchCondition *);

 protected:

  bool                        checkOperation(QVariant field);

  FieldType                   fField;
  Operation                   fOperation;
  bool                        fCaseSensitive;
  QVariant                    fValue;
};

QDataStream & operator<<(QDataStream & s, KZenSearchCondition & spl);
QDataStream & operator>>(QDataStream & s, KZenSearchCondition & spl);

#endif
