/***************************************************************************
 *
 *  $Id: dirselector.h,v 1.1 2005/06/28 18:54:31 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef DIRSELECTOR_H
#define DIRSELECTOR_H

#include <qlistview.h>

#include <kdirlister.h>
#include <kurl.h>

class DirSelector : public QListView
{
 public:

  DirSelector(QWidget * parent = 0, const char * name = 0);
  ~DirSelector();

  void                        setDirectories(const QStringList &);
  QStringList &               directories() { return fDirectories; }

  void                        setTopDir(const KURL & url);

  void                        refresh();

 protected:

  QStringList                 fDirectories;
  KURL                        fTopDir;
};

class DirSelectorItem : public QObject, public QCheckListItem
{
Q_OBJECT

 public:
 
  DirSelectorItem(QListView * parent, const KURL & url);
  DirSelectorItem(QListViewItem * parent, const KURL & url);

  QCheckListItem *            parent() const;
  bool                        isDisabled() const;
  KURL &                      url() { return fURL; }

  void                        setOpen(bool b);
  void                        stateChange(bool b);
  void                        activate();
  void                        paintCell(QPainter * p, const QColorGroup & cg, 
					int column, int width, int align);

public slots:

  void                        newItems(const KFileItemList &);
  void                        completed();

private:

  KDirLister                  fDirLister;
  KURL                        fURL;
  bool                        fListed;
};
#endif
