/***************************************************************************
 *   Copyright (C) 2004 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __TEXTTOOLDIALOG_H
#define __TEXTTOOLDIALOG_H

#include <qcstring.h>
#include <qstring.h>
#include "texttooldlg.h"

/** Wrapper class for the text tool
    @author Stephen P Allewell
  */
class TextToolDialog : public TextToolDlg
{
  Q_OBJECT
public:
  TextToolDialog(QWidget* parent);
  virtual ~TextToolDialog();

  QByteArray pattern();
  int boundingWidth();
  int boundingHeight();

protected slots:
  virtual void accept();
  void slotContextHelp();
  
private slots:
  void slotTextChanged(const QString&);
  void slotFontSelected(int);
  void slotSizeChanged(int);
    
private:
  QString  m_font;
  QString  m_text;
  int      m_size;
  int      m_width;
  int      m_height;
};

#endif
