/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "stitch.h"

Stitch::Stitch(Type t, int i)
  : type(t),
    floss(i)
{
}

BackStitch::BackStitch(QPoint s, QPoint e, int i)
  : start(s),
    end(e),
    floss(i)
{
}

bool BackStitch::contains(QPoint p)
{
  if (start == p || end == p) return true;
  return false;
}

Knot::Knot(QPoint p, int i)
  : pos(p),
    floss(i)
{
}
