/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "configconnectoptions.h"

#include <QtGui/QCheckBox>

#include <kcombobox.h>

#include "widgetnotifyhelper.h"

ConfigConnectOptions::ConfigConnectOptions(QWidget *parent) : QWidget(parent)
{
    setupUi(this);
    connect(DoAutoConnectCheckBox, SIGNAL(toggled(bool)), this, SLOT(autoConnectToggled(bool)));
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;

    // connect changed signals to own signal
    connect(AutoConnectProfileComboBox, SIGNAL(textChanged(const QString &)), this, SIGNAL(changed()));
    connect(checkMinimizeAfterConnectCheck, SIGNAL(stateChanged(int)), this, SIGNAL(changed()));
    connect(SilentQuitcheckBox, SIGNAL(stateChanged(int)), this, SIGNAL(changed()));
    connect(DoAutoConnectCheckBox, SIGNAL(stateChanged(int)), this, SIGNAL(changed()));

    // connect changed to slot
    connect(this, SIGNAL(changed()), this, SLOT(dialogChanged()));
}


ConfigConnectOptions::~ConfigConnectOptions()
{}


void ConfigConnectOptions::autoConnectToggled(bool)
{
    if (DoAutoConnectCheckBox->isChecked())
        AutoConnectProfileComboBox->setEnabled(true);
    else
        AutoConnectProfileComboBox->setEnabled(false);
}


void ConfigConnectOptions::dialogChanged()
{
    dialogModified = true;
}
