/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ktranslator_clipboard.h"
#include "ktrclipboard.h"
#include "../../ktranslatordock.h"

#include <kgenericfactory.h>

#include <qtooltip.h>

#include <kapplication.h>
#include <kactionclasses.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kconfig.h>

K_EXPORT_COMPONENT_FACTORY( ktranslator_clipboard,
                            KGenericFactory<Clipboard>( "ktranslator_clipboard" ) )

Clipboard::Clipboard(QObject *parent, const char*, const QStringList& )
            : KTranslator::UIPlugin(parent, "Clipboard" )
{
    KLocale::setMainCatalogue("ktranslator");
    // Sets the enable/disable watch the clipboard
    setInstance(KGenericFactory<Clipboard>::instance());
    setXMLFile("ktranslator_clipboardui.rc");

    // Clipboard
    clip = new ktrClipboard();
    connect( clip, SIGNAL( selectionChanged() ), this, SLOT( slotChanged() ) );
    clip->start();

    // Watch Clipboard KAction
    enabled = true;
    ktranslatorDock *dock = (ktranslatorDock*)parent->child("dock");
    actionWatch = new KToggleAction( i18n( "Watch the Clipboard" ), "viewmag", 0, this, SLOT( toggleClip() ), actionCollection(), "watchAction" );
    actionWatch->setWhatsThis( i18n( "Click here to translate all words that you select with the mouse" ) );
    dock->actionCollection()->insert( actionWatch );
    actionWatch->plug( dock->contextMenu(), 1 );
    setEnabled( enabled );

    loadModifierKey();
}

void Clipboard::slotChanged()
{
  #ifdef KDE_3_4
    if( needModifier && ! ( kapp->keyboardMouseState() & button ) ) return;
  #else
    if( needModifier && ! ( kapp->keyboardModifiers() & 4 ) ) return;
  #endif
  if( !enabled ) return;
  QString word = clip->text();
  emitSearch( word );
}

void Clipboard::setEnabled( bool enable )
{
    enabled = enable;
    actionWatch->setChecked( enabled );
    ktranslatorDock *dock = (ktranslatorDock*)parent()->child("dock");
    QToolTip::remove( dock );

    if( enabled )
    {
      clip->start();
      QToolTip::add( dock, i18n( "KTranslator - Translation enabled" ) );
      dock->setPixmap( dock->loadIcon( "ktranslator" ) );
    }
    else
    {
      clip->stop();
      QToolTip::add( dock, i18n( "KTranslator - Translation disabled" ) );
      KIconLoader *icon = new KIconLoader();
      dock->setPixmap( icon->loadIcon( "ktranslator", KIcon::MainToolbar, 0, KIcon::DisabledState ) );
      delete icon;
    }
}


void Clipboard::toggleClip()
{
    setEnabled( !enabled );
}


void Clipboard::loadModifierKey()
{
    // Loads the modifier key that triggers the translation
    KConfig *config = kapp->config();
    config->setGroup( "general" );
    needModifier = config->readBoolEntry( "NeedModifier", true );
    QString a = config->readEntry( "ModifierKey", "Control" );
    if( a == "Shift" ) button = 256;
    else if( a == "Control" ) button = 512;
    else if( a == "Alt" ) button = 1024;
    else if( a == "Winkey" ) button = 2048;
}

#include "ktranslator_clipboard.moc"
