/***************************************************************************
 *   Copyright (C) 2005-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KTRANSLATORDICTIONARYMANAGER_H_
#define _KTRANSLATORDICTIONARYMANAGER_H_

#include <kparts/componentfactory.h>
#include <dictionary/dictionaryplugin.h>

class KConfig;
class KTranslatorDictionary;

class KTranslatorDictionaryManager : public QObject
{
public:
  KTranslatorDictionaryManager();
  ~KTranslatorDictionaryManager();

  void loadPlugins();
  void addDictionary();
  void editDictionary( uint item );
  void removeDictionary( uint item );
  void moveDictionary( uint item, bool up );

  QPtrList<KTranslatorDictionary> list;
  KTrader::OfferList offersPlugins;

protected:
  // Search for dictionaries in standard paths like /usr/lib/dict
  // returns false if didn't find any
  bool searchForDictionaries( KConfig*, QStringList* );
};

#endif // _KTRANSLATORDICTIONARYMANAGER_H_
