/*
 * Copyright (C) 2006 Hans van Leeuwen <hanz@hanz.nl>
 * Copyright (C) 2008 Armin Berres <trigger@space-based.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#include <iostream>
#include <kwallet.h>
#include <kpassdlg.h>
#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static KCmdLineOptions options[] =
{
    { "+[dialog]", I18N_NOOP( "Dialog message. Leave undefined for default message" ), 0 },
	KCmdLineLastOption
};

int main(int argc, char **argv)
{

        KAboutData about (
                "Ksshaskpass",                                                                  // appName
                I18N_NOOP("Ksshaskpass"),                                                       // programName
                "0.4.1",                                                                        // version
                I18N_NOOP("KDE version of ssh-askpass"),                                        // shortDescription
                KAboutData::License_GPL,                                                        // licenseType
                "(c) 2006 Hans van Leeuwen\n(c) 2008 Armin Berres",                             // copyrightStatement statement
                I18N_NOOP("Ksshaskpass allows you to interactively prompt users for a passphrase for ssh-add"), // text
                "http://www.kde-apps.org/content/edit.php?content=50971",                       // homePageAddress
                "trigger@space-based.de"                                                        // bugsEmailAddress
        );
        about.addAuthor("Armin Berres", 0, "trigger@space-based.de");
        about.addAuthor("Hans van Leeuwen", 0, "hanz@hanz.nl");

	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions( options );
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	KApplication app;


	// Disable Session Management and DCOP. We don't need it.
	app.disableSessionManagement();
	app.disableAutoDcopRegistration();


	// Declare variables
	QString walletFolder = about.appName();
	QString dialog = I18N_NOOP("Please enter password");	// Default dialog text
	QString keyFile;
	QCString password;

	
	// Parse commandline arguments
	if ( args->count() > 0 ) {
		dialog = args->arg(0);
		keyFile = dialog.section(" ", -2).remove(":");
	}
	args->clear();


	// Open KWallet to see if a password was previously stored.
	KWallet::Wallet *wallet = KWallet::Wallet::openWallet( KWallet::Wallet::NetworkWallet(), 0 );

	if ( wallet && wallet->hasFolder(walletFolder) ) {
		wallet->setFolder(walletFolder);

		QString retrievedPass;

		wallet->readPassword(keyFile, retrievedPass);

		if ( retrievedPass ) {
			password = retrievedPass;
		}
	}


	// Password could not be retrieved from wallet. Open password dialog
	if ( !password ) {
		// create the password dialog, but only show "Enable Keep" button, if the wallet is opened
		KPasswordDialog *kpd = new KPasswordDialog(KPasswordDialog::Password, wallet, 0);
		kpd->setPrompt(dialog);
		kpd->setCaption(i18n("Ksshaskpass"));
		kpd->setAllowEmptyPasswords(false);
		// We don't want to dump core when the password dialog is shown, because it could contain the entered password.
		kpd->disableCoreDumps();

		if ( kpd->exec() == KDialog::Accepted ) {
			password = kpd->password();
		}

		// If "Enable Keep" is enabled, open/create a folder in KWallet and store the password.
		if ( password && wallet && kpd->keep() ) {
			if ( !wallet->hasFolder( walletFolder ) ) {
				wallet->createFolder(walletFolder);
			}
			wallet->setFolder(walletFolder);
			wallet->writePassword(keyFile, password);
		}

		delete kpd;
	}

	// Close the wallet if it is opened.
	if (wallet) {
		KWallet::Wallet::closeWallet( KWallet::Wallet::NetworkWallet(), false );
	}

	// Finally return the password if one has been entered
        if (password) {
          std::cout << password;
	  return 0; 
	} else {
	  return 1;
	}
}
