/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net http://www.ieduca.net/                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "sociogram.h"
#include "geometria.h"
#include "sociometrictest.h"
#include <qpainter.h>
#include <qcolor.h>
#include <qfontmetrics.h> 
#include <qpen.h>
#include <qmessagebox.h>
//#include <iostream.h> // para sacar con cout
#include <qpoint.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qtextstream.h> // para las qWarning
#include <qprinter.h>
#include <kprinter.h>
#include <qpaintdevicemetrics.h>
#include <klocale.h>
#include <math.h> //gcc >=3.3 no la encuentra
#include <stdlib.h> //gcc >=3.3 no la encuentra
#include <qapplication.h>

#ifndef RAND_MAX
#  define RAND_MAX 32767
#endif

#define PI 3.1415927

sociogram::sociogram( QWidget *parent2, const char *name2, QPainter *myPainter2, sociometricTest *myTest2 )
    : QWidget( parent2, name2 ), myTest(myTest2), parent(parent2), name(name2), myPainter(myPainter2)
{
isPaintEvent=FALSE;
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/
myTest->setTarea("strongElection",FALSE);
myTest->setTarea("weakElection",FALSE);
myTest->setTarea("strongRejection",FALSE);
myTest->setTarea("weakRejection",FALSE);
myTest->setTarea("reciprocalElection",FALSE);
myTest->setTarea("reciprocalRejection",FALSE);
myTest->setTarea("reciprocalElectionAndRejection",FALSE);
}
    
    
    
sociogram::~sociogram()
{
}





void sociogram::paintEvent( QPaintEvent *)
{

//impide que se actualice el paint mientras se est dentro de esta funcion
if (isPaintEvent) return;
else isPaintEvent=TRUE;
//debug
//qWarning (name);

if (strcmp(name, "sIndividual")==0) 
{

    myPainter->begin( this );
    drawIndividualSociogram( myTest, 0, 0);
    drawMeaning(QRect (QPoint(this->width()-(this->width()-this->height())+15,qRound(this->height()/1.5)),QPoint(this->width()-15,this->height()-15))); // el +/-15 es para que no quede pegado al borde
    drawSociometricValueSignificant (QRect (QPoint(this->width()-(this->width()-this->height())+15,qRound(this->height()/4)),QPoint(this->width()-15,qRound(this->height()/1.8))));
    myPainter->end();
    myPainter->flush();
}




/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/


    
if (strcmp(name, "sGroup")==0) 
{    

    myPainter->begin( this );
    drawGroupSociogram( myTest, 0, 0);
    drawMeaning(QRect (QPoint(this->width()-(this->width()-this->height())+15,qRound(this->height()/1.5)),QPoint(this->width()-15,this->height()-15))); // el +/-15 es para que no quede pegado al borde
    myPainter->end();
    myPainter->flush();
}
    
    
isPaintEvent=FALSE;
}



void sociogram::mousePressEvent( QMouseEvent *e)
{
}




void sociogram::mouseMoveEvent( QMouseEvent *e)
{
}






/*dibuja en el painter el sociograma indivudial
entradas:
idStudent: numero del alumno central del sociograma individual
myTest: objeto que contiene el test sociomtrico
paint: el painter donde dibujar
x,y coordenadas de la esquina superior izquierda del cuadrado que incluye el sociograma
numZones: numero de zonas concentricas en que se divide el sociograma
*/
void sociogram::drawIndividualSociogram(sociometricTest *myTest, double x=0.0, double y=0.0)
{
int idStudent=myTest->getStudentShow();

setRelativeFirstZone(qRound(3*numZones/10));
//myPainter->begin( this );


QPen myPen = myPainter->pen();
myPen.setWidth(2);
myPen.setStyle(Qt::SolidLine);


// bucle para dibujar circulos y nmeros con los colores oportunos
QString text;
QColor *color=new QColor(255,255,255);
int dc=qRound((double)255/(numZones+1));

for (int c=numZones-1+relativeFirstZone;c>=relativeFirstZone;c--)
{
    color->setRgb(color->red()-dc/3,color->green()-dc/2,color->blue()-dc/3);
    //myPainter->setBrush(color->light(150));
    myPainter->setBrush(QColor(color->red(),color->green(),color->blue()));
    myPen.setColor(Qt::black);
    myPainter->setPen(myPen);
    myPainter->drawEllipse ( qRound(x+longZone*(numZones-1+relativeFirstZone-c)), qRound(y+longZone*(numZones-1+relativeFirstZone-c)), qRound(2*longZone*c), qRound(2*longZone*c) );
    text = text.setNum(qRound((numZones-1)/2+0.5)-c+relativeFirstZone);
    if ((qRound((numZones-1)/2+0.5)-c+relativeFirstZone)>=0) text = " +"+text; else text = " "+text;
    myPen.setColor(Qt::black);
    myPainter->setPen(myPen);
    QFont myFont( "helvetica", 12, QFont::Bold );
    myPainter->setFont(myFont);
    myPainter->drawText ( qRound(x+longZone*(numZones-1+relativeFirstZone-c)), qRound(y+radioSociogram), text, -1);
};



// simbolo del alumno en analisis
drawSimbol (myTest->getSexoAlumno (idStudent), myTest->getIdentificativoAlumno (idStudent), qRound(radioSociogram), qRound(radioSociogram), qRound(simbolDiameter));






// resto de los simbolos distribuidos por el sociograma individual
double angle=0;
int dsocio;
double r;
int xf,yf;
geometria *myGeometria = new geometria();

for (int c=1; c<=myTest->getNumeroAlumnosGrupo(); c++)
{
        if (c!=idStudent) 
        {
        angle=angle + (2*PI)/(myTest->getNumeroAlumnosGrupo()-1);
        

        // distancia sociometrica entre idStudent y c
        dsocio=myTest->getDistSociometrica(idStudent, c);
        r=(qRound((numZones-1)/2)+relativeFirstZone-dsocio)*longZone+longZone/2;
        xf= qRound(radioSociogram+r*cos(angle));
        yf= qRound(radioSociogram-r*sin(angle));
        drawSimbol (myTest->getSexoAlumno (c), myTest->getIdentificativoAlumno (c), xf, yf, qRound(simbolDiameter));
        
        
        
        
        
        
        // reducimos el segmento en  -longZone  (negativa porque es reducir)
        
        QRect coord = myGeometria->segRedim( -longZone, QRect(QPoint(qRound(radioSociogram),qRound(radioSociogram)),QPoint(xf,yf)) );
        int x3=coord.left();
        int y3=coord.top();
        int x4=coord.right();
        int y4=coord.bottom();
        
        int xin=x3;
        int yin=y3;
        int xfn=x4;
        int yfn=y4;
        
         for (int c2=1;c2<=myTest->getNumeroElecciones();c2++)
         {
             
             

             QString typeArrow;
             // para las resupuestas de idStudent
             if (myTest->getEleccion(idStudent,c2)==c) 
             {
             coord = myGeometria->segParal ( +longZone/8, QRect (QPoint(xin,yin),QPoint(xfn,yfn)) );
             x3=coord.left();
             y3=coord.top();
             x4=coord.right();
             y4=coord.bottom();
             drawArrow (x3,y3,x4,y4, "ELECCION");
             }
             
             if (myTest->getRechazo(idStudent,c2)==c) 
             {
             coord = myGeometria->segParal ( -longZone/8, QRect (QPoint(xin,yin),QPoint(xfn,yfn)) );
             x3=coord.left();
             y3=coord.top();
             x4=coord.right();
             y4=coord.bottom();
             drawArrow (x3,y3,x4,y4, "RECHAZO");
             }
             
             if (myTest->getPercepcionEleccion(idStudent,c2)==c) 
             {
             coord = myGeometria->segParal ( +longZone/3, QRect (QPoint(xin,yin),QPoint(xfn,yfn)) );
             x3=coord.left();
             y3=coord.top();
             x4=coord.right();
             y4=coord.bottom();
             drawArrow (x3,y3,x4,y4, "PER_ELECCION");
             }
             
             
             if (myTest->getPercepcionRechazo(idStudent,c2)==c) 
             {
             coord = myGeometria->segParal ( -longZone/3, QRect (QPoint(xin,yin),QPoint(xfn,yfn)) );
             x3=coord.left();
             y3=coord.top();
             x4=coord.right();
             y4=coord.bottom();
             drawArrow (x3,y3,x4,y4, "PER_RECHAZO");
             }
             
             // para las respuestas de c
             if (myTest->getEleccion(c,c2)==idStudent)
             {
             coord = myGeometria->segParal ( +longZone/8, QRect (QPoint(xin,yin),QPoint(xfn,yfn)) );
             x3=coord.left();
             y3=coord.top();
             x4=coord.right();
             y4=coord.bottom();
             drawArrow (x4,y4,x3,y3, "ELECCION");
             }
             
             if (myTest->getRechazo(c,c2)==idStudent) 
             {
             coord = myGeometria->segParal ( -longZone/8, QRect (QPoint(xin,yin),QPoint(xfn,yfn)) );
             x3=coord.left();
             y3=coord.top();
             x4=coord.right();
             y4=coord.bottom();
             drawArrow (x4,y4,x3,y3, "RECHAZO");
             }
             
             
             if (myTest->getPercepcionEleccion(c,c2)==idStudent) 
             {
             coord = myGeometria->segParal ( +longZone/3, QRect (QPoint(xin,yin),QPoint(xfn,yfn)) );
             x3=coord.left();
             y3=coord.top();
             x4=coord.right();
             y4=coord.bottom();
             drawArrow (x4,y4,x3,y3, "PER_ELECCION");
             }
             
             
             if (myTest->getPercepcionRechazo(c,c2)==idStudent) 
             {
             coord = myGeometria->segParal ( -longZone/3, QRect (QPoint(xin,yin),QPoint(xfn,yfn)) );
             x3=coord.left();
             y3=coord.top();
             x4=coord.right();
             y4=coord.bottom();
             drawArrow (x4,y4,x3,y3, "PER_RECHAZO");
             }
             
             
             
             
             
             
         }
        }
}


delete myGeometria;
delete color;
//myPainter->end();
//myPainter->flush();

}














void sociogram::drawGroupSociogram( sociometricTest *myTest, double x=0.0, double y=0.0)
{
QString typeSociogram = myTest->getSociogramShow();
int cx[myTest->getNumeroAlumnosGrupo()];
int cy[myTest->getNumeroAlumnosGrupo()];

//
// ALGORITMO
//

if (typeSociogram!=QString::null)
{

    if (myTest->getTarea(typeSociogram)==FALSE)
        {  
	
	//muestra informacin sobre el clculo y la centra en pantalla
	QLabel *label2TabPage8 = new QLabel ( i18n("Time for calculation by ksociograma.\nThe process can be long, depending on the number\nof subjects into the group.\nPlease, be patient..."), this, 0, 0 );
	label2TabPage8->setGeometry ( 324, 201, 440, 176 );
	label2TabPage8->setFrameStyle( QFrame::Box | QFrame::Plain );
    	label2TabPage8->setAlignment( AlignHCenter | AlignVCenter );
	label2TabPage8->show();
	int iXpos=width()/2-label2TabPage8->width()/2;
        int iYpos=height()/2-label2TabPage8->height()/2;
        label2TabPage8->move(iXpos,iYpos);
        
        sociometricAlgoritm(cx, cy, 8, typeSociogram);
        myTest->setTarea(typeSociogram,TRUE);
	myTest->isChangedTest=TRUE;
	//parent->actSave->setEnabled(TRUE); //no funciona activarlo aqu pero
	//se activa desde ksociograma::slotGroupSociogramSelected(int value)
	//y todo funciona correctamente
        for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
		{
		myTest->setCx(c,typeSociogram,cx[c]);
		myTest->setCy(c,typeSociogram,cy[c]);
		}
        delete label2TabPage8;

        }
    else
        {
        for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
        {
        cx[c]=myTest->getCx(c,typeSociogram);
        cy[c]=myTest->getCy(c,typeSociogram);
        }
        }



// COMIENZA EL PINTADO DEL PAINT

//myPainter->begin( this );

setRelativeFirstZone(qRound(5*numZones/10));

QPen myPen = myPainter->pen();
myPen.setWidth(2);
myPen.setStyle(Qt::SolidLine);

QString text;
QColor color = QColor(255,255,255);
int dc=qRound((double)255/(numZones+1));

// dibuja los circulos concentricos
for (int c=numZones-1+relativeFirstZone;c>=relativeFirstZone;c--)
{
    color.setRgb(color.red()-dc/3,color.green()-dc/2,color.blue()-dc/3);
    //myPainter->setBrush(color->light(150));
    myPainter->setBrush(QColor(color.red(),color.green(),color.blue()));
    myPen.setColor(Qt::black);
    myPainter->setPen(myPen);
    
    
    if (c==relativeFirstZone or c==numZones-1+relativeFirstZone-relativeThirdZone or c==numZones-1+relativeFirstZone)
    {
    myPainter->drawEllipse ( qRound(x+longZone*(numZones-1+relativeFirstZone-c)), qRound(y+longZone*(numZones-1+relativeFirstZone-c)), qRound(2*longZone*c), qRound(2*longZone*c) );
    }

}




    
    

    
geometria myGeometria;


/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/


if (typeSociogram=="strongElection")
{
//ELECCIONES FUERTES
for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
{
for (int n=c+1;n<=myTest->getNumeroAlumnosGrupo();n++)
    {
                
                // reducimos el segmento en -longZone  (negativa porque es reducir)
                QRect coord = myGeometria.segRedim( -longZone, QRect(QPoint(cx[c],cy[c]),QPoint(cx[n],cy[n])) );
                int x3=coord.left();
                int y3=coord.top();
                int x4=coord.right();
                int y4=coord.bottom();
                //calculamos el segmento paralelo
                coord = myGeometria.segParal ( +longZone/8, QRect (QPoint(x3,y3),QPoint(x4,y4)) );
                x3=coord.left();
                y3=coord.top();
                x4=coord.right();
                y4=coord.bottom();
                
                

                                
                if (myTest->isElection(c,n)>0)
                    {
                    drawArrow (x3,y3,x4,y4, "ELECCION_FUERTE");
                    }
                
                if (myTest->isElection(n,c)>0)
                    {
                    drawArrow (x4,y4,x3,y3, "ELECCION_FUERTE");
                    }
                
                
            
        }
    }
}   


if (typeSociogram=="weakElection")
{
//ELECCIONES DEBILES
for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
{
for (int n=c+1;n<=myTest->getNumeroAlumnosGrupo();n++)
    {
                
                // reducimos el segmento en -longZone  (negativa porque es reducir)
                QRect coord = myGeometria.segRedim( -longZone, QRect(QPoint(cx[c],cy[c]),QPoint(cx[n],cy[n])) );
                int x3=coord.left();
                int y3=coord.top();
                int x4=coord.right();
                int y4=coord.bottom();
                //calculamos el segmento paralelo
                coord = myGeometria.segParal ( +longZone/8, QRect (QPoint(x3,y3),QPoint(x4,y4)) );
                x3=coord.left();
                y3=coord.top();
                x4=coord.right();
                y4=coord.bottom();
                
                

                                
                if (myTest->isElection(c,n)<0)
                    {
                    drawArrow (x3,y3,x4,y4, "ELECCION");
                    }
                
                if (myTest->isElection(n,c)<0)
                    {
                    drawArrow (x4,y4,x3,y3, "ELECCION");
                    }
                
            
        }
    }
}   





if (typeSociogram=="strongRejection")
{
//RECHAZOS FUERTES
for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
{
for (int n=c+1;n<=myTest->getNumeroAlumnosGrupo();n++)
    {
                
                // reducimos el segmento en -longZone  (negativa porque es reducir)
                QRect coord = myGeometria.segRedim( -longZone, QRect(QPoint(cx[c],cy[c]),QPoint(cx[n],cy[n])) );
                int x3=coord.left();
                int y3=coord.top();
                int x4=coord.right();
                int y4=coord.bottom();
                //calculamos el segmento paralelo
                coord = myGeometria.segParal ( +longZone/8, QRect (QPoint(x3,y3),QPoint(x4,y4)) );
                x3=coord.left();
                y3=coord.top();
                x4=coord.right();
                y4=coord.bottom();
                
                

                                
                if (myTest->isRejection(c,n)>0)
                    {
                    drawArrow (x3,y3,x4,y4, "RECHAZO_FUERTE");
                    }
                
                if (myTest->isRejection(n,c)>0)
                    {
                    drawArrow (x4,y4,x3,y3, "RECHAZO_FUERTE");
                    }
                
            
        }
    }
}   











if (typeSociogram=="weakRejection")
{
//RECHAZOS DEBILES
for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
{
for (int n=c+1;n<=myTest->getNumeroAlumnosGrupo();n++)
    {
                
                // reducimos el segmento en -longZone  (negativa porque es reducir)
                QRect coord = myGeometria.segRedim( -longZone, QRect(QPoint(cx[c],cy[c]),QPoint(cx[n],cy[n])) );
                int x3=coord.left();
                int y3=coord.top();
                int x4=coord.right();
                int y4=coord.bottom();
                //calculamos el segmento paralelo
                coord = myGeometria.segParal ( +longZone/8, QRect (QPoint(x3,y3),QPoint(x4,y4)) );
                x3=coord.left();
                y3=coord.top();
                x4=coord.right();
                y4=coord.bottom();
                
                

                                
                if (myTest->isRejection(c,n)<0)
                    {
                    drawArrow (x3,y3,x4,y4, "RECHAZO");
                    }
                
                if (myTest->isRejection(n,c)<0)
                    {
                    drawArrow (x4,y4,x3,y3, "RECHAZO");
                    }
                
            
        }
    }
}   
















if (typeSociogram == "reciprocalElection" or typeSociogram == "reciprocalElectionAndRejection")
{
//ELECCIONES RECIPROCAS
for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
{
for (int n=c+1;n<=myTest->getNumeroAlumnosGrupo();n++)
    {
        // para cada una de las elecciones de ambos!!!
        for (int ec=1;ec<=myTest->getNumeroElecciones();ec++)
        {
            for (int en=1;en<=myTest->getNumeroElecciones();en++)
            {
            //condicional para elecciones recprocas
            bool flagEleccionFuerte=FALSE;
            if (myTest->getEleccion(c,ec)==n and myTest->getEleccion(n,en)==c) 
                {
                if ((ec==1 or ec==2) and (en==1 or en==2)) flagEleccionFuerte=TRUE;
                // reducimos el segmento en -longZone  (negativa porque es reducir)
                QRect coord = myGeometria.segRedim( -longZone, QRect(QPoint(cx[c],cy[c]),QPoint(cx[n],cy[n])) );
                int x3=coord.left();
                int y3=coord.top();
                int x4=coord.right();
                int y4=coord.bottom();
                //calculamos el segmento paralelo
                coord = myGeometria.segParal ( +longZone/8, QRect (QPoint(x3,y3),QPoint(x4,y4)) );
                x3=coord.left();
                y3=coord.top();
                x4=coord.right();
                y4=coord.bottom();
                
                

                                
                if (flagEleccionFuerte==FALSE)
                    {
                    drawArrow (x3,y3,x4,y4, "ELECCION");
                    drawArrow (x4,y4,x3,y3, "ELECCION");            
                    }
                if (flagEleccionFuerte==TRUE)
                    {
                    drawArrow (x3,y3,x4,y4, "ELECCION_FUERTE");
                    drawArrow (x4,y4,x3,y3, "ELECCION_FUERTE");
                    }
                
                }
            }
        }
    }
}   
}




    
if (typeSociogram=="reciprocalRejection" or typeSociogram=="reciprocalElectionAndRejection")
{    
//RECHAZOS RECIPROCAS
for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
{
for (int n=c+1;n<=myTest->getNumeroAlumnosGrupo();n++)
    {
        // para cada una de las elecciones de ambos!!!
        for (int ec=1;ec<=myTest->getNumeroElecciones();ec++)
        {
            for (int en=1;en<=myTest->getNumeroElecciones();en++)
            {
            //condicional para elecciones recprocas
            bool flagRechazoFuerte=FALSE;
            if (myTest->getRechazo(c,ec)==n and myTest->getRechazo(n,en)==c) 
                {
                if ((ec==1 or ec==2) and (en==1 or en==2)) flagRechazoFuerte=TRUE;
                // reducimos el segmento en -longZone  (negativa porque es reducir)
                QRect coord = myGeometria.segRedim( -longZone, QRect(QPoint(cx[c],cy[c]),QPoint(cx[n],cy[n])) );
                int x3=coord.left();
                int y3=coord.top();
                int x4=coord.right();
                int y4=coord.bottom();
                //calculamos el segmento paralelo
                coord = myGeometria.segParal ( +longZone/8, QRect (QPoint(x3,y3),QPoint(x4,y4)) );
                x3=coord.left();
                y3=coord.top();
                x4=coord.right();
                y4=coord.bottom();
                
                

                                
                if (flagRechazoFuerte==FALSE)
                    {
                    drawArrow (x3,y3,x4,y4, "RECHAZO");
                    drawArrow (x4,y4,x3,y3, "RECHAZO");            
                    }
                if (flagRechazoFuerte==TRUE)
                    {
                    drawArrow (x3,y3,x4,y4, "RECHAZO_FUERTE");
                    drawArrow (x4,y4,x3,y3, "RECHAZO_FUERTE");
                    }
                
                }
            }
        }
    }
}   
}


    
  
// dibujamos los simbolos de los alumnos

    for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
    {
    drawSimbol (myTest->getSexoAlumno (c), myTest->getIdentificativoAlumno (c), cx[c], cy[c], qRound(simbolDiameter));   
    }

    

} // fin del condicional de si existe typeSociogram

//myPainter->end( );
}


































void sociogram::drawSociometricValueSignificant (QRect rect)
{
//myPainter->begin(this);


int x1=rect.left ();
int y1=rect.top ();
//int x2=rect.right ();
//int y2=rect.bottom ();

int idStudent=myTest->getStudentShow();

QPen myPen = myPainter->pen();
myPen.setColor(Qt::black);
myPen.setWidth(3);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);
myPainter->setBrush( Qt::white );

QFont myFont( "helvetica", 10, QFont::Bold );
QFontMetrics myFontMetric( myFont );
int pixelWidth = myFontMetric.width( i18n("SIGNIFICANTS SOCIOMETRICS VALUES") );
//int pixelHeight = myFontMetric.height( );
myPainter->setFont(myFont);
myPainter->drawText ( x1+rect.width()/2-pixelWidth/2, y1-10, i18n("SIGNIFICANTS SOCIOMETRICS VALUES"), -1); 
//  Sp, Sn, Ep, En, Pp, Pn, Ip, In
for (int c=0; c<=7;c++)
   {
   myPainter->setBrush( Qt::white );
   if (c==0 and (myTest->getSp(idStudent) >= myTest->getLimSup("Sp"))) myPainter->setBrush( QColor(100,100,255) );
   if (c==1 and (myTest->getSn(idStudent) >= myTest->getLimSup("Sn"))) myPainter->setBrush( QColor(100,100,255) );
   if (c==2 and (myTest->getEp(idStudent) >= myTest->getLimSup("Ep"))) myPainter->setBrush( QColor(100,100,255) );
   if (c==3 and (myTest->getEn(idStudent) >= myTest->getLimSup("En"))) myPainter->setBrush( QColor(100,100,255) );

   if (c==0 and (myTest->getSp(idStudent) <= myTest->getLimInf("Sp"))) myPainter->setBrush( QColor(255,100,100) );
   if (c==1 and (myTest->getSn(idStudent) <= myTest->getLimInf("Sn"))) myPainter->setBrush( QColor(255,100,100) );
   if (c==2 and (myTest->getEp(idStudent) <= myTest->getLimInf("Ep"))) myPainter->setBrush( QColor(255,100,100) );
   if (c==3 and (myTest->getEn(idStudent) <= myTest->getLimInf("En"))) myPainter->setBrush( QColor(255,100,100) );
   
   if (c==4 and (myTest->getPp(idStudent) >= myTest->getLimSup("Pp"))) myPainter->setBrush( QColor(100,100,255) );
   if (c==5 and (myTest->getPn(idStudent) >= myTest->getLimSup("Pn"))) myPainter->setBrush( QColor(100,100,255) );
   if (c==6 and (myTest->getIp(idStudent) >= myTest->getLimSup("Ip"))) myPainter->setBrush( QColor(100,100,255) );
   if (c==7 and (myTest->getIn(idStudent) >= myTest->getLimSup("In"))) myPainter->setBrush( QColor(100,100,255) );

   
   if (c==4 and (myTest->getPp(idStudent) <= myTest->getLimInf("Pp"))) myPainter->setBrush( QColor(255,100,100) );
   if (c==5 and (myTest->getPn(idStudent) <= myTest->getLimInf("Pn"))) myPainter->setBrush( QColor(255,100,100) );
   if (c==6 and (myTest->getIp(idStudent) <= myTest->getLimInf("Ip"))) myPainter->setBrush( QColor(255,100,100) );
   if (c==7 and (myTest->getIn(idStudent) <= myTest->getLimInf("In"))) myPainter->setBrush( QColor(255,100,100) );
  
   if (c>=0 and c<=3) myPainter->drawRoundRect ( x1+c*rect.width()/4, y1, rect.width()/4, rect.height()/2, 25, 25 ) ;
   if (c>=4 and c<=7) myPainter->drawRoundRect ( x1+(c-4)*rect.width()/4, y1+rect.height()/2, rect.width()/4, rect.height()/2, 25, 25 ) ;

   
   
   
   
   
   
   // LETRAS DE LOS VALORES ESTADISTICOS
   
   if (c==0) 
   {
   pixelWidth = myFontMetric.width( "Sp" ); 
   myPainter->drawText ( x1+c*rect.width()/4+rect.width()/4/2-pixelWidth/2, y1+rect.height()/2/2, "Sp", -1);
   }
   if (c==1) 
   {
   pixelWidth = myFontMetric.width( "Sn" ); 
   myPainter->drawText ( x1+c*rect.width()/4+rect.width()/4/2-pixelWidth/2, y1+rect.height()/2/2, "Sn", -1);
   }
   if (c==2) 
   {
   pixelWidth = myFontMetric.width( "Ep" ); 
   myPainter->drawText ( x1+c*rect.width()/4+rect.width()/4/2-pixelWidth/2, y1+rect.height()/2/2, "Ep", -1);
   }
   if (c==3) 
   {
   pixelWidth = myFontMetric.width( "En" ); 
   myPainter->drawText ( x1+c*rect.width()/4+rect.width()/4/2-pixelWidth/2, y1+rect.height()/2/2, "En", -1);
   }
   if (c==4) 
   {
   pixelWidth = myFontMetric.width( "Pp" ); 
   myPainter->drawText ( x1+(c-4)*rect.width()/4+rect.width()/4/2-pixelWidth/2, y1+3*rect.height()/2/2, "Pp", -1);
   }
   if (c==5) 
   {
   pixelWidth = myFontMetric.width( "Pn" ); 
   myPainter->drawText ( x1+(c-4)*rect.width()/4+rect.width()/4/2-pixelWidth/2, y1+3*rect.height()/2/2, "Pn", -1);
   }
   if (c==6) 
   {
   pixelWidth = myFontMetric.width( "Ip" ); 
   myPainter->drawText ( x1+(c-4)*rect.width()/4+rect.width()/4/2-pixelWidth/2, y1+3*rect.height()/2/2, "Ip", -1);
   }
   if (c==7) 
   {
   pixelWidth = myFontMetric.width( "In" ); 
   myPainter->drawText ( x1+(c-4)*rect.width()/4+rect.width()/4/2-pixelWidth/2, y1+3*rect.height()/2/2, "In", -1);
   }
   
   
   }
   

// SIGNIFICADO DE LOS COLORES
myPen.setWidth(0);

myPainter->setBrush( QColor(255,100,100) );
myPainter->drawRect ( x1, y1+rect.height()+4, 16, 16) ;
myPainter->drawText ( x1+24, y1+rect.height()+16, i18n("Low and significat"),-1);
   
myPainter->setBrush( QColor(100,100,255) );
myPainter->drawRect ( x1, y1+rect.height()+20, 16, 16) ;
myPainter->drawText ( x1+24, y1+rect.height()+32, i18n("High and significat"),-1);
   
}





void sociogram::drawMeaning(QRect rect)
{

int x1=rect.left ();
int y1=rect.top ();
//int x2=rect.right ();
//int y2=rect.bottom ();


QPen myPen = myPainter->pen();
myPen.setColor(Qt::black);
myPen.setWidth(3);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);
myPainter->setBrush( Qt::white );


//borde
myPainter->drawRoundRect ( x1, y1, rect.width(), rect.height(), 25, 25 );

QFont myFont( "helvetica", 10, QFont::Bold );
QFontMetrics myFontMetric( myFont );
int pixelWidth = myFontMetric.width( i18n("MEANING OF SYMBOLS.") );
//int pixelHeight = myFontMetric.height( );
myPainter->setFont(myFont);
myPainter->drawText ( x1+rect.width()/2-pixelWidth/2, y1-10, i18n("MEANING OF SYMBOLS."), -1); 



int margenX=0;
int margenY=0;

drawSimbol ("Hombre", "XY", x1+longZone+margenX, y1+margenY+1*rect.height()/8, simbolDiameter);
myPainter->drawText ( qRound(x1+longZone+margenX+longZone), qRound(y1+margenY+1*rect.height()/8), i18n("Male"), -1); 

drawSimbol ("Mujer",  "XX", x1+longZone+margenX+5*longZone, y1+margenY+1*rect.height()/8, simbolDiameter);
myPainter->drawText ( qRound(x1+longZone+margenX+longZone+5*longZone), qRound(y1+margenY+1*rect.height()/8), i18n("Female"), -1); 

drawArrow(x1+longZone+margenX, y1+margenY+2*rect.height()/8, x1+longZone+margenX+rect.width()/5, y1+margenY+2*rect.height()/8, "ELECCION");
myPainter->drawText ( qRound(x1+longZone+margenX+rect.width()/5+longZone), qRound(y1+margenY+2*rect.height()/8), i18n("Election"), -1); 
   
drawArrow(x1+longZone+margenX, y1+margenY+3*rect.height()/8, x1+longZone+margenX+rect.width()/5, y1+margenY+3*rect.height()/8, "RECHAZO");
myPainter->drawText ( qRound(x1+longZone+margenX+rect.width()/5+longZone),qRound( y1+margenY+3*rect.height()/8), i18n("Rejection"), -1); 
   
drawArrow(x1+longZone+margenX, y1+margenY+4*rect.height()/8, x1+longZone+margenX+rect.width()/5, y1+margenY+4*rect.height()/8, "ELECCION_FUERTE");
myPainter->drawText ( qRound(x1+longZone+margenX+rect.width()/5+longZone),qRound( y1+margenY+4*rect.height()/8), i18n("Strong election"), -1); 
   
drawArrow(x1+longZone+margenX, y1+margenY+5*rect.height()/8, x1+longZone+margenX+rect.width()/5, y1+margenY+5*rect.height()/8, "RECHAZO_FUERTE");
myPainter->drawText ( qRound(x1+longZone+margenX+rect.width()/5+longZone),qRound( y1+margenY+5*rect.height()/8), i18n("Strong rejection"), -1); 
   
drawArrow(x1+longZone+margenX, y1+margenY+6*rect.height()/8, x1+longZone+margenX+rect.width()/5, y1+margenY+6*rect.height()/8, "PER_ELECCION");
myPainter->drawText ( qRound(x1+longZone+margenX+rect.width()/5+longZone),qRound( y1+margenY+6*rect.height()/8), i18n("Perception of election"), -1); 
   
drawArrow(x1+longZone+margenX, y1+margenY+7*rect.height()/8, x1+longZone+margenX+rect.width()/5, y1+margenY+7*rect.height()/8, "PER_RECHAZO");
myPainter->drawText ( qRound(x1+longZone+margenX+rect.width()/5+longZone),qRound( y1+margenY+7*rect.height()/8), i18n("Perception of rejection"), -1); 
   
}

















/*dibuja un simbolo incluyendo la cadena con su identificativo
x,y son los valores donde se dibujar el punto central del simbolo
*/
void sociogram::drawSimbol(QString sex, QString identificativ, double x, double y, double side)
{




// se averiguan las coordenadas de la esquina superior izquierda del cuadrado que incluye al simbolo
int leftTopX=qRound(x-side/2);
int leftTopY=qRound(y-side/2);

QPen myPen = myPainter->pen();
myPen.setColor(Qt::black);
myPen.setWidth(0);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);

if (sex=="Mujer") 
{

myPainter->setBrush( Qt::green );
myPainter->drawEllipse(leftTopX,leftTopY,qRound(side),qRound(side));
}
else if (sex=="Hombre")
{
myPainter->setBrush( Qt::yellow );
myPainter->drawEllipse(leftTopX,leftTopY,qRound(side),qRound(side));
}
else  // no se sabe si es hombre o mujer
{
myPainter->setBrush( Qt::white );
myPainter->drawEllipse(leftTopX,leftTopY,qRound(side),qRound(side));
}


//debug
//double angle = getAngle(x, y, radioSociogram, radioSociogram);
//identificativ=identificativ.setNum(angle,'f',2);
//double zone = getZone(x, y, radioSociogram, radioSociogram);
//identificativ=identificativ.setNum(zone,'f',2);



QFont myFont( "helvetica", 8, QFont::Normal ); //QFont::Bold
QFontMetrics myFontMetric( myFont );
int pixelWidth = myFontMetric.width( identificativ );
int pixelHeight = myFontMetric.height( );
myPainter->setFont(myFont);
myPainter->drawText ( leftTopX+qRound((side-pixelWidth)/2), leftTopY+qRound((side+pixelHeight-1)/2-0.5), identificativ, -1);


}














//********************************************************************************************************************
// dibuja las flechas que van desde x1,y1 hasta x2,y2
// la entrada tipo es una cadena con este significado:
// ELECCION: flecha azul continua
// RECHAZO: fecha roja continua
// PER_ELECCION: fecha azul discontinua
// PER_RECHAZO: fecha roja discontinua
void sociogram::drawArrow(double x1, double y1, double x2, double y2, QString typeArrow)
{
//Geometry *myGeometry = Geometry();


QPen myPen = myPainter->pen();
myPen.setColor(Qt::black);
myPen.setWidth(0);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);


if (typeArrow=="ELECCION") 
{
myPen.setColor(Qt::blue);
myPen.setWidth(0);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);
};

if (typeArrow=="ELECCION_FUERTE")
{
myPen.setColor(Qt::blue);
myPen.setWidth(2);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);
};


if (typeArrow=="RECHAZO")
{
myPen.setColor(Qt::red);
myPen.setWidth(0);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);
};

if (typeArrow=="RECHAZO_FUERTE")
{
myPen.setColor(Qt::red);
myPen.setWidth(2);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);
};

if (typeArrow=="PER_ELECCION")
{
myPen.setColor(Qt::blue);
myPen.setWidth(0);
myPen.setStyle(Qt::DotLine);
myPainter->setPen(myPen);
};

if (typeArrow=="PER_RECHAZO")
{
myPen.setColor(Qt::red);
myPen.setWidth(0);
myPen.setStyle(Qt::DotLine);
myPainter->setPen(myPen);
};



// esta es la linea principal de la flecha
myPainter->drawLine(qRound(x1),qRound(y1),qRound(x2),qRound(y2));


// la punta de la flecha se construye con lineas normales siempre
myPen.setWidth(0);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);

geometria *myGeometria = new geometria();


// se repite varias veces para que se rellene todo el hueco de la flecha del color de la flecha

for (int c=1;c<=10;c++)
    {
    QRect coord  = myGeometria->arrCoord (PI/6, c, QRect ( QPoint (qRound(x1),qRound(y1)) , QPoint (qRound(x2),qRound(y2)) ) );
    int x3=coord.left();
    int y3=coord.top();
    int x4=coord.right();
    int y4=coord.bottom();
    
    myPainter->drawLine(qRound(x2),qRound(y2),qRound(x3),qRound(y3));
    myPainter->drawLine(qRound(x2),qRound(y2),qRound(x4),qRound(y4));
    myPainter->drawLine(qRound(x3),qRound(y3),qRound(x4),qRound(y4));
    }


delete myGeometria;
}








/*!
cx[] yx[] son los centros de los simbolos
Se evalua la posicin de los simbolos en el sociograma. Si estn 
solapados o cercano 0 puntos,
y si estn ms distantes  de minDist 1 punto
 */
double sociogram::evaluatePosition(int cx[], int cy[], QString typeSociogram)
{
double value = 0;
double longitud = 0;
double minDist = 3.5*longZone;

geometria myGeometria;

for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
{
   for (int n=c+1;n<=myTest->getNumeroAlumnosGrupo();n++)
   {
      longitud = myGeometria.segLong (QRect(QPoint(cx[c],cy[c]),QPoint(cx[n],cy[n])));
      //cout << c << ":" << n << "=" << longitud << "\n";
      
      
      
      
      if (longitud >= minDist) 
      {
      
      
          
          
// condicional de si existe la relacion entre c y n del tipo especificado
// en el tipo de sociograma de grupo                   
if ( (typeSociogram=="strongElection" and (myTest->isElection(c,n)>0 or myTest->isElection(n,c)>0)) or (typeSociogram=="strongRejection" and (myTest->isRejection(c,n)>0 or myTest->isRejection(n,c)>0)) or (typeSociogram=="weakElection" and (myTest->isElection(c,n)<0 or myTest->isElection(n,c)<0)) or (typeSociogram=="weakRejection" and (myTest->isRejection(c,n)<0 or myTest->isRejection(n,c)<0)) or (typeSociogram=="reciprocalElection" and (myTest->isReciprocalElection(n,c)!=0)) or (typeSociogram=="reciprocalRejection" and (myTest->isReciprocalRejection(n,c)!=0)) or (typeSociogram=="reciprocalElectionAndRejection" and (myTest->isReciprocalElection(n,c)!=0 or myTest->isReciprocalRejection(n,c)!=0)) )
          {
          
            //evaluar:
            // dar puntos a sujetos relacionados inversamente proporcional a la
            // distancia que los separa
            if (longitud>0)
            value = value +  (simbolDiameter*simbolDiameter)/(longitud*longitud);
          
          
          
          
          
              //buble para ver si el segmento que une a los relacionados corta 
              //al simbolo de algun otro elemento
              bool isCut = FALSE;
              for (int m=1; m<=myTest->getNumeroAlumnosGrupo(); m++)
              {
                    //condicional de corte del segmento con los simbolos de otros sujetos
                    if ( (myGeometria.isSegmentCuted(QRect(QPoint(cx[m]-qRound(simbolDiameter/2),cy[m]-qRound(simbolDiameter/2)),QPoint(cx[m]+qRound(simbolDiameter/2),cy[m]+qRound(simbolDiameter/2))),QRect(QPoint(cx[c],cy[c]),QPoint(cx[n],cy[n])))==TRUE) or (myGeometria.isSegmentCuted(QRect(QPoint(cx[m]+qRound(simbolDiameter/2),cy[m]-qRound(simbolDiameter/2)),QPoint(cx[m]-qRound(simbolDiameter/2),cy[m]+qRound(simbolDiameter/2))),QRect(QPoint(cx[c],cy[c]),QPoint(cx[n],cy[n])))==TRUE) )
                    {
                    isCut = TRUE; break;
                    } 
               }
               if (isCut == TRUE) value = value - 10;
            }
          
      }      
      else 
      {
         value = value - 50;  
      }
   }
}

return value;
}













/*!
    valores iniciales
    nota: no se pueden poner en el constructor porque hasta que 
    no est construido el objeto no podemos ejecutar resize, 
    y nunca tendramos el windowRectangle
    Por tanto, esta funcin se llama *solo* una vez
    y justo *despues* del resize inicial
 */
void sociogram::initialValues()
{
//QRect windowRectangle = myPainter->window();
numZones = 10;
//radioSociogram = (double)windowRectangle.height()/2; //radio
radioSociogram = this->height()/2;
//radioSociogram = 200;
relativeFirstZone=qRound(3*numZones/10);
relativeThirdZone=qRound(2*numZones/10);
longZone = radioSociogram/(numZones-1+relativeFirstZone); //d
simbolDiameter = longZone*1.20; 
}


/*!
    asigna el numero tamao del primer circulo 
    las unidades son zonas
 */
void sociogram::setRelativeFirstZone(int value)
{
relativeFirstZone = value;
longZone = radioSociogram/(numZones-1+relativeFirstZone); //d
simbolDiameter = longZone*1.20; 
}




























/*!
    ALGORITMO FUNDAMENTAL
 */
void sociogram::sociometricAlgoritm(int cx[], int cy[], int variants, QString typeSociogram)
{

srand(8041965);

int zone;
double angle;

// vectores para el mximo
int maxRotationCx[myTest->getNumeroAlumnosGrupo()];
int maxRotationCy[myTest->getNumeroAlumnosGrupo()];
int maxLocalCy[myTest->getNumeroAlumnosGrupo()];
int maxLocalCx[myTest->getNumeroAlumnosGrupo()];
int maxVariantCx[myTest->getNumeroAlumnosGrupo()];
int maxVariantCy[myTest->getNumeroAlumnosGrupo()];
int tmpCx[myTest->getNumeroAlumnosGrupo()];
int tmpCy[myTest->getNumeroAlumnosGrupo()];


double maxVariant;
double maxLocal;
double maxRotation;

/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/

QString parameter;
if (typeSociogram == "strongElection") parameter = "Sp";
if (typeSociogram == "weakElection") parameter = "Sp";
if (typeSociogram == "strongRejection") parameter = "Sn";
if (typeSociogram == "weakRejection") parameter = "Sn";
if (typeSociogram == "reciprocalElection") parameter = "Sp";
if (typeSociogram == "reciprocalRejection") parameter = "Sn";
if (typeSociogram == "reciprocalElectionAndRejection") parameter = "Sp"; //en este ltimo hay que elegir entre Sp o Sn de forma arbitraria, porque lo dos es imposible.



maxVariant= -99999999;
// PRIMER BUCLE: LAS VARIANTES
for (int v=1;v<=variants;v++)
{



//GENERAMOS UNA POSICION INICIAL DE FORMA ALEATORIA


// calculamos la posicin aleatoria de cada simbolo en el sociograma
    for (int c=1; c<=myTest->getNumeroAlumnosGrupo(); c++)
    {
       // asignacin de zona aleatoria
       zone = randZone(c, parameter);        
        
       // asignacion de angulo aleatorio 
       angle = randAngle(c, zone);    
     
       double r=zone*longZone-longZone/2;
       maxLocalCx[c]= qRound(radioSociogram+r*cos(angle));
       maxLocalCy[c]= qRound(radioSociogram-r*sin(angle));
    
    }        

//maxLocal=-999999;
maxLocal=evaluatePosition(maxLocalCx,maxLocalCy, typeSociogram);

//busqueda del mximo local
for (int local=1;local<=30;local++)
{


     
maxRotation=-99999999;
// BUBLE: LAS RAMAS (UNA RAMA PARA CADA SUJETO DEL GRUPO)
for (int b=1;b<=myTest->getNumeroAlumnosGrupo();b++)
{

qApp->processEvents();


// BUBLE ROTACIONES: PROBAMOS LAS POSICIONES CERCANAS DE CADA SUJETO
for (int rotacion=-20;rotacion<=20;rotacion++)
{
    if (rotacion==0) continue;
  
   
    zone = getZone(maxLocalCx[b],maxLocalCy[b],qRound(radioSociogram),qRound(radioSociogram));
    angle = getAngle(maxLocalCx[b],maxLocalCy[b],qRound(radioSociogram),qRound(radioSociogram));  
    
    double tmpAngle = rotateAngle(myTest->getSexoAlumno(b), zone, angle, rotacion);
    int tmpZone = rotateZone(maxLocalCx[b],maxLocalCy[b], rotacion);
    
    if (tmpAngle == angle and tmpZone == zone) continue;

    angle=tmpAngle;
    zone=tmpZone;


    // ponemos la posicion guardada antes de la rotacion: el maximo local
    // en una matriz temporal para realizar las rotaciones
    for (int cont=1; cont<=myTest->getNumeroAlumnosGrupo(); cont++)
        {
        tmpCx[cont]=maxLocalCx[cont];
        tmpCy[cont]=maxLocalCy[cont];
        }
    
    
    //QString s;
    //qWarning(s.setNum(rotacion));
    
    
        
    
    double r=zone*longZone-longZone/2;
    
    tmpCx[b]= qRound(radioSociogram+r*cos(angle));
    tmpCy[b]= qRound(radioSociogram-r*sin(angle));
      
        
      
   // EVALUACION DE LA POSICION
   double evaluation = evaluatePosition(tmpCx, tmpCy, typeSociogram);
   

    if (evaluation > maxRotation) 
        {
        maxRotation = evaluation;        
        // guardamos los vectores con el mximo en esta rotacion
        for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
            {
            maxRotationCx[c]=tmpCx[c];
            maxRotationCy[c]=tmpCy[c];
            }
        //debug
        //QString s,ss;
        //qWarning("maxRotation "+s.setNum(local)+" = "+ss.setNum(maxRotation,'f',3));

        }

        
        


}; //cierra el bucle rotacion 

}; // cierra bucle estudiantes (ramas)



if (maxRotation>maxLocal) 
        {
        // introducimos los vectores mximos en los vectores de trabajo, ya que es 
        //este el que se devuleve o bien sirve como punto de partida para una nueva
        // interacion en el bucle del mximo local
        
        maxLocal=maxRotation;
        //guardamos el mximo encontrado en los vectoes x y
        for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
            {
            maxLocalCx[c]=maxRotationCx[c];
            maxLocalCy[c]=maxRotationCy[c];
            }
        
        //debug
        //QString s;
        //qWarning("maxLocal="+s.setNum(maxLocal,'f',3));
            
            
            
        }




}; // cerramos el bucle de busqueda del mximo local    
    
 

if (maxLocal>maxVariant)
        {
        maxVariant=maxLocal;
        for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
            {
            maxVariantCx[c]=maxLocalCx[c];
            maxVariantCy[c]=maxLocalCy[c];
            }        
        }
        

        //debug
        //QString s,ss;
        //qWarning("maxVariant " + ss.setNum(v) + " = " + s.setNum(maxVariant,'f',3));

    
}; // cierra buble variantes



//finalmente la solucion se la damos a los vectores referenciados en la entrada



        for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
            {
            cx[c]=maxVariantCx[c];
            cy[c]=maxVariantCy[c];
            }







}











/*!
    sale la zona en la que est el sujeto con coordenadas x,y (origen en ox, oy)
    La salida comienza en 0 para la primera zona
 */
int sociogram::getZone(double x, double y, double ox, double oy)
{
geometria myGeometria;  
double dist = myGeometria.longPointToOrigin(x , y, ox, oy);
return 1+(int)(dist/longZone);
}












/*!
    \fn sociogram::getAngle(int x, int y);
 */
double sociogram::getAngle(double x, double y, double ox, double oy)
{
//La funcin atan2 retorna el arco tangente de y/x, en el intervalo [-PI, +PI] radianes.
//ademas hay que tener en cuena que el origen de coordenadas se encuentra el eje y alreves
// funcionan comprobada y parece que funciona bien!!!!!!!!!!!!
double angle = atan2(oy-y,x-ox);
while (angle>=2*PI) {angle = angle-2*PI;};
while (angle <   0) {angle = angle+2*PI;};
return angle;
}


/*!
    \fn sociogram::randZone(int alumno, QString parametro)
 */
int sociogram::randZone(int alumno, QString parametro)
{

double limSup = myTest->getLimSup(parametro);
double limInf = myTest->getLimInf(parametro);


// zonas intermedias
if (limSup > myTest->getSociometricValue(parametro, alumno) and limInf < myTest->getSociometricValue(parametro, alumno))
{
return relativeFirstZone + 1 + qRound ((numZones-2-relativeThirdZone)*(double)rand()/(double)RAND_MAX);
}

// zonas interiores
else if (limSup < myTest->getSociometricValue(parametro, alumno)) 
{
return 0 + qRound (relativeFirstZone*(double)rand()/(double)RAND_MAX);
}


// zonas exteriores
else if (limInf > myTest->getSociometricValue(parametro, alumno)) 
{
return (numZones + relativeFirstZone - relativeThirdZone) + qRound ((relativeThirdZone - 1)*(double)rand()/(double)RAND_MAX);        
}

else return -1; //caso de error en la entrada

}















/*!
//busca el angulo adecuado segun el sexo para separarlos.
//los angulos son valores discretos entre unos posible

// calculo aleatorio de los angulos
// pero posibilidades discretas dentro de cada zona
// si la zona es mas larga, ms simbolos
 */
double sociogram::randAngle(int alumno, int zone)
{
geometria *myGeometria = new geometria();
double manAngle = (double)2*PI*myTest->getNumeroAlumnosSexo("Hombre")/(double)myTest->getNumeroAlumnosGrupo();
double numSimbols;

if (myTest->getSexoAlumno(alumno)=="Hombre")
    {
    numSimbols=myGeometria->arcLong(manAngle,zone*longZone-longZone/2) / simbolDiameter;
    delete myGeometria;
    return qRound(0.5+numSimbols*(double)rand()/(double)RAND_MAX)*manAngle/numSimbols;
    }
else
    {
    numSimbols=myGeometria->arcLong(2*PI-manAngle,zone*longZone-longZone/2) / simbolDiameter;
    delete myGeometria;
    return manAngle + qRound(0.5+numSimbols*(double)rand()/(double)RAND_MAX)*(2*PI-manAngle)/numSimbols;
    }

}

/*!
    nos indica el angulo consecutivo a uno dado para un determinado alumno
    giro puede ser -1 para la izquierda  1 para la derecha
    tambien giro puede ser menor que -1 o mayor que +1, trasladandose tantas
    veces como indique giro en las posiciones posibles.
    si no es posible el nuevo angulo consecutivo, se traslada al otro extremo del sector circular
 */
double sociogram::rotateAngle(QString sex, int zone, double angle, int giro)
{
while (angle<0) angle=angle+2*PI;
while (angle>=2*PI) angle=angle-2*PI;


geometria myGeometria;
double manAngle = (double)2*PI*myTest->getNumeroAlumnosSexo("Hombre")/(double)myTest->getNumeroAlumnosGrupo();
double womanAngle = 2*PI-manAngle;
double numSimbols;
double nAngle;

if (sex == "Hombre" and manAngle>0)
    {
        numSimbols=myGeometria.arcLong(manAngle,zone*longZone-longZone/2) / simbolDiameter ;
        if (numSimbols==0) {qWarning("Error: numSimbols no puede valer 0 en funcin rotateAngle()");};
        nAngle=angle*numSimbols/manAngle;
        nAngle=nAngle+giro;
        if (nAngle > numSimbols) return angle; //{nAngle=nAngle-numSimbols;}
        if (nAngle < 0) return angle; //{nAngle=nAngle+numSimbols;}
        return (nAngle*manAngle/numSimbols);
    }

    
else if (sex == "Mujer" and womanAngle>0)
    {
        numSimbols= myGeometria.arcLong(womanAngle,zone*longZone-longZone/2) / simbolDiameter ;
        if (numSimbols==0) {qWarning("Error: numSimbols no puede valer 0 en funcin rotateAngle()");};
        nAngle=(angle-manAngle)*numSimbols/womanAngle;
        nAngle=nAngle+giro;
        if (nAngle > numSimbols) return angle; //{nAngle=nAngle-numSimbols;}
        if (nAngle < 0) return angle; //{nAngle=nAngle+numSimbols;}
        return (manAngle+nAngle*womanAngle/numSimbols);
    }

else {qWarning("Error: Funcin rotateAngle() acaba en error");}       
return angle;    
}




/*!
  devuelve la nueva zona incrementado o decrementado en tantas zonas como indica giro
 */
int sociogram::rotateZone(double x, double y, int giro)
{
int zone=getZone(x,y,radioSociogram,radioSociogram);
if (levelZone(zone)==0 or levelZone(zone)!=levelZone(zone+giro)) return zone;
else return zone+giro;
}




















/*!
   return:
   0: the input zone is bad
   1: zona interior
   2: zona intermedia
   3: zona exterior
 */
int sociogram::levelZone(int zone)
{



//zona interior
if ((zone>=0) and (zone<=relativeFirstZone)) return 1;

//zonas intermedias
else if ((zone>=relativeFirstZone + 1) and (zone<=relativeFirstZone + 1 + numZones-2-relativeThirdZone)) return 2;

//zona exterior
else if ((zone>=numZones + relativeFirstZone - relativeThirdZone) and (zone<=numZones + relativeFirstZone -1 )) return 3;


//error en los datos de entrada porque el parametro 
//zone es <0 o >numZones + relativeFirstZone-1 
else return 0;

}










/*!
    imprime el ttulo del sociograma
 */
void sociogram::drawTitle(int x, int y, QString title)
{

QPen myPen = myPainter->pen();
myPen.setColor(Qt::black);
myPen.setWidth(3);
myPen.setStyle(Qt::SolidLine);
myPainter->setPen(myPen);
myPainter->setBrush( Qt::white );


QFont myFont( "helvetica", 10, QFont::Bold );
myPainter->setFont(myFont);
myPainter->drawText (x,y, title,-1);


}
