/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net http://www.ieduca.net/                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "geometria.h"
#include <qrect.h>
#include <math.h>
#include <qpoint.h>

#define PI 3.1415927

geometria::geometria()
{
}


geometria::~geometria()
{
}


// redimensiona un segmento a una longitud (dist) dada.
QRect geometria::segRedim (double dist, QRect coord)
{

int x1=coord.left();
int y1=coord.top();
int x2=coord.right();
int y2=coord.bottom();

int x3=qRound(x1+dist*cos(atan2((y1-y2),(x1-x2))));
int y3=qRound(y1+dist*sin(atan2((y1-y2),(x1-x2))));
int x4=qRound(x2-dist*cos(atan2((y1-y2),(x1-x2))));
int y4=qRound(y2-dist*sin(atan2((y1-y2),(x1-x2))));

return QRect ( QPoint(x3,y3) , QPoint(x4,y4) );
};

// devuelve las coordenadas de un segmento paralelo a uno dado a una distancia dada
//******************************************************************************
QRect geometria::segParal (double dist, QRect coord)
{
int x1=coord.left();
int y1=coord.top();
int x2=coord.right();
int y2=coord.bottom();

double ang = atan2(x2-x1,y2-y1);
int x3=qRound(x1-dist*cos(ang));
int y3=qRound(y1+dist*sin(ang));
int x4=qRound(x2-dist*cos(ang));
int y4=qRound(y2+dist*sin(ang));

return QRect ( QPoint(x3,y3) , QPoint(x4,y4) );
};


// devuelve las coordenadas de la punta de la flecha
//******************************************************************************
QRect geometria::arrCoord (double ang, double dist, QRect coord)
{
int x1=coord.left();
int y1=coord.top();
int x2=coord.right();
int y2=coord.bottom();

double  betaAng = atan2(y2-y1,x2-x1);
double gammaAng = ang/2+betaAng;
double    muAng = -ang/2+betaAng;
   
int x3 = qRound(x2-dist*cos(gammaAng));
int y3 = qRound(y2-dist*sin(gammaAng));
int x4 = qRound(x2-dist*cos(muAng));
int y4 = qRound(y2-dist*sin(muAng));





return QRect ( QPoint(x3,y3) , QPoint(x4,y4) );


};






// devuelve la longitud de un segmento en pixel
//******************************************************************************
double geometria::segLong (QRect coord)
{
int x1=coord.left();
int y1=coord.top();
int x2=coord.right();
int y2=coord.bottom();

return sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
};


// devuelve las coordenadas del punto de corte de dos rectas definidas por pares de puntos en QRect,
// si devuelve QPoint(0,0) es que no ha habdo corte
// en este caso, mejor probar primero isLineCuted()
//******************************************************************************
QPoint geometria::linesCutPoint (QRect coordA, QRect coordB)
{
double xa1=coordA.left();
double ya1=coordA.top();
double xa2=coordA.right();
double ya2=coordA.bottom();

double xb1=coordB.left();
double yb1=coordB.top();
double xb2=coordB.right();
double yb2=coordB.bottom();

double denom = (ya1-ya2)*(xb1-xb2)-(yb1-yb2)*(xa1-xa2);
// caso de segmento incluidos en rectas paralelas sin punto de corte
if (denom==0) return QPoint(0,0);

double numer = (ya1-ya2)*(xb1-xb2)*xa1-(yb1-yb2)*(xa1-xa2)*xb1+(xa1-xa2)*(xb1-xb2)*(yb1-ya1);
int x = qRound(numer/denom);
int y;

// para evitar problemas de division por 0 pruebo una ecuacion o la otra de la recta para calcular y del punto de corte
if ((xa1-xa2)!=0) 
    {
    y = qRound((ya1-ya2)/(xa1-xa2)*(numer/denom)+ya1-(ya1-ya2)/(xa1-xa2)*xa1);
    }
else if ((xb1-xb2) !=0 )
    {
    y = qRound((yb1-yb2)/(xb1-xb2)*(numer/denom)+yb1-(yb1-yb2)/(xb1-xb2)*xb1);
    }
else 
    {
    return QPoint(0,0);
    }
return QPoint(x,y);  
} 






// devuelve las coordenadas del punto de corte de dos segmentos definidos por pares de puntos en QRect. // si devuelve QPoint(0,0) es que no ha habdo corte
//******************************************************************************
QPoint geometria::segmentsCutPoint (QRect coordA, QRect coordB)
{

//TODO !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

int xa1=coordA.left();
//int ya1=coordA.top();
int xa2=coordA.right();
//int ya2=coordA.bottom();

int xb1=coordB.left();
//int yb1=coordB.top();
int xb2=coordB.right();
//int yb2=coordB.bottom();

QPoint result1 = linesCutPoint (coordA , coordB);
QPoint result2; 

   // si hay corte en las rectas, se comprueba que el punto ese incluido en los dos segmentos. el punto QPoint(0,0) es el NULL
     if (result1.isNull()==FALSE)
     {     
        // si el punto de corte esta incluido en el segmento a
        if ((result1.x()>xa1) and (result1.x()>xa2)) 
        {
            result2.setX(0);
            result2.setY(0);
        }
        
        else if ((result1.x()<xa1) and (result1.x()<xa2)) 
        {
            result2.setX(0);
            result2.setY(0);
        }
        else 
        {
            result2.setX(result1.x());
            result2.setY(result1.y());
        };
        
        
        // si el punto de corte esta incluido en el segmento b
        if ((result1.x()>xb1) and (result1.x()>xb2)) 
        {
            result2.setX(0);
            result2.setY(0);
        }
        
        else if ((result1.x()<xb1) and (result1.x()<xb2)) 
        {
            result2.setX(0);
            result2.setY(0);
        }
        else 
        {
            result2.setX(result1.x());
            result2.setY(result1.y());
        };
        
     }
     else 
     {
        return result1;
     };
return result2;  
}
   
   







/*!
    calcula la logitud de un arco dado el angulo del arco y el radio
    (angulos en radianes)
 */
double geometria::arcLong(double ang, double radio)
{
while (ang>=2*PI) {ang = ang - 2*PI;}
while (ang<0) {ang = ang + 2*PI;}
    
//return 2*PI*radio/2/PI*ang;    
return radio*ang;
}


/*!
    salida: 
    < 0 rectas paralelas (no coincidentes)
    = 0 rectas coincidentes
    > 0 rectas que se cortan
 */
int geometria::isLineCuted (QRect coordA, QRect coordB)
{
// este algoritmo esta probado con varios casos y parece que funciona bien!!!!
double xa1=coordA.left();
double ya1=coordA.top();
double xa2=coordA.right();
double ya2=coordA.bottom();

double xb1=coordB.left();
double yb1=coordB.top();
double xb2=coordB.right();
double yb2=coordB.bottom();

// caso de rectas paralelas (no coincidentes)
// mirar la funcion linesCutPoint() para comprender esto
// importante el xor para ser no coincidentes
if ((xa1-xa2)==0 xor (xb1-xb2) ==0) return -1;


// caso rectas coincidentes
double denom = (ya1-ya2)*(xb1-xb2)-(yb1-yb2)*(xa1-xa2);
if (denom==0) return 0;


return 1;  
}















/*!
    salida: 
    true: hay corte en un nico punto incluido en los segmentos
    false: no hay corte o estn incluidos en la misma recta
 */
bool geometria::isSegmentCuted (QRect coordA, QRect coordB)
{

// lo he comprobado con varios valores posibles, y parece que funciona bien!!!!!!!!!

double xa1=coordA.left();
//double ya1=coordA.top();
double xa2=coordA.right();
//double ya2=coordA.bottom();

double xb1=coordB.left();
//double yb1=coordB.top();
double xb2=coordB.right();
//double yb2=coordB.bottom();

if (isLineCuted(coordA , coordB) < 0 ) return FALSE;
if (isLineCuted(coordA , coordB) ==0 ) return FALSE;

QPoint punto = linesCutPoint (coordA , coordB);

   // si hay corte en las rectas, se comprueba que el punto ese incluido en los dos
   // segmentos, porque puede ocurrir que el corte caiga fuera de los segmentos, o tambien
   // puede ocurrir que est slo en un segmento y no en el otro
        
        bool result=TRUE;
        
        // si el punto de corte esta incluido en el segmento a
        if ((punto.x()>xa1) and (punto.x()>xa2)) result = result & FALSE;
        else if ((punto.x()<xa1) and (punto.x()<xa2)) result = FALSE;
        else result = TRUE;
        
        
        // si el punto de corte esta incluido en el segmento b
        if ((punto.x()>xb1) and (punto.x()>xb2))   result = result & FALSE;
        else if ((punto.x()<xb1) and (punto.x()<xb2)) result = result & FALSE;
        else result = result & TRUE;

return result;   
}


/*!
    \fn geometria::longPointToOrigin(double x, double y)
 */
double geometria::longPointToOrigin(double x, double y, double ox, double oy)
{
return sqrt((x-ox)*(x-ox)+(oy-y)*(oy-y));
}
