//
// C++ Interface: translitplugin
//
// Description: 
//
//
// Author: Dominik Seichter <domseichter@web.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef TRANSLITPLUGIN_H
#define TRANSLITPLUGIN_H

#include "plugin.h"
#include "pluginloader.h"
#include "batchrenamer.h"

// QT includes
#include <qlabel.h>
#include <qlayout.h>
#include <qtextcodec.h>
#include <qvgroupbox.h>
#include <qcheckbox.h>

// KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kcombobox.h>
// #include <kdebug.h>

/**
@author Dominik Seichter
*/
class TranslitPlugin : public Plugin {
    Q_OBJECT
    public:
        const QString getName() const;
        const QString getAccelName() const;
        const int type() const;
        const QPixmap getIcon() const;
        void drawInterface( QWidget* w, QVBoxLayout* l );
        void finished();
        bool checkError();
        void fillStructure();
        QString processFile( BatchRenamer*, int, QString token, int );
        TranslitPlugin();
    protected:
        QString translit(const QString &);

        typedef QMap<QString, QString> TranslitMap;
        TranslitMap m_mapFromUTF8;
        
        static const QString m_strUtf8[];
        static const QString m_strEngl[];
};

#endif
