/***************************************************************************
                          myinputdialog.cpp  -  description
                             -------------------
    begin                : Mit Apr 01 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "myinputdialog.h"

#include <klineedit.h>
#include <kpushbutton.h>
#include <klocale.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>

MyInputDialog::MyInputDialog( QString filename, bool revertEnabled, QWidget* parent )
    : QDialog( parent, 0, true, 0 )
{
    // I do not think this has to be translated
    setCaption( "KRename" );

    MyInputDialogLayout = new QVBoxLayout( this, 11, 6, "MyInputDialogLayout");
    Layout = new QHBoxLayout( 0, 0, 6, "Layout");

    TextLabel1 = new QLabel( this, "TextLabel1" );
    TextLabel1->setText( i18n( "Please input a new filename:" ) );

    text = new KLineEdit( this, "text" );
    text->setText( filename );

    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );

    buttonKrename = new KPushButton( this, "buttonKrename" );
    buttonKrename->setText( i18n( "&Revert Changes" ) );
    buttonKrename->setEnabled( revertEnabled );

    buttonFilename = new KPushButton( this, "buttonFilename" );
    buttonFilename->setText( i18n("Use &Input Filename") );

    buttonOk = new KPushButton( this, "buttonOk" );
    buttonOk->setText( i18n( "&Ok" ) );
    buttonOk->setDefault( true );

    buttonCancel = new KPushButton( this, "buttonCancel" );
    buttonCancel->setText( i18n( "&Cancel" ) );

    text->setFocus();

    Layout->addWidget( buttonKrename );
    Layout->addWidget( buttonFilename );
    Layout->addItem( spacer );
    Layout->addWidget( buttonOk );
    Layout->addWidget( buttonCancel );

    MyInputDialogLayout->addWidget( TextLabel1 );
    MyInputDialogLayout->addWidget( text );
    MyInputDialogLayout->addLayout( Layout );

    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonKrename, SIGNAL( clicked() ), this, SLOT( krename() ) );
    connect( buttonFilename, SIGNAL( clicked() ), this, SLOT( slotFilename() ) );

    QToolTip::add( buttonKrename, i18n("Use the filename that is generated by "
                                       "KRename instead of your changes." ) );
}

MyInputDialog::~MyInputDialog()
{ }

 QString MyInputDialog::filename() const
{
    return text->text();
}

void MyInputDialog::accept()
{
    if( text->text().isEmpty() )
        reject();
    else
        done( OK );
}

void MyInputDialog::reject()
{
    done( CANCEL );
}

void MyInputDialog::krename()
{
    done( USE_KRENAME );
}

void MyInputDialog::slotFilename()
{
    text->setText( m_oldfilename );
}

