//
// C++ Interface: kpgsearchdialog
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGSEARCHDIALOG_H
#define KPGSEARCHDIALOG_H

#include "kpgsearchdialogbase.h"

#include <qlineedit.h>
#include <qcheckbox.h>

/**
Search dialog

@author Lumir Vanek
*/

class KPGSearchDialog : public KPGSearchDialogBase
{
	Q_OBJECT
public:
    KPGSearchDialog(QWidget * pParent, const char * pszName = 0, bool bModal = true);
    ~KPGSearchDialog();

		QString getSearchString() const { return m_pEditSearchedString->text(); }
		bool getOIDs() const { return m_pCheckBoxOIDs->isChecked(); }
		bool getInNames() const { return m_pCheckBoxNames->isChecked(); }
		
protected:
		/** Enables/Disables the "Find"-button. */
		void toggleAcceptButton();

protected slots:
		/** Called when text in edit line is changed */
		virtual void slotTextChanged(const QString & );

    /** Called on a change of the "find in" checkbuttons. */
		virtual void slotFindInChanged(int);
};

#endif
