//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgrestoredatabasewizard.h"

#include <qframe.h>
#include <kiconloader.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <klocale.h>
#include <kdebug.h>

#include <dcopclient.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qtextedit.h>

#include "konsoleviewwidget.h"


KPGRestoreDatabaseWizard::KPGRestoreDatabaseWizard(QWidget *parent, 
    const char *name, 
    DCOPClient *pDcopClient, 
    const QString &strDatabase, 
    const QString &strHostname, 
    const QString &strPort, 
    const QString &strUsername,
    bool bCreateFromDump)
 : KPGRestoreDatabaseWizardBase(parent, name)
{
    m_pDcopClient = pDcopClient;
    m_strDatabase = strDatabase;
    m_strHostname = strHostname;
    m_strPort = strPort;
    m_strUsername = strUsername;
    m_bCreateFromDump = bCreateFromDump;
    
    m_pPartManager = new KParts::PartManager(this);
    
    QVBoxLayout *pLayout = new QVBoxLayout(m_pFrameConsole);
    
    m_pConsoleWidget = new KonsoleViewWidget(m_pPartManager, m_pFrameConsole);
    connect(m_pPartManager, SIGNAL(activePartChanged(KParts::Part*)), m_pConsoleWidget, SLOT(activePartChanged(KParts::Part*)));
    
    connect(m_pConsoleWidget, SIGNAL(sigProcessExited()), this, SLOT(slotProcessExited()));
    
    pLayout->addWidget(m_pConsoleWidget);
    
    m_pConsoleWidget->setIcon( SmallIcon("konsole") );
    m_pConsoleWidget->setCaption(i18n("Konsole"));
    
    setNextEnabled(WizardPage1, false);
}


KPGRestoreDatabaseWizard::~KPGRestoreDatabaseWizard()
{
    delete m_pConsoleWidget;
    delete m_pPartManager;
}

// When this function called, initialize appropriate Wizard page
void KPGRestoreDatabaseWizard::showPage(QWidget *pPage)
{
    // call parent
    KPGRestoreDatabaseWizardBase::showPage(pPage);
    
    if(pPage == WizardPage2) 
    {
        
        QStrList listArguments = getRestoreArguments();
        QString strArguments("");  
        for(QStrListIterator it(listArguments); it.current(); ++it) 
        {    
            strArguments.append(*it);
            strArguments.append("\n");
        }
        
        m_pTextEditCommand->setText(strArguments);
    }
    
    if(pPage == WizardPage3) 
    {
        /**
         * @deprecated Remove later
        m_dcopTalkThread.setDcopClient(m_pDcopClient);
        m_dcopTalkThread.setCommand(m_pTextEditCommand->text());
        m_dcopTalkThread.start(); // send command to m_pConsoleWidget via DCOP
        m_dcopTalkThread.wait();
        */
        
        cancelButton()->setEnabled(false);
        setBackEnabled(WizardPage3, false);
        setFinishEnabled(WizardPage3, false);
        
        m_pConsoleWidget->startProgram("pg_restore", getRestoreArguments());
    }
}

void KPGRestoreDatabaseWizard::slotInputFileChanged(const QString &strInputFile)
{
    setNextEnabled(WizardPage1, !strInputFile.isEmpty());
}

void KPGRestoreDatabaseWizard::slotOnlyDataToggled(bool bToggled)
{
    m_pCheckBoxOnlySchema->setEnabled(!bToggled);
    m_pCheckBoxDisableTriggers->setEnabled(bToggled);
}

void KPGRestoreDatabaseWizard::slotOnlySchemaToggled(bool bToggled)
{
    m_pCheckBoxOnlyData->setEnabled(!bToggled);
} 

void KPGRestoreDatabaseWizard::slotProcessExited()
{
    cancelButton()->setEnabled(true);
    setBackEnabled(WizardPage3, true);
    setFinishEnabled(WizardPage3, true);
}

QStrList KPGRestoreDatabaseWizard::getRestoreArguments() const
{
    QStrList listArguments;
        
    listArguments.append("pg_restore"); 
    listArguments.append("--dbname=" + m_strDatabase);
    listArguments.append("--host=" + m_strHostname);  
    listArguments.append("--port=" + m_strPort);  
    listArguments.append("--username=" + m_strUsername);
    
    if(m_pCheckBoxOnlyData->isChecked())
        listArguments.append("--data-only");  
    
    if(m_pCheckBoxOnlySchema->isChecked())
        listArguments.append("--schema-only");
        
    if(m_pCheckBoxClean->isChecked())
        listArguments.append("--clean");
        
    if(m_pCheckBoxExitOnError->isChecked())
        listArguments.append("--exit-on-error");  
        
    if(m_bCreateFromDump)
        listArguments.append("--create");
            
    if(m_pCheckBoxIgnoreVersion->isChecked())
        listArguments.append("--ignore-version");
        
    if(m_pCheckBoxNoOwner->isChecked())
        listArguments.append("--no-owner");
        
    if(m_pCheckBoxVerbose->isChecked())
        listArguments.append("--verbose");
    
    if(m_pCheckBoxNoPrivileges->isChecked())
        listArguments.append("--no-acl");
    
    if(m_pCheckBoxDisableTriggers->isChecked())
        listArguments.append("--disable-triggers");  
        
    if(m_pCeckBoxSetSessionAuth->isChecked())
        listArguments.append("--use-set-session-authorization");   
    
    listArguments.append(m_pURLRequesterInputFile->url());
            
    return listArguments;
}

/*
const QString KPGRestoreDatabaseWizard::getCommand() const
{
    QString strCommand("pg_restore ");
        
    strCommand.append(" --dbname=" + m_strDatabase);
    
    strCommand.append(" --host=" + m_strHostname);  
    strCommand.append(" --port=" + m_strPort);  
    strCommand.append(" -U " + m_strUsername);  
    
    if(m_pCheckBoxOnlyData->isChecked())
        strCommand.append(" --data-only");  
    
    if(m_pCheckBoxOnlySchema->isChecked())
        strCommand.append(" --schema-only");   
        
    if(m_pCheckBoxClean->isChecked())
        strCommand.append(" --clean");
        
    if(m_pCheckBoxExitOnError->isChecked())
        strCommand.append(" --exit-on-error");  
        
    if(m_bCreateFromDump)
        strCommand.append(" --create");
            
    if(m_pCheckBoxIgnoreVersion->isChecked())
        strCommand.append(" --ignore-version");
        
    if(m_pCheckBoxNoOwner->isChecked())
        strCommand.append(" --no-owner");
        
    if(m_pCheckBoxVerbose->isChecked())
        strCommand.append(" --verbose");
    
    if(m_pCheckBoxNoPrivileges->isChecked())
        strCommand.append(" --no-acl");
    
    if(m_pCheckBoxDisableTriggers->isChecked())
        strCommand.append(" --disable-triggers");  
        
    if(m_pCeckBoxSetSessionAuth->isChecked())
        strCommand.append(" --use-set-session-authorization");   
    
    strCommand.append(" " + m_pURLRequesterInputFile->url());
            
    return strCommand;
}

*/

#include "kpgrestoredatabasewizard.moc"
