//
// C++ Interface: kpgcreateviewwidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCREATEVIEWWIDGET1_H
#define KPGCREATEVIEWWIDGET1_H

#include "kpgcreateviewwidget1base.h"

class KPGDatabase; 
class QListViewItem;

/**
Widget for create view Wizard

@author Lumir Vanek
*/

class KPGCreateViewWidget1 : public KPGCreateViewWidget1Base
{
	Q_OBJECT
public:
    KPGCreateViewWidget1(QWidget *parent, const char *name,  KPGDatabase *, QPtrList<QListViewItem> &);
    ~KPGCreateViewWidget1();

	const QString getSQL() const;
	void refreshAvailTablesList(const QString &);
	bool isDirty1() const { return m_bIsDirty1; }
	bool isDirty2() const { return m_bIsDirty2; }
	bool isDirty3() const { return m_bIsDirty3; }
	void clearDirty1() { m_bIsDirty1 = false; }
	void clearDirty2() { m_bIsDirty2 = false; }
	void clearDirty3() { m_bIsDirty3 = false; }
		
protected slots:

    virtual void slotViewNameChanged(const QString &);
	virtual void slotSchemaActivated(const QString &);
	virtual void slotAvailableTablesSelectChanged(QListBoxItem*);
	virtual void slotViewTablesSelectChanged(QListViewItem*);
	virtual void slotTableAdd();
	virtual void slotTableDelete();
		
protected:
    KPGDatabase *m_pDatabase;
	bool m_bIsDirty1; // table columns list changed ?
	bool m_bIsDirty2; // table columns list changed ?
	bool m_bIsDirty3; // table columns list changed ?
				
signals:
	void sigEnableNextButton(bool);
};

#endif
