//
// C++ Interface: kpg4stepswizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPG4STEPSWIZARD_H
#define KPG4STEPSWIZARD_H

#include "kpg4stepswizardbase.h"

class KPGSyntaxHighlighter;
class KPGConnection;

/**
  * Wizard with 4 steps
  *
  * @author Lumir Vanek
  */
class KPG4StepsWizard : public KPG4StepsWizardBase
{
	Q_OBJECT
public:
    KPG4StepsWizard(QWidget *parent = 0, const char *name = 0);
    ~KPG4StepsWizard();

	// Set connection to database
	void setConnection(KPGConnection *);

	// Return connection
    KPGConnection * connection() const { return m_pConnection; }
		
	QWidget * pageWidget1() { return m_pPageWidget1; }
	QWidget * pageWidget2() { return m_pPageWidget2; }

protected:
	
    // Run SQL query - as final Wizard operation
    void runQuery(bool = true);
    			
protected:
	
	QWidget *m_pPageWidget1;
	QWidget *m_pPageWidget2;

private:  
	
    // Connection to database
	KPGConnection *m_pConnection;
		
  	// Syntax highlighter for m_pTextEditSQL
	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
	
	// Noticications list
	QStringList m_listOfNotifications;
				
protected slots:
	
	// Enable/disable next button for 1st page
	void slotEnableNextButton1(bool);

	// Enable/disable next button for 2nd page
	void slotEnableNextButton2(bool);
	
	// Process notice from connection
	void slotProcessNotice(const QString &);
};

#endif
