//
// C++ Interface: kpgcompletionbox
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCOMPLETIONBOX_H
#define KPGCOMPLETIONBOX_H

#include <klistbox.h>

#include "../DbObjects/kpgtreeitem.h"
#include "../Wizards/kpgtablecolumnwizinfo.h"

/**
  * Completion box for KPGSqlEdit. Based on KDE KCompletionBox,
  * but changed for using inside KTextEdit
  *
  *	@author Lumir Vanek <lvanek@users.sourceforge.net>
  * @deprecated
  */
class KPGCompletionBox : public KListBox
{
    Q_OBJECT
public:
    /**
     * Constructs a KPGCompletionBox.
     *
     * The parent widget is used to give the focus back when pressing the
     * up-button on the very first item.
     */
    KPGCompletionBox( QWidget *parent, const char *name = 0 );

    /**
     * Destroys the box
     */
    ~KPGCompletionBox();

    virtual QSize sizeHint() const;

    /**
     * @returns true if selecting an item results in the emition of the selected signal.
     *
     */
    bool activateOnSelect() const;

public slots:
    /**
     * Returns a list of all items currently in the box.
     */
    QStringList items() const;

    /**
     * Inserts @p items into the box. Does not clear the items before.
     * @p index determines at which position @p items will be inserted.
     * (defaults to appending them at the end)
     */
    //void insertItems(const QStringList&, int index = -1);

    /**
     * Clears the box and inserts @p items.
     */
     void setItems(const QStringList&, const KPGOidNameList &);
     void setItems(const QStringList&, const KPGOidNameAliasesList &);
     void setItems(const QStringList&, const KPGListTableColumns &);

    /**
     * Adjusts the size of the box to fit the width of the parent given in the
     * constructor and pops it up at the most appropriate place, relative to
     * the parent.
     *
     * Depending on the screensize and the position of the parent, this may
     * be a different place, however the default is to pop it up and the
     * lower left corner of the parent.
     *
     * Make sure to hide() the box when appropriate.
     */
    virtual void popup();

    /**
     * Makes this widget (when visible) capture Tab-key events to traverse the
     * items in the dropdown list.
     *
     * Default off, as it conflicts with the usual behavior of Tab to traverse
     * widgets. It is useful for cases like Konqueror's Location Bar, though.
     *
     * @see isTabHandling
     */
    void setTabHandling( bool enable );

    /**
     * @returns true if this widget is handling Tab-key events to traverse the
     * items in the dropdown list, otherwise false.
     *
     * Default is false.
     *
     * @see setTabHandling
     */
    bool isTabHandling() const;

    /**
     * Sets the text to be emitted if the user chooses not to
     * pick from the available matches.
     *
     * If the canceled text is not set through this function, the
     * userCancelled signal will not be emitted.
     *
     * @see userCancelled( const QString& )
     * @param txt  the text to be emitted if the user cancels this box
     */
    void setCancelledText( const QString& txt);

    /**
     * @returns the text set via setCancelledText() or QString::null.
     */
    QString cancelledText() const;

    /**
     * Set whether or not the selected signal should be emitted when an
     * item is selected. By default the selected signal is emitted.
     *
     * @param state false if the signal should not be emitted.
     */
    void setActivateOnSelect(bool state);


    /**
     * Moves the selection one line down or select the first item if nothing is selected yet.
     */
    void down();

    /**
     * Moves the selection one line up or select the first item if nothing is selected yet.
     */
    void up();

    /**
     * Moves the selection one page down.
     */
    void pageDown();

    /**
     * Moves the selection one page up.
     */
    void pageUp();

    /**
     * Moves the selection up to the first item.
     */
    void home();

    /**
     * Moves the selection down to the last item.
     */
    void end();

    /**
     * Re-implemented for internal reasons.  API is unaffected.
     */
    virtual void show();

    /**
     * Re-implemented for internal reasons.  API is unaffected.
     */
    virtual void hide();

signals:
    /**
     * Emitted when an item was selected, contains the text of
     * the selected item.
     */
    void activated( const QString& );

    /**
     * Emitted whenever the user chooses to ignore the available
     * selections and close the this box.
     */
    void userCancelled( const QString& );

protected:
    /**
     * This calculates the size of the dropdown and the relative position of the top
     * left corner with respect to the parent widget. This matches the geometry and position
     * normally used by K/QComboBox when used with one.
     */
    QRect calculateGeometry() const;

    /**
     * This properly sizes the listbox.
     */
    void calculateSize();

    /**
     * Reimplemented from KListBox to get events from the viewport (to hide
     * this widget on mouse-click, Escape-presses, etc.
     */
    virtual bool eventFilter( QObject *, QEvent * );

protected slots:
	
    /**
     * Called when an item was activated. Emits
     * activated() with the item.
     */
    virtual void slotActivated( QListBoxItem * );

private slots:
    void slotSetCurrentItem( QListBoxItem *i ) { setCurrentItem( i ); } 
    void slotCurrentChanged();
    void canceled();
    void slotItemClicked( QListBoxItem * );

protected:
    virtual void virtual_hook( int id, void* data );

private:
	
    QWidget *m_parent; // necessary to set the focus back
    QString cancelText;
    bool tabHandling;
    bool down_workaround;
    bool upwardBox;
    bool emitSelected;
};


class KPGCompletionBoxItem : public QListBoxPixmap
{
public:

    KPGCompletionBoxItem(KPGCompletionBox * listbox, const QPixmap & pix, const QString & text)
    : QListBoxPixmap(listbox, pix, text ) {;}
        
    KPGCompletionBoxItem(KPGCompletionBox * listbox, const QPixmap & pix, const QString & text, QListBoxItem* after)
    :  QListBoxPixmap(listbox, pix, text, after) {;}

    KPGCompletionBoxItem(const QPixmap & pix, const QString & text)
    : QListBoxPixmap(pix, text)  {;}

    //Returns true if dirty.
    bool reuse(const QString& newText)
    {
        if(text() == newText)
            return false;
            
        setText(newText);
        return true;
    }
};

#endif
