//
// C++ Implementation: kpglanguagesfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpglanguagesfolder.h"

#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpglanguage.h"
#include "kpgdatabase.h"


KPGLanguagesFolder::KPGLanguagesFolder(KPGDatabase *parent)
	: KPGItemsFolder(parent, i18n("Languages"), m_pIconFolderYellowClosed, m_pIconFolderYellowOpen)
{
}


KPGLanguagesFolder::~KPGLanguagesFolder()
{
}

void KPGLanguagesFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items 
    while (QListViewItem * pItem = firstChild())
        delete pItem;

	// obtain list of languages
    QString strQuery("SELECT lan.oid, lan.lanname, lanpltrusted, lanacl, hp.oid AS procoid, hp.proname as langproc, vp.oid AS validoid, vp.proname as langvalidator ");
	strQuery.append("FROM pg_catalog.pg_language lan ");
	strQuery.append("JOIN pg_catalog.pg_proc hp on hp.oid=lanplcallfoid ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_proc vp on vp.oid=lanvalidator ");
	strQuery.append("WHERE lanispl IS TRUE ");
	strQuery.append("ORDER BY lanname");
			
    KPGConnection *pConnection = connection();
    try
    {
        m_pqxxResultLanguages = pConnection->runQuery(strQuery);
    
        KPGLanguage *pLanguage = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultLanguages.size(); ++i)
        {
            pqxx::oid oid;
            m_pqxxResultLanguages[i][0].to(oid);
            
            if(pLanguage == 0)
                pLanguage = new KPGLanguage(this, m_pqxxResultLanguages[i]["lanname"].c_str(), oid);
            else
                pLanguage = new KPGLanguage(this, pLanguage, m_pqxxResultLanguages[i]["lanname"].c_str(), oid);
                    
            pLanguage->setProperties(m_pqxxResultLanguages[i]); 
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(pConnection, e.what(), strQuery);
    } 
}

