//
// C++ Implementation: kpgconversion
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgconversion.h"

// include files for KDE
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>

#include "kpgconversionsfolder.h"


KPGConversion::KPGConversion(KPGConversionsFolder *parent, const QString name, pqxx::oid _oid)
  : KPGObject(parent, name, _oid)
{
    setPixmap(0, *m_pIconConversion);
}

KPGConversion::KPGConversion(KPGConversionsFolder *parent, KPGConversion *after, const QString name, pqxx::oid _oid)
  : KPGObject(parent, after, name, _oid)
{
    setPixmap(0, *m_pIconConversion);
}

KPGConversion::~KPGConversion()
{
}

void KPGConversion::setProperties(const pqxx::result::tuple &pqxxTuple)
{
	pqxxTuple["condefault"].to(m_bIsDefault);
    pqxxTuple["conprocoid"].to(m_oidConversionProcedure);
            
    m_strSourceEncoding = pqxxTuple["fromencoding"].c_str();
	m_strDestinationEncoding = pqxxTuple["toencoding"].c_str();
 	m_strConversionProcedure = pqxxTuple["proname"].c_str();
	m_strOwner = pqxxTuple["owner"].c_str();	
}



