/***************************************************************************
                          kpogreview.h  -  description
                             -------------------
    begin                : Fre Sep  7 16:06:25 CEST 2001
    copyright            : (C) 2002 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPOGREVIEW_H
#define KPOGREVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for libpgxx 
#include <pqxx/util> 

#include <qvaluelist.h>
#include <qvaluestack.h>

//includes files for KDE
#include <kmdimainfrm.h>
#include <kparts/factory.h> // KPart Factory
#include <kate/view.h>      // Katepart view

// application specific includes
#include "DbObjects/kpgtableindex.h"
#include "kpgactionsstates.h"
#include "DataTable/kpgdatatable.h"

// forward declaration of the KPoGre classes
class KPoGreController;
class KPGConfiguration;
class KPGBookmarksButton;
class KPGPropertyPageChildView;
class KPGAbstractPropertyPage;
class KPGQueryResultChildView;
class KPGQueryResultWindow;
class KPGDataTableChildView;
class KPGDataTable;
class KPGExecutorChildView;
class KPGDebuggerChildView;
class KPGExecutor;
class KPGDebugger;
class KPGSchemaPropPage;
class KPGServer;
class KPGDatabase;
class KPGSchema;
class KPGTable;
class KPGFunction;
class KPGConnection;
class KPGKateXmlEditorDialog;

#define ID_STATUS_MSG 1

/**
  * Storage class for OID and their object path. 
  * Used for navigating through OIDs.
  * 
  * @author Lumir Vanek
  */
class KPGOidLink
{
public:
	KPGOidLink() {;} 
    KPGOidLink(pqxx::oid _oid, const QString & strPath)
	{
		m_oid = _oid;
		m_strPath = strPath;
	}
					
	~KPGOidLink() {;}

	// Return PostgreSQL row identifier
	const pqxx::oid oid() const { return m_oid; }
		
	// Return path
	const QString & path() const { return m_strPath; }
	
protected:

	QString m_strPath;

	// PostgreSQL row identifier
	pqxx::oid m_oid;		
};


/**
 * This class serves as the main window for KPoGre. 
 *
 * @short Main window class
 * @author Lumir Vanek
 */
class KPoGreView : public KMdiMainFrm
{
	Q_OBJECT
public:
    KPoGreView(KMdi::MdiMode mode);
    ~KPoGreView();
	
	static KPGConfiguration * configuration();
	
	// Enumerates all MDI childs view
	enum EMdiChildView { eMdiChildNone = 0, eMdiChildProperties, eMdiChildQueryResult, eMdiChildDataTable, eMdiChildExecutor, eMdiChildDebugger };
	
	// Save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration file
    void saveOptions();
    
    // Read general Options again and initialize all variables like the recent file list
    void readOptions();
    
    // Get the bookmarks button
    KPGBookmarksButton * getBookmarksButton() const { return m_pBookmarksButton; }  	
    
    // Create new KPGQueryResultChildView
    KPGQueryResultChildView * createQueryResultChildView(const QString &, const QString &, const QString &);
    
    // Create new KPGQueryResultChildView
    KPGQueryResultChildView * createQueryResultChildView(const QString &, const QString &);
    
    // Create new KPGPropertyPageChildView
    KPGPropertyPageChildView * createPropertyPageChildView(KPGTreeItem *);
    
    // Create new KPGDataTableChildView
    KPGDataTableChildView * createDataTableChildView(KPGConnection *, 
    	const QString &, 
    	const QString &, 
    	const ListTableColumns &,
    	const MapIndexKey &, 
    	const QString &, 
    	const QString &);
    
    // Create new KPGExecutorChildView
    KPGExecutorChildView * createExecutorChildView(KPGConnection *, const QString &, 
	KPGFunction *);
	
	// Create new KPGDebuggerChildView
    KPGDebuggerChildView * createDebuggerChildView(KPGConnection *, const QString &, 
	KPGFunction *);
    
    // Request to close active MDI child window
    bool requestClose();
    
    // Close application
    void close();

	// Create Kate part factory
	KParts::Factory* createKatePartFactory();
    
/////////////////////////////////////////////////////////////////////
//                     PROTECTED ATTRIBUTES
/////////////////////////////////////////////////////////////////////
protected:
	
	// Type of active MDI child view
	KPoGreView::EMdiChildView m_eActiveView;

	// KPoGreController is respond to handle most of user KAction's
	KPoGreController *m_pController;
	
	// View actions
	KAction* m_pActEditDeselect;
	KAction* m_pActViewNodeUp;
	KAction* m_pActViewNodeBack;
	KAction* m_pActViewNodeForward;
		
	// Left tree view that displays DB objects tree	
	QListView*  m_pViewTree;
	
	// Dialog for editing XMLs in Kate editor
	KPGKateXmlEditorDialog *m_pKateXmlEditorDialog;

	// Two stask for storing navigation history through OID links
	QValueStack<KPGOidLink> m_stackBackNodes;
	QValueStack<KPGOidLink> m_stackForwardNodes;	
  		
    // Our configuration 
	static KPGConfiguration* s_pKPGConfig;

    KPGBookmarksButton *m_pBookmarksButton;  	
  
  	// the configuration object of the application
    KConfig *config;
    
protected:  
   
    // Sets up the statusbar for the main window by initialzing a status label.
    void initStatusBar();
    
	// Change cursor look
	void setWaitCursor();
	void setNormalCursor();
	
	// Update menu and tollbars regards to active MDI child view
	void mdiChildViewActivated(KPoGreView::EMdiChildView);
	
	// Display properties of underlying database object
	void displayProperties();
	
/////////////////////////////////////////////////////////////////////
//                     PUBLIC FUNCTIONS
/////////////////////////////////////////////////////////////////////
public:

	// Return tree view
	QListView * getTreeView() const { return m_pViewTree; }

	// Get type of active MDI child view
	KPoGreView::EMdiChildView getActiveChildViewType();

  	// Return the currently selected result table (e.g. for saving the content to a file
	QTable* getCurrentlySelectedTableResult();
 
 	// Return active Properties MDI child view
 	KPGPropertyPageChildView * getActivePropertyPageChildView();
 	
 	// Return active property window
 	KPGAbstractPropertyPage * getActivePropertyPage();
 	
 	// Return active Query/result MDI child view
	KPGQueryResultChildView * getActiveQueryResultChildView();
	
	// Return active Query/result window
	KPGQueryResultWindow * getActiveQueryResultWindow();
		
	// Return active Datatable MDI child view
	KPGDataTableChildView * getActiveDataTableChildView();
	
	// Return active Datatable window
	KPGDataTable * getActiveDataTable();
	
	// Return active Executor MDI child view
	KPGExecutorChildView * getActiveExecutorChildView();
	
	// Return active Executor window
	KPGExecutor * getActiveExecutor();
	
	// Return active Debugger MDI child view
	KPGDebuggerChildView * getActiveDebuggerChildView();
	
	// Return active Debugger window
	KPGDebugger * getActiveDebugger();
	
/////////////////////////////////////////////////////////////////////
//                     PROTECTED FUNCTIONS
/////////////////////////////////////////////////////////////////////	
protected:

	// Select given tree item
	void selectItem(KPGTreeItem * const);
	
	// Select item defined by OID and path
	KPGTreeItem* findItem(const KPGOidLink & oidLink);
	
	// Walk through listView items
	KPGTreeItem * nextTreeItem(const KPGTreeItem *);
	
	// Find parent database and schemas list for item
	KPGDatabase * lookUpParentDatabaseAndListOfSchemas(KPGTreeItem *, QPtrList<QListViewItem> &);
	
	// Refesh items child folders with given name
	void refreshItemsFolder(KPGTreeItem *, const QString &);
	
public:	
/////////////////////////////////////////////////////////////////////
//                     ACTION FUNCTIONS
/////////////////////////////////////////////////////////////////////
	
	// Called when user choose bookmark
  	void openUrl( const QString& );
	
	// Run Wizard
	void databaseWizard();
	
	// Called when user launch Find or Find Next menu item 
	void editFind(const QString &, bool, bool);
		
		
	// Refresh current item
	void refresh();
	
	// Select item in tree view by given path 
	bool selectItemByPath(const QString &);
	
	// Connect to PostgreSQL server
	void databaseConnect();
	
	// Disconnect from selected server
	void databaseDisconnect();
	
    //--- Database related menu actions
  	void createDatabase();
	void dropDatabase();
	void analyseDatabase();
	void reindexDatabase();
	void setOwnerDatabase();
	void grantPrivilegesDatabase();
	void revokePrivilegesDatabase();
	void dumpDatabase();
	void restoreDatabase();
	void disconnectDatabase();
	
	//--- Schema related menu actions
  	void createSchema();
	void dropSchema();
	void modifySchema();
	void setOwnerSchema();
	void grantPrivilegesSchema();
	void revokePrivilegesSchema();
	
	//--- Table related menu actions
  	void createTable();
	void dropTable();
	void renameTable();
	void analyseTable();
	void vacuumTable();
	void reindexTable();
	void setClusterOnTable();
	void setWithoutClusterTable();
	void clusterTable();
	void copyFromTable();
	void copyToTable();
	void setOwnerTable();
	void grantPrivilegesTable();
	void revokePrivilegesTable();
	void setTablespaceTable();
	void setWithoutOIDsTable();
	void editTableContent();
	void queryTable();
  
	//--- View related menu actions
	void createView();
	void dropView();
	void modifyView();
	void queryView();
	void grantPrivilegesView();
	void revokePrivilegesView();
	  
	//--- Tablespaces related menu actions
	void createTablespace();
	void dropTablespace();
	void renameTablespace();
	void setOwnerTablespace();
	void grantPrivilegesTablespace();
	void revokePrivilegesTablespace();
	
	//--- User related menu actions
	void createUser();
	void dropUser();
	void modifyUser();
				
	//--- Group related menu actions
	void createGroup();
	void dropGroup();
	void modifyGroup();
    
	//--- Language related menu actions
	void createLanguage();
	void dropLanguage();
	void modifyLanguage();
	void grantPrivilegesLanguage();
	void revokePrivilegesLanguage();
	
	//--- Domain related menu actions
	void createDomain();
	void dropDomain();
	void setDomainNull();
	void setDomainDefault();
	void dropDomainDefault();
	void setOwnerDomain();
	
	//--- Domain constraint related menu actions
	void createDomainConstraint();
	void dropDomainConstraint();
    
	//--- Function related menu actions
	void createFunction();
	void dropFunction();
	void renameFunction();
	void modifyFunction();
	void grantPrivilegesFunction();
	void revokePrivilegesFunction();
	void executeFunction();
	void debugFunction();
		
	//--- Sequence related menu actions
	void createSequence();
	void dropSequence();
	void modifySequence();
	void grantPrivilegesSequence();
	void revokePrivilegesSequence();
	
	//--- Column related menu actions
	void createColumn();
	void dropColumn();
	void renameColumn();
	void setColumnNull();
	void setColumnDefault();
	void dropColumnDefault();
	void changeColumnType();
	void setColumnStorage();
	void setColumnStatistisc();
	
	//--- Constraint related menu actions
	void createConstraint();
	void dropConstraint();
  
	//--- Index related menu actions
	void createIndex();
	void dropIndex();
	void renameIndex();
	void reindexIndex();
	void setOwnerIndex();
	void setTablespaceIndex();
	
	//--- Rule related menu actions 
	void createRule();
	void dropRule();
		
	//--- Trigger related menu actions
	void createTrigger();
	void dropTrigger();
	void enableTrigger();
	void renameTrigger();
	
	//--- Type related menu actions
	void createBaseType();
	void createCompositeType();
	void dropType();
	void setOwnerType();
	
	//--- Common menu actions
	void setDescription();
  	
	//-------------------------------------------------------------------------
    //
    // Other slots, that aren't dedicated to KPoGreController
    //
    //-------------------------------------------------------------------------
	
public slots:

	// Deselects currently selected item in trewe viw
	void slotEditDeselect();
	
protected slots:
    
	// Navigate to parent item
	void slotViewNodeUp();
	
	// Navigate back
	void slotViewNodeBack();
	
	// Navigate forward
	void slotViewNodeForward();	        
            
    void slotConfigureKeys();
    void slotConfigToolbars();
    void slotConfigure();
    		
    // Called when user choose bookmark
	void slotOpenUrl( const QString& );
		
	// Display popup menu
	void slotContextMenuRequested(const QString &, const QPoint &);
	
	// Called, when user make right click over property table. Display popup menu
	//void slotPropertyPageContextMenuRequested(int, int, const QPoint &);
			
	// Updates tooltip text for specefic MDI child View
	void slotUpdateTabTooltip(KMdiChildView *, const QString &);
	
	// Show popup for item in tree rightpressed
	void slotTreeViewRightButtonPressed(QListViewItem*, const QPoint&, int);
	
	// Called when user change MDI tab
	void slotCurrentChildViewChanged( KMdiChildView * );
	
	// Checks, which type of item was selected
	void slotSelectionChanged();
	
	// Caled when user change selected server in SQL query / result window
	void slotRequestDatabasesList(KPGQueryResultWindow *, const QString&);
	
	// Called, when database is selected in SQL query / result window and list of object for code completion is needed
	void slotRequestListOfDatabaseObjectsForCodeCompletion(KPGQueryResultWindow *, const QString&);
	
	// Called, when is needed table columns list, for code completion 
	void slotRequestTableColumnsListsForCodeCompletion(KPGQueryResultWindow *, pqxx::oid);
	
	// Called, when is needed schema childs list, for code completion 
	void slotRequestSchemaChildsListsForCodeCompletion(KPGQueryResultWindow *, pqxx::oid);
		
	// Called, when is needed function return type attributes list, for code completion 
	void slotRequestFunctionReturnTypeAttributesListsForCodeCompletion(KPGQueryResultWindow *, pqxx::oid);
		
	// Called from property pages when user double-clicks on KPGLinkLabel
	void slotSearchObject(const pqxx::oid);
  
  	// Callen when property page need run Wizard
  	void slotRunWizard(const QString &);
	
	// Called when requested change terminal icon in this QTabWidget 
	void slotSetTerminalIcon(KPGQueryResultWindow *, int);
	
	// Called when SQL query started or finished
	//void slotQueryResultStateChanged(KPGQueryResultWindow *);
	
	// Called when SQL query started or finished, or actions need enable/desable
	//void slotDataTableStateChanged(KPGDataTable* pDataTable);
		
	// Called when SQL query started or finished, or actions need enable/desable
	//void slotExecutorStateChanged(KPGExecutor *);
	
	// Called when Debugger actions need enable/disable
	//void slotDebuggerStateChanged(KPGDebugger *);
		
	//-------------------------------------------------------------------------
    //
    // Wizards functions
    //
    //-------------------------------------------------------------------------
 
  	bool createTablespaceWizard(KPGServer *);
  
	bool createDatabaseWizard(KPGServer *);
	
	bool createSchemaWizard(KPGDatabase *);

	bool createGroupWizard(KPGServer *);
	
	bool createUserWizard(KPGServer *);
		
	bool createTableWizard(KPGDatabase *, QPtrList<QListViewItem> &);

  	bool createBaseTypeWizard(KPGDatabase *, QPtrList<QListViewItem> &);
  
  	bool createCompositeTypeWizard(KPGDatabase *, QPtrList<QListViewItem> &);
  
	bool createViewWizard(KPGDatabase *, QPtrList<QListViewItem> &);
  
	bool createDomainWizard(KPGDatabase *, QPtrList<QListViewItem> &);
	
	bool createFunctionWizard(KPGDatabase *, QPtrList<QListViewItem> &);
	
	bool createSequenceWizard(KPGDatabase *, QPtrList<QListViewItem> &);
	
	bool createLanguageWizard(KPGDatabase *);
	
	bool createColumnWizard(KPGDatabase *, KPGSchema *, KPGTable *);
	
	bool createConstraintWizard(KPGDatabase *, KPGSchema *, KPGTable *, int = 0);

	bool createIndexWizard(KPGDatabase *, KPGSchema *, KPGTable *);
  
	bool createRuleWizard(KPGDatabase *, KPGSchema *, KPGTable *);
	
	bool createTriggerWizard(KPGDatabase *, KPGSchema *, KPGTable *);
		
	// Run simple 2-steps for dropping DB object
	bool dropObjectWizard(KPGTreeItem *, KPGTreeItem::eNodeType, const char *, KPGConnection *,	const QString &, bool = true);
	
	// Run simple 2-steps for dropping Table child object
	bool dropTableObjectWizard(KPGTreeItem *, const char *, KPGConnection *, const QString &, const QString &);

    //-------------------------------------------------------------------------
    //
    // Signals
    //
    //-------------------------------------------------------------------------

signals:

	// Emitted, when an tree item is selected
	void sigSelectionChanged( const KPGTreeItem::eNodeType, KPGTreeItem *);

    // Request for enable/disable edit actions, related to KPoGreView
    //void sigEnableEditActions(const EditActions &);

	// Enables/disables Property page actions
	//void sigEnablePropertyPageActions(const PropertyPageActions &);		
	
	// Request for enable/disable Query/result actions
	//void sigEnableQueryResultActions(const QueryResultActions &);
	
    // Request to enable/disable Datable actions
    //void sigEnableDatatableActions(const DatatableActions &);	
	
	// Request to enable/disable Executor actions
    //void sigEnableExecutorActions(const ExecutorActions &);	
    
    // Request to enable/disable Debugger actions
    //void sigEnableDebuggerActions(const DebuggerActions &);
	
	// Emitted, when a context menu is requested 
	void sigContextMenuRequested(const QString & szMenuName, const QPoint & pos );
};

#endif // KPOGREVIEW_H
