//
// C++ Implementation: kpgcreatetriggerwidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetriggerwidget1.h"

// include files for Qt
#include <qradiobutton.h>
#include <qcheckbox.h>

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h> 

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgfunctionsfolder.h"
#include "../DbObjects/kpgfunction.h"
#include "../kpgutil.h"


KPGCreateTriggerWidget1::KPGCreateTriggerWidget1(QWidget *parent, const char *name, KPGDatabase *pDatabase, const QString &strNamespace, const QString &strTable)
 : KPGCreateTriggerWidget1Base(parent, name)
{
    m_strNamespace = strNamespace;
    m_strTableName = strTable;
    m_pDatabase = pDatabase;
  
    // fill schemas to combobox
    KPGUtil::fillComboBoxWithDatabaseSchemas(pDatabase, m_pComboBoxSchema);
    
    refreshListOfFunctions();
    m_pLineEditTriggerName->setFocus();
}


KPGCreateTriggerWidget1::~KPGCreateTriggerWidget1()
{
}

void KPGCreateTriggerWidget1::slotTriggerNameChanged(const QString& strText)
{
	emit sigEnableNextButton(! strText.isEmpty() && (
		m_pCheckBoxInsert->isChecked() ||
		m_pCheckBoxUpdate->isChecked() ||
		m_pCheckBoxDelete->isChecked()) &&
    ! m_pComboBoxFunctions->currentText().isEmpty());
}

void KPGCreateTriggerWidget1::slotInsertToggled(bool bChecked)
{
	emit sigEnableNextButton(! m_pLineEditTriggerName->text().isEmpty() && (
		bChecked ||
		m_pCheckBoxUpdate->isChecked() ||
		m_pCheckBoxDelete->isChecked()) &&
    ! m_pComboBoxFunctions->currentText().isEmpty());
}
		
void KPGCreateTriggerWidget1::slotUpdateToggled(bool bChecked)
{		
	emit sigEnableNextButton(! m_pLineEditTriggerName->text().isEmpty() && (
		m_pCheckBoxInsert->isChecked() ||
		bChecked ||
		m_pCheckBoxDelete->isChecked()) &&
    ! m_pComboBoxFunctions->currentText().isEmpty());
}
		
void KPGCreateTriggerWidget1::slotDeleteToggled(bool bChecked)
{
	emit sigEnableNextButton(! m_pLineEditTriggerName->text().isEmpty() && (
		m_pCheckBoxInsert->isChecked() ||
		m_pCheckBoxUpdate->isChecked() ||
		bChecked) &&
    ! m_pComboBoxFunctions->currentText().isEmpty());
}

void KPGCreateTriggerWidget1::slotSchemaActivated(int)
{
  refreshListOfFunctions();
}

void KPGCreateTriggerWidget1::slotFunctionActivated(const QString &strFunction)
{
  emit sigEnableNextButton(! m_pLineEditTriggerName->text().isEmpty() && (
    m_pCheckBoxInsert->isChecked() ||
    m_pCheckBoxUpdate->isChecked() ||
    m_pCheckBoxDelete->isChecked()) &&
    ! strFunction.isEmpty());

}

void KPGCreateTriggerWidget1::refreshListOfFunctions()
{
	QString strNamespace(m_pComboBoxSchema->currentText());
  
  // Find schema
  KPGTreeItem *pItem = m_pDatabase->getChildByName(strNamespace);
  if(!pItem)
  {
    kdDebug() << "KPGCreateTriggerWidget1::refreshListOfFunctions: no item found: " << strNamespace << endl;
    return;
  }
  
  KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
    
  m_pComboBoxFunctions->clear();
	
	//--- Obtain list of functions
	KPGFunctionsFolder *pFunctionsFolder = pSchema->getFunctionsFolder();
  KPGServer *pServer = static_cast <KPGServer *> (pFunctionsFolder->getParentByType(KPGTreeItem::nodeServer));
  
  // Triggers funtions rturns 'OPAQUE' in old PostgreSQL, and 'trigger' in new one 
  QString strReturnDatatype(pServer->versionMajor() >= 8 ? "trigger" : "opaque");
  
	// traverse list of functions
  QListViewItem * pLvItem = pFunctionsFolder->firstChild();
  while(pLvItem)
  {
    KPGFunction *pFunction = static_cast <KPGFunction *> (pLvItem);
      
    // list functions without arguments, that return trigger or opaque datatype
	if((pFunction->nArgs() == 0) && (pFunction->returnTypName() == strReturnDatatype))
    	m_pComboBoxFunctions->insertItem(* pFunction->pixmap(0), pFunction->text(0) + pFunction->argTypes()); 
      
    pLvItem = pLvItem->nextSibling();
  }
}

// Return SQL statement for CREATE TRIGGER
const QString KPGCreateTriggerWidget1::getSQL() const
{
	QString strSql("CREATE TRIGGER ");
	strSql.append(KPGUtil::quotedName(m_pLineEditTriggerName->text()));
	
	if(m_pRadioButtonBefore->isChecked())
		strSql.append(" BEFORE ");
	else
		strSql.append(" AFTER ");
		
	bool bNeedOr = false;
	
	if(m_pCheckBoxInsert->isChecked())
	{
		strSql.append("INSERT ");
		bNeedOr = true;
	}
	
	if(m_pCheckBoxUpdate->isChecked())
	{
		if(bNeedOr) strSql.append("OR ");
		strSql.append("UPDATE ");
		bNeedOr = true;
	}
	
	if(m_pCheckBoxDelete->isChecked())
	{
		if(bNeedOr) strSql.append("OR ");
		strSql.append("DELETE");
	} 
	
	// namespace and tablename
	strSql.append("\nON ");
		
	strSql.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName));
	strSql.append("\n");
	
	// for each ...
	if(m_pRadioButtonForEachStatement->isChecked())
		strSql.append("FOR EACH STATEMENT\n");
	else
		strSql.append("FOR EACH ROW\n");
	
	// procedure
	strSql.append("EXECUTE PROCEDURE ");
	
	strSql.append(KPGUtil::fullyQualifiedName(m_pComboBoxSchema->currentText(), m_pComboBoxFunctions->currentText()) + "()");
	strSql.append(";");
		
	return strSql;
}

#include "kpgcreatetriggerwidget1.moc"
