//
// C++ Implementation: kpgtablesfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtablesfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../DbObjects/kpgserver.h"

KPGTablesFolderPropPage::KPGTablesFolderPropPage(QWidget* parent, KPGTablesFolder * pTablesFolder)
	: KPGPropertyPage(parent, "KPGTablesFolderPropPage")
{
	m_pTablesFolder = pTablesFolder;
	displayProperties();
}


KPGTablesFolderPropPage::~KPGTablesFolderPropPage()
{
}

void KPGTablesFolderPropPage::displayProperties()
{
	// Get pointer to server for version info
    KPGServer *pServer = static_cast <KPGServer *> (m_pTablesFolder->parent()->parent()->parent());
    
    bool bVersion80_OrNewer = false;
	bool bVersion81_OrNewer = false;
	//int iColumns = 9;
	    
	// Is it 8.0 or newer ?
	if(pServer->versionMajor() > 7)
    {             
       bVersion80_OrNewer = true;
       //iColumns += 1;
    }     
	    
    // Is it 8.1 or newer ?
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion81_OrNewer = true;
		//iColumns += 2;
	}

  	setLabelText(i18n("Tables &list:"));
	
	//----------------------------------------------------------------------------
	QHeader* pHeader = m_pTableItems->horizontalHeader();

  	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
  	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Owner"));
	pHeader->setLabel(nCol++, i18n("Has OIDs"));
  	pHeader->setLabel(nCol++, i18n("Has subclass"));
  	pHeader->setLabel(nCol++, i18n("Estimated rows"));
  	pHeader->setLabel(nCol++, i18n("Primary key name"));
  	pHeader->setLabel(nCol++, i18n("Primary key columns"));
  	pHeader->setLabel(nCol++, i18n("ACL"));
  	pHeader->setLabel(nCol++, i18n("Kind"));
  	pHeader->setLabel(nCol++, i18n("Toast table"));
  	
  	if(bVersion80_OrNewer) 
  	{
  		pHeader->setLabel(nCol++, i18n("Tablespace"));
  	}
  	
  	if(bVersion81_OrNewer) 
  	{
  		pHeader->setLabel(nCol++, i18n("Size"));
  		pHeader->setLabel(nCol++, i18n("Total size"));
  	}
    
  	KPGUtil::fillPropertiesTable(m_pTablesFolder->resultTables(), m_pTableItems, true, nCol);
}

