//
// C++ Implementation: kpgoperatorclassproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgoperatorclassproppage.h"

#include <qtable.h>  

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <ktextedit.h>

#include "../kpgutil.h"
#include "../kpglinklabel.h"
#include "../DbObjects/kpgoperatorclass.h"


KPGOperatorClassPropPage::KPGOperatorClassPropPage(QWidget *parent, KPGOperatorClass * pOperatorClass)
 : KPGOperatorClassPropPageBase(parent, "KPGOperatorClassPropPage")
{
	m_pOperatorClass = pOperatorClass;
	displayProperties();
}


KPGOperatorClassPropPage::~KPGOperatorClassPropPage()
{
}

void KPGOperatorClassPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

    pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pOperatorClass->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
    m_pTableProperties->setText(iRow, 1, m_pOperatorClass->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Operator Class name"));
	
	//--- Is Default
	m_pTableProperties->setText(iRow, 0, i18n("Is default"));
    m_pTableProperties->setPixmap(iRow, 1, m_pOperatorClass->isDefault() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("True if this operator class is the default for data type"));
	
	//--- Data type
	m_pTableProperties->setText(iRow, 0, i18n("Data type"));
    KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Data type" );
	pLabel->setValues(m_pOperatorClass->oidDataType(), m_pOperatorClass->dataType());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Data type that the operator class indexes"));
	
	//--- Key Type
	m_pTableProperties->setText(iRow, 0, i18n("Key type"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Key type" );
	pLabel->setValues(m_pOperatorClass->oidKeyType(), m_pOperatorClass->keyType());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Type of data stored in index, or noyhing if same as Data Type"));
	
	//--- Access method
	m_pTableProperties->setText(iRow, 0, i18n("Access method"));
    m_pTableProperties->setText(iRow, 1, m_pOperatorClass->accessMethodName());
	m_pTableProperties->setText(iRow++, 2, i18n("Index access method operator class is for"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
    m_pTableProperties->setText(iRow, 1, m_pOperatorClass->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Operator class owner"));
	
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
}

void KPGOperatorClassPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

// Consumes request for context menu for property table
void KPGOperatorClassPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgoperatorclassproppage.moc"
