//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdomainconstrproppage.h"

#include <qtable.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "../DbObjects/kpgdomainconstraint.h"

KPGDomainConstrPropPage::KPGDomainConstrPropPage(QWidget *parent, KPGDomainConstraint *pDomainConstraint)
 : KPGDomainConstrPropPageBase(parent, "KPGDomainConstrPropPage")
{
	m_pDomainConstraint = pDomainConstraint;
	displayProperties();
}


KPGDomainConstrPropPage::~KPGDomainConstrPropPage()
{
}

void KPGDomainConstrPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();
	
	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
		
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pDomainConstraint->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
	m_pTableProperties->setText(iRow, 1, m_pDomainConstraint->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Constraint name (not necessarily unique!)"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
	m_pTableProperties->setText(iRow, 1, m_pDomainConstraint->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the constraint"));
		
	//--- Expression
	m_pTableProperties->setText(iRow, 0, i18n("Expression"));
	m_pTableProperties->setText(iRow, 1, m_pDomainConstraint->expression());
	m_pTableProperties->setText(iRow++, 2, i18n("A human-readable representation of the expression"));
	
	//--- Namespace
	m_pTableProperties->setText(iRow, 0, i18n("Namespace"));
	m_pTableProperties->setText(iRow, 1, m_pDomainConstraint->namespaceName());
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the namespace"));
	
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
}

// Consumes request for context menu for property table
void KPGDomainConstrPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgdomainconstrproppage.moc"
