//
// C++ Implementation: kpgtriggersfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtriggersfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgtrigger.h"
#include "kpgserver.h"


KPGTriggersFolder::KPGTriggersFolder(KPGTable *parent)
 : KPGTableItemsFolder(parent, i18n("Triggers"))
{
	setPixmap(0, *m_pIconFolderViolet);
}

KPGTriggersFolder::KPGTriggersFolder(KPGTable *parent, KPGTableItemsFolder *after)
 : KPGTableItemsFolder(parent, after, i18n("Triggers"))
{
	setPixmap(0, *m_pIconFolderViolet);
}

KPGTriggersFolder::~KPGTriggersFolder()
{
}

void KPGTriggersFolder::refresh(pqxx::oid oidTable) throw(const KPGSqlException &)
{
	// delete all child items (triggers)
	while (QListViewItem * pItem = firstChild())
		delete pItem;
	
	KPGServer *pServer = static_cast <KPGServer *> (parent()->parent()->parent()->parent()->parent());
	
	// Is it 8.3 or newer ?
	bool bVersion83_OrNewer = false;
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 3)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion83_OrNewer = true;
	}
	
	QString strQuery("SELECT t.oid, t.tgname, des.description, t.tgdeferrable, t.tginitdeferred, tgnargs, tgargs, nspname, tgfoid,  pr.proname ");
		
	if(bVersion83_OrNewer)
	{
		strQuery.append(", CASE WHEN t.tgenabled='O' THEN 'origin and local' WHEN t.tgenabled='D' THEN 'disabled' WHEN t.tgenabled='R' THEN 'replica' WHEN t.tgenabled='A' THEN 'always' END AS tgenabled ");
	}
	else
	{
		strQuery.append(", t.tgenabled ");
	}	
		
	strQuery.append("FROM pg_catalog.pg_trigger t ");
	strQuery.append("JOIN pg_catalog.pg_class cl ON cl.oid=tgrelid ");
	strQuery.append("JOIN pg_catalog.pg_namespace na ON na.oid=relnamespace ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=t.oid ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_proc pr ON tgfoid=pr.oid ");
	strQuery.append("WHERE NOT tgisconstraint ");
	strQuery.append(" AND tgrelid = ");
	strQuery.append(QString("%1").arg(oidTable));
	strQuery.append(" ORDER BY tgname");
			
	try
	{
		m_pqxxResultTriggers = connection()->runQuery(strQuery);
			
		KPGTrigger *pTrigger = 0;
			
		for (result::size_type i = 0; i != m_pqxxResultTriggers.size(); ++i)
		{
			pqxx::oid oid;
			m_pqxxResultTriggers[i][0].to(oid);
							
			if(pTrigger == 0)
				pTrigger = new KPGTrigger(this, m_pqxxResultTriggers[i]["tgname"].c_str(), oid);
			else
				pTrigger = new KPGTrigger(this, pTrigger, m_pqxxResultTriggers[i]["tgname"].c_str(), oid);
			
			pTrigger->setProperties(m_pqxxResultTriggers[i]);
		}
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

