//
// C++ Interface: kpgtableindex
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTABLEINDEX_H
#define KPGTABLEINDEX_H

#include <qmap.h>
  
#include "kpgobject.h"

class KPGTableIndexesFolder;

// Map of index columns - pair of <int iColumnNum, QString strColumnName> 	
typedef QMap<int, QString> MapIndexKey;

/**
  * Base class for table indexes - index for primary key and regular index
  *
  * @author Lumir Vanek
  */
class KPGTableIndex : public KPGObject
{
public:
    KPGTableIndex(KPGTableIndexesFolder *, const QString, pqxx::oid);
	KPGTableIndex(KPGTableIndexesFolder *, KPGTableIndex *, const QString, pqxx::oid);
    ~KPGTableIndex();
           	
	const MapIndexKey & getMapIndexKey() const { return m_mapIndexKey; }	
		
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "INDEX"; }	
		
	void setProperties(const pqxx::result::tuple &, bool, bool);
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
	
	// Refresh map of index columns
	void refreshMapIndexKey(pqxx::oid) throw(const KPGSqlException &);
		
	// Query index statistics 
	pqxx::result queryStatistics() throw(const KPGSqlException &);
	
	// Query index I/O statistics 
	pqxx::result queryIoStatistics() throw(const KPGSqlException &);
		
	/*
	 * Functions for accessing properties
	 */
    bool isUnique() const { return m_bIsUnique; }
    bool isPrimary() const { return m_bIsPrimary; }
    bool isClustered() const { return m_bIsClustered; }
    const QString & indKey() const { return m_strIndKey; }
    pqxx::oid oidTablespace() const { return m_oidTablespace; }
    const QString & tablespace() const { return m_strTablespace; }
    const QString & indexdef() const { return m_strIndexdef; }
    long long size() const { return m_llSize; }
  	const QString & prettySize() const { return m_strPrettySize; }
       
protected:
	
	/*
	 * Properties
	 */
	QString m_strIndKey;
	bool m_bIsUnique;
	bool m_bIsPrimary;
	bool m_bIsClustered;
  	pqxx::oid m_oidTablespace;   // For PostgreSQL 8 or newer 
  	QString m_strTablespace;     // For PostgreSQL 8 or newer
  	QString m_strIndexdef;
  	long long m_llSize;
  	QString m_strPrettySize;
  	
  	// Map of index columns - pair of <int iColumnNum, QString strColumnName> 
  	MapIndexKey m_mapIndexKey;
};

#endif
