//
// C++ Interface: kpglanguage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGLANGUAGE_H
#define KPGLANGUAGE_H

#include "kpgobject.h"

class KPGLanguagesFolder;

/**
  * Item that represent procedural language
  *
  * @author Lumir Vanek
  */
class KPGLanguage : public KPGObject
{
public:
    KPGLanguage(KPGLanguagesFolder *, const QString, pqxx::oid);
	KPGLanguage(KPGLanguagesFolder *, KPGLanguage *, const QString, pqxx::oid);
    ~KPGLanguage();

	virtual eNodeType type() const { return nodeLanguage; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "LANGUAGE"; }
	
	void setProperties(const pqxx::result::tuple &);
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
    
    // Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
	
	/*
	 * Functions for accessing properties
	 */
	bool isTrusted() const { return m_bIsTrusted; }	
	const QString & acl() const { return m_strACL; }
	pqxx::oid oidLanguageProc() const { return m_oidLanguageProc; }
	const QString & languageProcName() const { return m_strLanguageProcName; }
	pqxx::oid oidValidatorProc() const { return m_oidValidatorProc; }
	const QString & validatorProcName() const { return m_strValidatorProcName; }
	 
protected:

	/*
	 * Properties
	 */
	bool m_bIsTrusted;	
	QString m_strACL;
	pqxx::oid m_oidLanguageProc;
	QString m_strLanguageProcName;
	pqxx::oid m_oidValidatorProc;
	QString m_strValidatorProcName;
};

#endif
