// Copyright(C) 2005,2007 Stefan Siegl <stesie@brokenpipe.de>
// Copyright(C) 2007 Christian Dietrich <stettberger@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <iostream>
#include <cstdlib>
#include <assert.h>

// for message boxes ...
#include <kmessagebox.h>
#include <kopeteuiglobal.h>
#include <klocale.h>

// our own stuff ...
#include "silcaccount.h"
#include "silcmessagemanager.h"
#include "silccontact.h"
#include "silcchannelcontact.h"

SilcChatSession::SilcChatSession(const SilcContact *user, 
				 Kopete::ContactPtrList others,
				 SilcProtocol *protocol)
  : Kopete::ChatSession(user, others, protocol)
{
  Kopete::ChatSessionManager::self()->registerChatSession(this);
  ///@todo invite depends on state
  setMayInvite(true);
}

SilcChatSession::~SilcChatSession()
{

}

void 
SilcChatSession::inviteContact(const QString &cid)
{
  if(cid[0] != '@') {
    KMessageBox::queuedMessageBox
      (Kopete::UI::Global::mainWidget(), KMessageBox::Sorry,
       i18n("You cannot invite a channel, try again an "
	    "drop a buddy contact next time."),
       i18n("Invite Buddy"));
    return;
  }

  // lookup the SilcBuddyContact* who wants to join
  SilcAccount *a = static_cast<SilcAccount *>(account());
  SilcBuddyContact *buddy = a->contactManager()->lookupBuddyById(cid);
  assert(buddy);

  // lookup the SilcChannelContact* which channel ought to be joined
  Kopete::ContactPtrList mb = members();
  Kopete::Contact *contact = mb.first();
  assert(contact);

  if(strcmp(contact->metaObject()->className(), "SilcChannelContact")) {
    int answer = KMessageBox::questionYesNo
      (Kopete::UI::Global::mainWidget(),
       QString(i18n("Do you want to  start a conference with these buddies?")),
       i18n("Starting a conference"));
    if (answer == KMessageBox::Yes) {
      SilcBuddyContact *buddy_two = static_cast<SilcBuddyContact *>(contact);
      int retry = 5;
      SilcChannelContact *channel;
      SilcTK::SilcChannelEntry ch;
      QString chnam;

      while (retry) {
        chnam = QString("#ad-hoc-%1").arg(random());
        ch = SilcTK::silc_client_get_channel(a->client(), a->conn(), (char *)
					     chnam.toLatin1().constData());

        if(! ch) break;
        retry--;
      }
      if(ch) {
        KMessageBox::queuedMessageBox
          (Kopete::UI::Global::mainWidget(), KMessageBox::Sorry,
           i18n("Unable to figure out random room name for conference chat. Sorry."),
           i18n("Conference chat"));
        return;
      }

      channel = a->contactManager()->createChannel(chnam);
      assert(channel);

      channel->join();
      channel->invite(buddy_two);
      channel->invite(buddy);

      channel->setSecret(true);
      channel->setPrivate(true);
      channel->setInviteOnly(true);
    }
    return;
  }

  SilcChannelContact *channel = static_cast<SilcChannelContact *>(contact);
  channel->invite(buddy);
}

#include "silcmessagemanager.moc"
