//              -*- mode: C++ -*-
//
// Copyright(C) 2005,2007,2008 Stefan Siegl <stesie@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <sys/types.h>	       // Get mode_t into the right namespace.

#include "silccontactmanager.h"
#include "silcaddcontactpage.h"
#include "silcaccount.h"

#include "ui_silcaddcontact.h"

#include <kopeteaccount.h>
#include <kopetemetacontact.h>
#include <kopeteuiglobal.h>
#include <kopetecontactlist.h>

#include <kdebug.h>
#include <kmessagebox.h>

#include <qlayout.h>
#include <qcheckbox.h>
#include <qlineedit.h>

#include <assert.h>
#include <malloc.h>

SilcAddContactPage::SilcAddContactPage(SilcAccount *account, QWidget *parent)
  : AddContactPage(parent)
{
  (void) account;

  _dlg = new Ui::silcAddContact();
  _dlg->setupUi(this);
}

SilcAddContactPage::~SilcAddContactPage()
{
  delete _dlg;
}


struct SilcPendingResolveBuddy {
  SilcPendingResolveBuddy(Kopete::MetaContact *m, SilcAccount *a, char *n)
    : meta(m), account(a), nickname(n) { }
  ~SilcPendingResolveBuddy() { free(nickname); }

  Kopete::MetaContact *meta;
  SilcAccount *account;
  char *nickname;
};


static void
getClientsCallback(SilcTK::SilcClient, SilcTK::SilcClientConnection,
		   SilcTK::SilcStatus status, SilcTK::SilcDList celist,
		   void *context)
{
  kDebug() << "getClientsCallback " << (int) status << endl;
  //return;

  SilcPendingResolveBuddy *rb = (SilcPendingResolveBuddy *) context;
  SilcContactManager *cm = rb->account->contactManager();
  SilcTK::SilcClientEntry ce = NULL;
  SilcBuddyContact *buddy = NULL;

  if(status != SILC_STATUS_OK || celist == NULL) {
    KMessageBox::queuedMessageBox
      (Kopete::UI::Global::mainWidget(), KMessageBox::Sorry, 
       i18n("Failed to resolve new buddy's nickname to fingerprint. "
	    "Unable to add to contact list. Please check the spelling "
	    "and make sure that the buddy is online."),
       i18n("Failed to resolve buddy"));
    goto out;
  }

  if(SilcTK::silc_dlist_count(celist) != 1) {
    KMessageBox::queuedMessageBox
      (Kopete::UI::Global::mainWidget(), KMessageBox::Sorry, 
       i18n("Buddy's nickname resolved to more than one nickname.  "
	    "Please make sure to specify an unambigious nickname."),
       i18n("Failed to resolve buddy"));
    goto out;
  }

  SilcTK::silc_dlist_start(celist);
  ce = (SilcTK::SilcClientEntry) SilcTK::silc_dlist_get(celist);
  assert(ce);

  buddy = cm->createBuddy(QString::fromUtf8(ce->nickname), rb->meta, ce);
  buddy->setMetaContact(rb->meta);
  buddy->whoami();

 out:
  // if there are no buddies in the meta contact, delete it again
  if(rb->meta->contacts().size() == 0) {
    // remove metacontact from all groups it's a member of
    foreach(Kopete::Group *g, rb->meta->groups())
      rb->meta->removeFromGroup(g);

    Kopete::ContactList::self()->removeMetaContact(rb->meta);
  }

  delete rb;
}


bool 
SilcAddContactPage::apply(Kopete::Account *account, Kopete::MetaContact *m)
{ 
  SilcAccount *_account = (SilcAccount*) account;
  SilcContactManager *cm = _account->contactManager();

  if(_dlg->ischannel->isChecked()) {
     cm->createChannel(_dlg->addID->text(),m);
  } 

  else {
    // add buddy ...

    SilcBuddyContact *buddy;
    QString nick = _dlg->addID->text();
    QString finger = _dlg->fingerprint->text();
    
    if(! finger.isEmpty()) {
      //user provided a fingerprint
      buddy = new SilcBuddyContact(_account, nick, finger, m);
      cm->addBuddy(buddy);
      buddy->watchme(true);
    }
    else {
      SilcPendingResolveBuddy *rb =
	new SilcPendingResolveBuddy(m, _account,
				    strdup(nick.toUtf8().constData()));

      SilcTK::silc_client_get_clients_whois(_account->client(),
					    _account->conn(), 
					    rb->nickname, NULL, NULL,
					    getClientsCallback, (void *) rb);
    }
  }

  return true;
}

bool 
SilcAddContactPage::validateData(void)
{
	return true;
}

#include "silcaddcontactpage.moc"
