//                       -*- mode: C++ -*-
//
// Copyright(C) 2005 Stefan Siegl <stesie@brokenpipe.de>
// Copyright(C) 2007 Christian Dietrich <stettberger@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SILCFILETRANSFER_H
#define SILCFILETRANSFER_H

// include libsilc stuff into a separate namespace
namespace SilcTK {
#include <silc.h>
#include <silcclient.h>
}

#include <qobject.h>
#include <qfile.h>
#include <kopetetransfermanager.h>

//#include "silcaccount.h"
class SilcAccount;
class SilcBuddyContact;



class SilcFileTransfer : public QObject
{
  Q_OBJECT

  public:

    /*
     * @brief initialize the transfer, after an file request was recieved
     * ask user for filename
     */
    SilcFileTransfer(SilcAccount *account, SilcBuddyContact *contact, 
              SilcTK::SilcUInt32 sid, bool ask_name = TRUE);
    /*
     * @brief initialize the transfer, and send an file request
     */
    SilcFileTransfer(SilcAccount *account, SilcBuddyContact *contact, const QString &file );

    ~SilcFileTransfer ();

    /* 
     * @brief starts the KopeteTransfer for recieved transfer
     */
    void initTransfer(QString filename, Q_LLONG filesize);

    /* 
     * @brief check if transfer was closed already
     */
    bool closed(void);

    /* 
     * @brief close the connection
     */
    void close(void);

    /* 
     * @brief handle an occured error on the silc side of the transfer
     */
    void error(SilcTK::SilcClientFileError error);
    
    /* 
     * @brief was the transfer completed already
     */
    inline bool complete(void) { return (mFileSize == mFileOffset); }

    /*
     * @brief check for the KopeteTransfer
     */
    inline bool validTransfer(void) { return mKopeteTransfer ? true : false; }

    /* 
     * @brief set the offset, to update the progressbar
     */
    void setOffset ( Q_LLONG offset );
    
  public slots:
    void slotTransferResult(void);
    
  protected:
    SilcTK::SilcUInt32 mSid;
    Kopete::Transfer *mKopeteTransfer;
    SilcAccount *mAccount;
    SilcBuddyContact *mContact;
    QFile mLocalFile;
    Q_LLONG mFileOffset;
    Q_LLONG mFileSize;

  private:
    static void
      ask_filename(SilcTK::SilcClient client,
                   SilcTK::SilcClientConnection conn,
                   SilcTK::SilcUInt32 session_id,
                   const char *remote_filename,
                   SilcTK::SilcClientFileName completion,
                   void *completion_context,
                   void *context);
    void static
      sendFileMonitor(SilcTK::SilcClient client,
                         SilcTK::SilcClientConnection conn,
                         SilcTK::SilcClientMonitorStatus status,
                         SilcTK::SilcClientFileError error,
                         SilcTK::SilcUInt64 offset, SilcTK::SilcUInt64 filesize,
                         SilcTK::SilcClientEntry client_entry,
                         SilcTK::SilcUInt32 session_id,
                         const char *filepath, void *ctx);
};
#endif /* SILCFILEMONITOR_H */
