//              -*- mode: C++ -*-
//
// Copyright(C) 2005 Stefan Siegl <stesie@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SILCPROTOCOL_SILCADDCONTACTPAGE_H
#define SILCPROTOCOL_SILCADDCONTACTPAGE_H

namespace Kopete {
  class Account;
  class MetaContact;
}

// forward declare classes:
class SilcProtocol;
class SilcAccount;

// include base widget classes
#include "silcaddcontact.h"
#include <ui/addcontactpage.h>

/**
 * @brief Create the AddContactPage widget and implement it's functionality
 *
 * @author Stefan Siegl <ssiegl@gmx.de>
 */
class SilcAddContactPage
  : public AddContactPage
{
  Q_OBJECT;

public:
  SilcAddContactPage(QWidget *parent = 0, SilcAccount *account = 0);
  ~SilcAddContactPage();

  silcAddContact *silcAddContactUI;

public slots:
  virtual bool apply(Kopete::Account *account, Kopete::MetaContact *m);

private slots:
  virtual bool validateData();
};

#endif // SILCPROTOCOL_SILCADDCONTACTPAGE_H
