/***************************************************************************
 *   Copyright (C) 2005-2010 by Georg Hennig                               *
 *   Email: Georg Hennig                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <KApplication>
#include <KAboutData>
#include <KCmdLineArgs>
#include <KLocale>
#include <KUrl>

#include "komparator.h"

#include <version.h>

static const char description[] = I18N_NOOP( "A KDE4 Duplicate Files Find\nAnd Directory Compare Program." );

static const char version[] = VERSION;

int main(int argc, char **argv)
{
	KAboutData about("komparator4", 0, ki18n("komparator4"), version, ki18n(description),
			KAboutData::License_GPL, ki18n("(C) 2005-2010 Georg Hennig"), KLocalizedString(), 0, "georg.hennig@web.de");
	about.addAuthor( ki18n("Georg Hennig"), KLocalizedString(), "georg.hennig@web.de" );
	KCmdLineArgs::init( argc, argv, &about );

	KCmdLineOptions options;
	options.add( "+[URL 1]", ki18n( "First URL to search" ) );
	options.add( "+[URL 2]", ki18n( "Second URL to search" ) );

	KCmdLineArgs::addCmdLineOptions(options);
	KApplication app;

	Komparator *widget = NULL;

	// see if we are starting with session management
	if (app.isSessionRestored())
	{
		RESTORE( Komparator( KUrl(), KUrl() ) );
	}
	else
	{
		// no session.. just start up normally
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		if ( args->count() == 0 )
		{
			widget = new Komparator( KUrl(), KUrl() );
			widget->show();
		}
		else
		{
			KUrl url1, url2;
			if ( args->count() > 0 ) url1 = args->url( 0 );
			if ( args->count() > 1 ) url2 = args->url( 1 );

			widget = new Komparator( url1, url2 );
			widget->show();
		}
		args->clear();
	}

	return app.exec();
}
