/***************************************************************************
                          smbclient.h  -  description
                             -------------------
    begin                : Mon Apr 10 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMBCLIENT_H
#define SMBCLIENT_H

#include <qobject.h>
#include <qstring.h>
#include <kprocess.h>
#include "myktreelistitem.h"
/**ruft smbclient auf mit parameter -L host und gibt signal wenn rckgabe erfolgt
  *@author 
  */

class smbclient:public QObject
{
Q_OBJECT private:
  KProcess * proc;		// The Process
  QString out;
  QString err;
  MyHostItem *hostitem;
  u_long ip;
public:
    smbclient (QObject * parent, MyHostItem * host_item);
   ~smbclient ();
  /** startet den Process (smbclient -L ...)  */
  void start ();
  /** Gibt Zeile ab index bis Ende der Zeile ('\n')
		zurck, index ist danach auf Anfang der nchsten Zeile; */
  QString nextline (QString & in, int &index);
  public slots:			// Public slots
  /** Liest den Ausgaben ein */
  void smbclientStdout (KProcess * p, char *buffer, int n);
  /** Liest den Fehlermeldungen ein, wenn noetig wird Password gesendet */
  void smbclientStderr (KProcess * p, char *buffer, int n);
  /** Wird aufgerufen wenn der Process sich beendet */
  void onProcExit (KProcess * killedproc);
    signals:			// Signals
  /**  */
  void isExited (smbclient * m, bool exitStatus, const QString & err,
		 MyHostItem * host_item = 0);
  /**  */
  void isExited (smbclient * m, const QString & err, MyHostItem * host_item =
		 0);
  /** Host gefungen (kann bereits vorhanden sein) */
  void newHost (const QString & hostname, const QString & workgroup,
		const QString & comment, u_long ip, const QString & os,
		const QString & server);
  /** Workgroup gefunden (kann bereits vorhanden sein)  */
  void newWorkgroup (const QString & workgroup, const QString & master,
		     bool issearched);
  /** Share gefunden (kann vorhanden sein)
      typ : 1 = Disk
             2 = IPC
             3 = Printer
             0 = unknown
 */
  void newShare (const QString & host, const QString & workgroup,
		 const QString & share, const QString & comment,
		 MyShareItem::ShareTypes sharetyp);
};

#endif
