/***************************************************************************
                          recentmounts.cpp  -  description
                             -------------------
    begin                : Tue Feb 13 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "recentmounts.h"
#include "myktreelistitem.h"

RecentMounts::RecentMounts (const QString & text, int accel,
			    const QObject * receiver, const char *slot,
			    QObject * parent, const char *name):
KListAction (text, accel, receiver, slot, parent, name)
{
  reclist.setAutoDelete (true);
}

RecentMounts::~RecentMounts ()
{
}

void
RecentMounts::addRecentMount (MyShareItem * shareitem)
{
  RecentMountItem *item;
  item = getRecentItem (shareitem);
  if (item)
    reclist.remove (item);
  item = new RecentMountItem;
  item->share = shareitem->Name ();
  item->host = shareitem->getHostName ();
  item->workgroup = shareitem->getWorkgroupName ();
  item->mountpath = shareitem->getMountPath ();
  reclist.prepend (item);
  if (reclist.count () > MAXRECENTS)
    reclist.removeLast ();
  KListAction::clear ();
  KListAction::setItems (getItemList ());
}

RecentMountItem *
RecentMounts::getRecentItem (MyShareItem * shareitem)
{
  RecentMountItem *item = reclist.first ();
  while (item)
    {
      if ((item->share == shareitem->Name ())
	  && (item->mountpath == shareitem->getMountPath ())
	  && (item->host == shareitem->getHostName ()))
	{
	  return item;
	}
      item = reclist.next ();
    }
  return 0L;
}

const QStringList
RecentMounts::getItemList ()
{
  QStringList lst;
  RecentMountItem *item = reclist.first ();
  while (item)
    {
      lst.append (QString ("//") + item->host + QString ("/") + item->share +
		  QString (" on ") + item->mountpath);
      item = reclist.next ();
    }
  return lst;
}

MyShareItem *
RecentMounts::getShareItem (MyNetworkItem * netitem, int id)
{
  RecentMountItem *item = reclist.at (id);
  MyShareItem *shareitem = 0L;
  if (item)
    shareitem = netitem->getShare (item->workgroup, item->host, item->share);
  return shareitem;
}

const QString
RecentMounts::getMountPath (int id)
{
  RecentMountItem *item = reclist.at (id);
  if (item)
    return item->mountpath;
  return QString ("");

}

void
RecentMounts::loadEntries (KConfig * config, QString groupname)
{
  RecentMountItem *item;
  QString sharename;
  QString hostname;
  QString workgroupname;
  QString mountpath;
  QString counter;
  int icount = 0;
  QString oldgroup = config->group ();
  if (groupname == QString::null)
    groupname = "Recent Mounts";
  config->setGroup (groupname);
  reclist.clear ();
  while (icount < MAXRECENTS)
    {
      counter.setNum (icount);
      sharename = config->readEntry (QString ("sharename_") + counter);
      hostname = config->readEntry (QString ("hostname_") + counter);
      workgroupname =
	config->readEntry (QString ("workgroupname_") + counter);
      mountpath = config->readEntry (QString ("mountpath_") + counter);
      if ((!sharename.isEmpty ()) && (!hostname.isEmpty ())
	  && (!workgroupname.isEmpty ()) && (!mountpath.isEmpty ()))
	{
	  item = new RecentMountItem;
	  item->share = sharename;
	  item->host = hostname;
	  item->workgroup = workgroupname;
	  item->mountpath = mountpath;
	  reclist.append (item);
	}
      icount++;
    }
  config->setGroup (oldgroup);
  KListAction::setItems (getItemList ());
}

void
RecentMounts::saveEntries (KConfig * config, QString groupname)
{
  RecentMountItem *item = reclist.first ();
  QString counter;
  int icount = 0;
  QString oldgroup = config->group ();
  if (groupname == QString::null)
    groupname = "Recent Mounts";
  config->setGroup (groupname);
  for (icount = 0; icount < MAXRECENTS; icount++)
    {
      counter.setNum (icount);
      if (item)
	{
	  config->writeEntry (QString ("sharename_") + counter, item->share);
	  config->writeEntry (QString ("hostname_") + counter, item->host);
	  config->writeEntry (QString ("workgroupname_") + counter,
			      item->workgroup);
	  config->writeEntry (QString ("mountpath_") + counter,
			      item->mountpath);
	  item = reclist.next ();
	}
      else
	{
	  config->writeEntry (QString ("sharename_") + counter,
			      QString::null);
	  config->writeEntry (QString ("hostname_") + counter, QString::null);
	  config->writeEntry (QString ("workgroupname_") + counter,
			      QString::null);
	  config->writeEntry (QString ("mountpath_") + counter,
			      QString::null);
	}
    }
  config->setGroup (oldgroup);
}

const QStringList
RecentMounts::getRecentWorkgroups ()
{
  QStringList lst;
  RecentMountItem *item = reclist.first ();
  while (item)
    {
      lst.append (item->workgroup);
      item = reclist.next ();
    }
  return lst;
}

const QStringList
RecentMounts::getRecentHosts ()
{
  QStringList lst;
  RecentMountItem *item = reclist.first ();
  while (item)
    {
      lst.append (item->host);
      item = reclist.next ();
    }
  return lst;
}
