/***************************************************************************
                          password.cpp  -  description
                             -------------------
    begin                : Wed Sep 29 1999
    copyright            : (C) 1999 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>
#include <kdebug.h>

#include "password.h"

thePassword::thePassword (QWidget * parent, const char *name):PasswordDlg (parent, name,
	     true)
{
  str_username = "";
  str_password = "";
  canceled = false;
  this->setCaption (name);
  connect (btnCancel, SIGNAL (clicked ()), this, SLOT (CancelButton ()));
  connect (btnOk, SIGNAL (clicked ()), this, SLOT (OKButton ()));
  connect (btnHelp, SIGNAL (clicked ()), this, SLOT (slotHelp ()));
  txtUsername->setFocus ();
}

thePassword::~thePassword ()
{
}

void
thePassword::CancelButton ()
{
  str_username = "";
  str_password = "";
  canceled = true;
  done (0);
}

void
thePassword::OKButton ()
{
  str_username = txtUsername->text ();
  str_password = txtPassword->text ();
  canceled = false;
  done (1);
}

void
thePassword::setPassword (QString pw)
{
  str_password = pw;
  txtPassword->setText (str_password);
}

void
thePassword::setUsername (QString name)
{
  str_username = name;
  txtUsername->setText (str_username);
}

void
thePassword::setStoreIn (int idx)
{
  cmbStoreIn->clear ();
  if (idx >= 1)
    cmbStoreIn->insertItem (i18n ("Workgroup"), -1);
  if (idx >= 2)
    cmbStoreIn->insertItem (i18n ("Host"), -1);
  if (idx >= 3)
    cmbStoreIn->insertItem (i18n ("Share"), -1);
  kdDebug (7199) << "password.setStoreIn() :" << cmbStoreIn->
    currentItem () << endl;
  cmbStoreIn->setCurrentItem (idx - 1);
}

void
thePassword::slotHelp ()
{
  kapp->invokeHelp ("thepassword");
}
