/***************************************************************************
                          message.cpp  -  description
                             -------------------
    begin                : Wed Jan 31 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kmessagebox.h>
#include <qlabel.h>

#include "myktreelistitem.h"
#include "message.h"

Message::Message (QStringList & list, QWidget * parent, QString name):MessageDlg (parent, name,
	    true)
{
  setCaption (i18n ("Send message"));
  cmbNetnames->insertStringList (list);

  connect ((QObject *) btnCancel, SIGNAL (clicked ()), SLOT (slotCancel ()));
  connect ((QObject *) btnSend, SIGNAL (clicked ()), SLOT (slotSend ()));
}

Message::Message (QWidget * parent, QString name):MessageDlg (parent, name,
	    true)
{
  setCaption (i18n ("Send message"));
  cmbNetnames->setEnabled (false);
  lblNetName->setEnabled (false);
  connect ((QObject *) btnCancel, SIGNAL (clicked ()), SLOT (slotCancel ()));
  connect ((QObject *) btnSend, SIGNAL (clicked ()), SLOT (slotSend ()));
}

Message::~Message ()
{
}

void
Message::slotSend ()
{
  done (1);
}

void
Message::slotCancel ()
{
  done (0);
}

QString Message::getMessage ()
{
  return txtMessage->text ();
}

QString Message::getNetName ()
{
  return cmbNetnames->text (0);
}
