// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.56 $
#include "knodamaindockwindowbase.h"
#include "knodamaindockwindow.h"
#include "hk_kdedblistview.h"
#include "hk_kdeeximportdatabase.h"
#include "hk_kdedbdesigner.h"

#include <hk_connection.h>
#include <hk_dsvisible.h>
#include <hk_database.h>
#include <hk_report.h>
#include <hk_form.h>
#include <hk_referentialintegrity.h>
#include <hk_drivermanager.h>

#include <qapplication.h>
#include <qpixmap.h>
#include <qclipboard.h>
#include <qtoolbutton.h>
#include <qptrlist.h>
#include <qstringlist.h>

#include <kcombobox.h>
#include <kdockwidget.h>
#include <kfiledialog.h>
#include <kdirselectdialog.h>
#include <kmdichildview.h>
#include <kconfig.h>
#include <klocale.h>
#include <kapplication.h>
#include <kaction.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <kpopupmenu.h>
#include <kparts/part.h>

class knodamaindockwindowbaseprivate
{
  public:
  knodamaindockwindowbaseprivate()
  {
    p_maindockwidget=NULL;
    p_drivermanager=NULL;
    p_designer=NULL;
  }

KDockWidget*      p_maindockwidget;
QString           p_databasename;
QMainWindow*      p_viewcontainer;
hk_drivermanager* p_drivermanager;
hk_kdedbdesignerwindow* p_designer;
};



knodamaindockwindowbase::knodamaindockwindowbase(struct_commandlinefields* cl,
 	QWidget* parent,const char* name, WFlags f,
	const QString& /*dbname*/,const QString& /*form*/)
	:KMdiMainFrm(parent,name,KMdi::IDEAlMode,f),
	hk_dsvisible()
{
   p_listview=NULL;
   p_database=NULL;
    p_connection=NULL;
  // setStandardMDIMenuEnabled();
   p_partmanager=new KParts::PartManager(this);
   i18n("&Database");
   //p_partmanager->setAllowNestedParts(true);
   connect(p_partmanager,SIGNAL(partAdded(KParts::Part*))
   ,this,SLOT(slot_activate_closeaction()));
   connect(p_partmanager,SIGNAL(partRemoved(KParts::Part*))
   ,this,SLOT(slot_activate_closeaction()));
   connect(p_partmanager,SIGNAL(activePartChanged(KParts::Part*))
   ,this,SLOT(createGUI(KParts::Part*)));
   setXMLFile(locate("data","hk_kdeclasses/knodamaindockwindowbase.rc"));
   KIconLoader* loader=KGlobal::iconLoader();
   loader->addAppDir("hk_kdeclasses");
   resize( 596, 480 );

   QPixmap pixmap;
   p_private=new knodamaindockwindowbaseprivate;
   bool rt_only=false;
   if (cl) rt_only=cl->runtime_only;
   p_private->p_drivermanager=new hk_drivermanager(rt_only);


   if (cl && cl->p_guicommands &&!cl->p_guicommands->p_showlistwindow)
   {
     p_private->p_viewcontainer=NULL;
   }
   else
   {
    p_private->p_viewcontainer=new QMainWindow(this);
    p_listview=new hk_kdedblistview(p_private->p_viewcontainer);
   }

   QToolBar* toolbar=NULL;

   if (!runtime_only() && p_private->p_viewcontainer)
   {
   toolbar=new QToolBar(p_private->p_viewcontainer);
   newbutton=new QToolButton(loader->loadIcon("filenew",KIcon::Toolbar),i18n("New"),QString::null,
   					 p_listview,SLOT(new_clicked()),toolbar);
   alterbutton=new QToolButton(loader->loadIcon("edit",KIcon::Toolbar),i18n("Modify"),QString::null,
   					 p_listview,SLOT(alter_clicked()),toolbar);
   deletebutton=new QToolButton(loader->loadIcon("editdelete",KIcon::Toolbar),i18n("Delete"),QString::null,
   					 p_listview,SLOT(delete_clicked()),toolbar);
   startbutton=new QToolButton(loader->loadIcon("exec",KIcon::Toolbar),i18n("Start"),QString::null,
   					 p_listview,SLOT(start_clicked()),toolbar);
   }
   else
   {
    newbutton=NULL;
    alterbutton=NULL;
    deletebutton=NULL;
    startbutton=NULL;
   }



    if (p_private->p_viewcontainer)
    {
     p_private->p_viewcontainer->setCentralWidget(p_listview);
     p_private->p_viewcontainer->setCaption(i18n("Elements"));
    }
   if (p_listview)p_listview->setCaption(i18n("Elements"));

   if (p_private->p_viewcontainer)
   {
   KMdiToolViewAccessor* tool= addToolWindow(p_private->p_viewcontainer,KDockWidget::DockLeft,getMainDockWidget(),90);
   tool->show();

    }
   p_quitaction=new KAction(i18n("E&xit"),"exit",0,this,SLOT(close()),actionCollection(),"quit");
   p_closeaction=new KAction(i18n("&Close"),"fileclose",0,this,SLOT(slot_closewindow()),actionCollection(),"close");
   p_closeaction->setEnabled(false);
   if ((cl &&cl->p_guicommands &&cl->p_guicommands->p_showlistwindow)||!cl)
   {
   p_databasecombobox= new KComboBox(0L,"p_databasecombobox");
   p_databasecombobox->setMinimumWidth(200);

   QLabel* label=new QLabel(0L);
   label->setText(i18n("Database: "));
   new KWidgetAction(label,"",0,0,0,actionCollection(),"databaselabel");
   p_databaseaction=new KWidgetAction(p_databasecombobox,i18n("Select database"),0,0,0,actionCollection(),"databaseselect");
   }
   else
   {
   p_databasecombobox=NULL;
   p_databaseaction=NULL;
   }

    p_newobjectaction= new KActionMenu(i18n("&New"),0,actionCollection(),"newobject");

    if ((cl&&cl->p_guicommands->p_showlistwindow)||!cl)
    {
    p_newconnectionaction= new KActionMenu(i18n("&Connect to"),"connect_creating",actionCollection(),"newconnection");
    p_disconnectaction= new KAction(i18n("Disconnect"),"connect_no",0,this,SLOT(slot_disconnect()),actionCollection(),"disconnect");
    connect(p_newconnectionaction->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(show_drivers()));
    }
    else
    {
    p_newconnectionaction=NULL;
    p_disconnectaction=NULL;
    }

    p_loadconnection= new KAction(i18n("Load connection"),"contents",0,this,SLOT(slot_load_connection()),actionCollection(),"loadconnection");
    p_storeconnection= new KAction(i18n("Store connection"),"contents2",0,this,SLOT(slot_store_connection()),actionCollection(),"storeconnection");
    p_newdatabaseaction= new KAction(i18n("Database"),"contents",0,this,SLOT(slot_new_database()),actionCollection(),"newdatabase");
    p_newtableaction= new KAction(i18n("Table"),"viewtext",0,this,SLOT(slot_new_table()),actionCollection(),"newtable");
    p_newqueryaction= new KAction(i18n("Query"),"filefind",0,this,SLOT(slot_new_query()),actionCollection(),"newquery");

    p_newviewaction= new KAction(i18n("View"),"filefind",0,this,SLOT(slot_new_view()),actionCollection(),"newview");
    p_newformaction= new KAction(i18n("Form"),"openterm",0,this,SLOT(slot_new_form()),actionCollection(),"newform");
    p_newreportaction= new KAction(i18n("Report"),"fileprint",0,this,SLOT(slot_new_report()),actionCollection(),"newreport");
    p_newmoduleaction= new KAction(i18n("Module"),"edit",0,this,SLOT(slot_new_module()),actionCollection(),"newmodule");
    p_newobjectaction->insert(p_newdatabaseaction);
    p_newobjectaction->insert(p_newtableaction);
    p_newobjectaction->insert(p_newviewaction);
    p_newobjectaction->insert(p_newqueryaction);
    p_newobjectaction->insert(p_newformaction);
    p_newobjectaction->insert(p_newreportaction);
    p_newobjectaction->insert(p_newmoduleaction);


    p_displaymodeaction= new KActionMenu(i18n("Displaymode"),0,actionCollection(),"displaymode");
    p_idealmodeaction=new KRadioAction(i18n("IDEAL Mode"),0,0,this,SLOT(switchToIDEAlMode()),actionCollection(),"idealmode");
    p_tabpagemodeaction=new KRadioAction(i18n("Tabpage Mode"),0,0,this,SLOT(switchToTabPageMode()),actionCollection(),"tabpagemode");
    p_childframemodeaction=new KRadioAction(i18n("Childframe Mode"),0,0,this,SLOT(switchToChildframeMode()),actionCollection(),"childframemode");
//    p_toplevelmodeaction=new KRadioAction(i18n("Toplevel Mode"),0,0,this,SLOT(switchToToplevelMode()),actionCollection(),"toplevelmode");

    p_idealmodeaction->setExclusiveGroup("displaymode");
    p_tabpagemodeaction->setExclusiveGroup("displaymode");
    p_childframemodeaction->setExclusiveGroup("displaymode");
    //p_toplevelmodeaction->setExclusiveGroup("displaymode");

    p_displaymodeaction->insert(p_idealmodeaction);
    p_displaymodeaction->insert(p_tabpagemodeaction);
    p_displaymodeaction->insert(p_childframemodeaction);
    //p_displaymodeaction->insert(p_toplevelmodeaction);


    p_newaction= new KAction(i18n("&New"),"filenew",0,p_listview,SLOT(new_clicked()),actionCollection(),"newclicked");
    if (newbutton)p_newaction->plug(newbutton);
    p_alteraction= new KAction(i18n("&Modify"),"edit",0,p_listview,SLOT(alter_clicked()),actionCollection(),"alterclicked");
    //p_alteraction->plug(toolbar);
    p_startaction= new KAction(i18n("&Start"),"exec",0,p_listview,SLOT(start_clicked()),actionCollection(),"startclicked");
    p_deleteaction= new KAction(i18n("&Delete"),"editdelete",SHIFT+Key_Delete,p_listview,SLOT(delete_clicked()),actionCollection(),"deleteclicked");
    p_renameaction=new KAction(i18n("&Rename"),0,0,this,SLOT(rename_clicked()),actionCollection(),"renameclicked");
    p_alteraction->setEnabled(false);
    p_startaction->setEnabled(false);
    p_deleteaction->setEnabled(false);

    p_exportaction= new KActionMenu(i18n("E&xport"),0,actionCollection(),"export");
    p_exportcsvaction= new KAction(i18n("&CSV"),0,0,this,SLOT(exportcsv_clicked()),actionCollection(),"exportcsv");
    p_exportxmlaction= new KAction(i18n("&XML"),0,0,this,SLOT(exportxml_clicked()),actionCollection(),"exportxml");
    p_exportaction->insert(p_exportcsvaction);
    p_exportaction->insert(p_exportxmlaction);
    p_exportdatabaseaction= new KActionMenu(i18n("To &database"),0,actionCollection(),"exportdatabase");
    p_exportaction->insert(p_exportdatabaseaction);
    connect(p_exportdatabaseaction->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(show_exportdbdrivers()));
    p_exportaction->setEnabled(false);
    p_importaction= new KActionMenu(i18n("I&mport"),0,actionCollection(),"import");
    p_importaction->setEnabled(false);
    p_importcsvaction= new KAction(i18n("&CSV"),0,0,this,SLOT(importcsv_clicked()),actionCollection(),"importcsv");
    p_importaction->insert(p_importcsvaction);
    p_importdatabaseaction= new KActionMenu(i18n("From &database"),0,actionCollection(),"importdatabase");
    p_importaction->insert(p_importdatabaseaction);
    connect(p_importdatabaseaction->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(show_importdbdrivers()));

    p_passwordaction= new KAction(i18n("&Change password"),0,0,this,SLOT(newpassworddialog_selected()),actionCollection(),"changepassword");
    p_copyaction= new KAction(i18n("&Copy"),"editcopy",SHIFT+CTRL+Key_C,this,SLOT(copy_clicked()),actionCollection(),"copy");
    p_pasteaction= new KAction(i18n("&Paste"),"editpaste",SHIFT+CTRL+Key_V,this,SLOT(paste_clicked()),actionCollection(),"paste");
    p_databasesettingaction= new KAction(i18n("&Database settings"),0,0,this,SLOT(databasesettings_clicked()),actionCollection(),"dbsettings");
    p_objecthandleraction= new KAction(i18n("&Object handler"),0,0,this,SLOT(objecthandler_clicked()),actionCollection(),"objecthandler");
    p_objecthandleraction->setEnabled(false);
    p_newwindowaction= new KAction(i18n("&New databasewindow"),0,0,this,SLOT(newwindow_clicked()),actionCollection(),"newwindow");
    p_settingsaction= new KAction(i18n("&Options"),"configure",0,this,SLOT(settings_clicked()),actionCollection(),"settings");

    p_openlocaldbaction=  new KAction(i18n("Open &local database"),"fileopen",0,this,SLOT(slot_open_localdatabase()),actionCollection(),"openlocaldb");
   p_openlocaldbaction->setEnabled(false);
      p_referentialintegrityaction=new KAction(i18n("Referential integrity"),loader->loadIcon("dbdesigner",KIcon::User),0,this,SLOT(slot_referentialintegrity()),actionCollection(),"referentialintegrity");
   p_referentialintegrityaction->setEnabled(false);


   set_connection(NULL);



  connect (QApplication::clipboard(), SIGNAL(dataChanged()),this, SLOT(clipboarddata_has_changed()));

   if(p_databasecombobox)
   connect(p_databasecombobox,SIGNAL(activated(int)),this,SLOT(slot_database_selected(int)));
   if (p_listview)
   {
   connect(p_listview,SIGNAL(signal_delete_database(const QString&)),this,SLOT(slot_delete_database(const QString&)));
   connect(p_listview,SIGNAL(signal_new_database(void)),this,SLOT(slot_new_database(void)));
   connect(p_listview,SIGNAL(signal_reload_databases(void)),this,SLOT(set_databases(void)));

   connect(p_listview,SIGNAL(signal_viewmode_table(const QString&)),this,SLOT(slot_viewmode_table(const QString&)));
   connect(p_listview,SIGNAL(signal_designmode_table(const QString&)),this,SLOT(slot_designmode_table(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_table(const QString&)),this,SLOT(slot_delete_table(const QString&)));
   connect(p_listview,SIGNAL(signal_new_table(void)),this,SLOT(slot_new_table(void)));

   connect(p_listview,SIGNAL(signal_viewmode_query(const QString&)),this,SLOT(slot_viewmode_query(const QString&)));
   connect(p_listview,SIGNAL(signal_designmode_query(const QString&)),this,SLOT(slot_designmode_query(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_query(const QString&)),this,SLOT(slot_delete_query(const QString&)));
   connect(p_listview,SIGNAL(signal_new_query(void)),this,SLOT(slot_new_query(void)));

   connect(p_listview,SIGNAL(signal_viewmode_view(const QString&)),this,SLOT(slot_viewmode_view(const QString&)));
   connect(p_listview,SIGNAL(signal_designmode_view(const QString&)),this,SLOT(slot_designmode_view(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_view(const QString&)),this,SLOT(slot_delete_view(const QString&)));
   connect(p_listview,SIGNAL(signal_new_view(void)),this,SLOT(slot_new_view(void)));

   connect(p_listview,SIGNAL(signal_viewmode_form(const QString&)),this,SLOT(slot_viewmode_form(const QString&)));
   connect(p_listview,SIGNAL(signal_designmode_form(const QString&)),this,SLOT(slot_designmode_form(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_form(const QString&)),this,SLOT(slot_delete_form(const QString&)));
   connect(p_listview,SIGNAL(signal_new_form(void)),this,SLOT(slot_new_form(void)));

   connect(p_listview,SIGNAL(signal_viewmode_report(const QString&)),this,SLOT(slot_viewmode_report(const QString&)));
   connect(p_listview,SIGNAL(signal_designmode_report(const QString&)),this,SLOT(slot_designmode_report(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_report(const QString&)),this,SLOT(slot_delete_report(const QString&)));
   connect(p_listview,SIGNAL(signal_new_report(void)),this,SLOT(slot_new_report(void)));

   connect(p_listview,SIGNAL(signal_designmode_module(const QString&)),this,SLOT(slot_designmode_module(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_module(const QString&)),this,SLOT(slot_delete_module(const QString&)));
   connect(p_listview,SIGNAL(signal_new_module(void)),this,SLOT(slot_new_module(void)));
   
   connect(p_listview, SIGNAL(contextMenuRequested(QListViewItem*,const QPoint&, int)),
   this,SLOT(slot_listbox_popup(QListViewItem*,const QPoint&)));
   
   }
//   createShellGUI(true);
   createGUI(0L);
   slot_database_selected(0);
//   setManagedDockPositionModeEnabled(true);
   KConfig* config=kapp->config();
         connect(kapp,SIGNAL(lastWindowClosed()),kapp,SLOT(quit()));

   applyMainWindowSettings( config, "knodamain" );
   QString value=config->readEntry("MDIMode","None");
   if (value!="None")
      readDockConfig(config,"knodamaindock");

/*    KMdi::MdiMode m=mdiMode();
    switch (m)
    {
      //case KMdi::ToplevelMode: p_toplevelmodeaction->setChecked(true); break;
      case KMdi::ChildframeMode: p_childframemodeaction->setChecked(true); break;
      case KMdi::TabPageMode: p_tabpagemodeaction->setChecked(true); break;
      case KMdi::IDEAlMode: p_idealmodeaction->setChecked(true); break;
      default:;
    };*/
  if (cl)
  {
    if (cl->p_guicommands->p_load_connection)
    {
   hk_database* db=p_private->p_drivermanager->open_connectionfile(cl->database);
   if (db)
   {
     hk_string dbname=db->name();
     set_connection(db->connection());
     internal_set_database(dbname);
   }
   /*else
     show_warningmessage(hk_translate("Database could not be loaded"));*/
    }
    else
    {
    if (cl->driver.size()>0) set_drivername(cl->driver);
    if (cl->database.size()>0) internal_set_database(cl->database);
    }
  }
#if KDE_VERSION_MAJOR >=3 && KDE_VERSION_MINOR >2
setTabWidgetVisibility(KMdi::AlwaysShowTabs); // only exists since KDE 3.3
//setToolviewStyle(KMdi::TextOnly);
#endif

}


knodamaindockwindowbase::~knodamaindockwindowbase()
{
  delete p_partmanager;
  delete p_quitaction;
  delete p_databaseaction;
  delete p_openlocaldbaction;
  delete p_private->p_drivermanager;
  delete p_private;
}

hk_connection* knodamaindockwindowbase::connection(void)
{
  return p_connection;
}



void knodamaindockwindowbase::closeEvent(QCloseEvent*event)
{



KConfig* c=kapp->config();
QString value="ideal";
if (!runtime_only())
{
saveMainWindowSettings( c, "knodamain" );
c->setGroup("knodamain");
c->writeEntry("MDIMode",value);
writeDockConfig(c,"knodamaindock");
}

while (m_pCurrentWindow)
{     //cerr<<"   closewindow: "<<m_pCurrentWindow->className()<<endl;
       hk_report* r=dynamic_cast<hk_report*>(m_pCurrentWindow->focusedChildWidget());
       if (r  && r->while_executing())
         {
	   event->ignore();
           show_warningmessage(replace_all("%1",hk_translate("Cannot close now, because the report '%1' is executing. Cancel it first"),r->name()));
	   return;

	 }
	else
	{ 
	QWidget* w=m_pCurrentWindow->focusedChildWidget();
	while (w)
	{
	
	hk_form* f=dynamic_cast<hk_form*>(w);
	if (f&&f->while_load_form())
	{
	   event->ignore();
	 show_warningmessage("close while_loadform");
	 return;
	}
	w=w->parentWidget();
	}
	}
      closeWindow(m_pCurrentWindow);
}
KMdiMainFrm::closeEvent(event);
qApp->processEvents();
if (p_database)
   { 
       p_database->disable();
      delete p_database;
   }
p_database=NULL;
}


void knodamaindockwindowbase::slot_database_selected(int )
{
if (!p_connection ) return;

  QString newdb;
  if (p_databasecombobox)newdb=p_databasecombobox->currentText();
  if (newdb!=p_private->p_databasename)
  {
    internal_set_database(u2l(newdb.utf8().data()));
  }

}

void knodamaindockwindowbase::internal_set_database(const hk_string& newdb)
{
   if (newdb.size()==0) return;
   if (p_connection && !p_connection->database_exists(newdb) )
    {
     show_warningmessage(replace_all("%1",hk_translate("Database '%1' not found"),newdb));
     return;
    }
   if (p_connection && !p_database) p_database=p_connection->new_database();
     if (p_database!=NULL)
      {
        if (p_database->set_name(newdb))
            p_private->p_databasename=QString::fromUtf8(l2u(newdb).c_str());
          else p_private->p_databasename="";
        set_datasource(p_database->new_resultquery());
        p_database->set_usewidgetparent(this);
      }
  if (p_listview)p_listview->set_database(p_database);
  p_objecthandleraction->setEnabled(p_database&& p_database->has_centralstoragetable()&&!runtime_only());
if (p_databasecombobox)p_databasecombobox->setCurrentText(QString::fromUtf8(l2u(newdb).c_str()));
if (p_database)
{  //automatically start "Autoform" when not --strongruntime is set
  if (p_database->form_exists(u2l(autoform.utf8().data())))
     slot_viewmode_form(autoform);
}

}


void knodamaindockwindowbase::set_databases(void)
{
  if (!p_databasecombobox) return;
  QString curtext=p_databasecombobox->currentText();
  if (p_connection&& p_connection->server_needs(hk_connection::NEEDS_DATABASENAME)&& curtext.isEmpty()) curtext=QString::fromUtf8(l2u(p_connection->defaultdatabase()).c_str());
  p_databasecombobox->clear();
  if (!p_connection) return;
  vector<hk_string>* db=p_connection->dblist();
  vector<hk_string>::iterator it;
  p_databasecombobox->blockSignals(true);
  bool dbfound=false;
  if (db!=NULL)
     {
        int i=0;
        for(it=db->begin();it!=db->end();it++)
          {
            p_databasecombobox->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
             if (curtext==QString::fromUtf8(l2u((*it)).c_str()))
               {
                p_databasecombobox->setCurrentItem(i);
		dbfound=true;
               }
            i++;
          }

     }
     if (!dbfound)slot_database_selected(0);

  p_databasecombobox->blockSignals(false);

}

void knodamaindockwindowbase::set_connection(hk_connection* c)
{

p_connection=c;
p_database=NULL;
p_private->p_databasename="";
if (p_listview)p_listview->set_database(NULL);
set_datasource(NULL);
if (!p_connection)set_databases();
if (p_connection)
    { p_importaction->setEnabled(true);
      p_exportaction->setEnabled(true);
        hk_string s=c->drivername()+" "+c->user()+"@"+c->host()+":"+ulongint2string(c->tcp_port());
        setCaption(QString::fromUtf8(l2u(s).c_str()));
        p_newdatabaseaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_NEW_DATABASE));
       set_databases();
      p_openlocaldbaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_LOCAL_FILEFORMAT));
      p_referentialintegrityaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_REFERENTIALINTEGRITY));
      p_importcsvaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_NEW_TABLE));
    }
if (p_listview)p_listview->setEnabled(p_connection);
if (p_databasecombobox)p_databasecombobox->setEnabled(p_connection);
if (p_private->p_viewcontainer)p_private->p_viewcontainer->setEnabled(p_connection);
p_renameaction->setEnabled(p_connection);
p_copyaction->setEnabled(p_connection);
p_passwordaction->setEnabled(p_connection&&p_connection->server_needs(hk_connection::NEEDS_PASSWORD));

if (p_disconnectaction)p_disconnectaction->setEnabled(p_connection);
p_storeconnection->setEnabled(p_connection&&!runtime_only());
p_newobjectaction->setEnabled(p_connection&&!runtime_only());
p_newaction->setEnabled(p_connection&&!runtime_only());
p_databasesettingaction->setEnabled(p_connection&&!runtime_only());
}



void knodamaindockwindowbase::exportdbdriver_selected(int index)
{
   vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    hk_string drvname;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        if (di==index)
	{
	     drvname=(*it);
	     break;

	}
        di++;
    }
     if (drvname.size()==0) return;


 hk_connection* con=p_private->p_drivermanager->new_connection(drvname);
 if (con!=NULL)
  {
  	if (!con->show_passworddialog())
       	{
      	delete con;
        return;
      	}
       if (con->server_needs(hk_connection::NEEDS_DATABASENAME))
	   {
	     //internal_set_database(con->defaultdatabase());
	   }
       if (con->connect())
        {
	   hk_kdeeximportdatabase* dialog=new   hk_kdeeximportdatabase(p_database,con,hk_kdeeximportdatabase::m_export);
	   dialog->exec();
           delete dialog;
	}

   delete con;

   }




}


void knodamaindockwindowbase::importdbdriver_selected(int index)
{
  vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    hk_string drvname;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        if (di==index)
	{
	     drvname=(*it);
	     break;

	}
        di++;
    }
     if (drvname.size()==0) return;

 hk_connection* con=p_private->p_drivermanager->new_connection(drvname);
 if (con!=NULL)
  {
  	if (!con->show_passworddialog())
       	{
      	delete con;
        return;
      	}
       if (con->server_needs(hk_connection::NEEDS_DATABASENAME))
	   {
	     //internal_set_database(con->defaultdatabase());
	   }
       if (con->connect())
        {
	   hk_kdeeximportdatabase* dialog=new   hk_kdeeximportdatabase(p_database,con,hk_kdeeximportdatabase::m_import);
	   dialog->exec();
           delete dialog;
	}

   delete con;

   }



}





void knodamaindockwindowbase::driver_selected(int index)
{
   vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    hk_string drvname;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        if (di==index)
	{
	     drvname=(*it);
	     break;

	}
        di++;
    }
     if (drvname.size()==0) return;

    if (p_connection)
    {
      knodamaindockwindow* w=internal_new_dockwindow();
      w->set_drivername(drvname);
      w->show();
      return;

    }


    hk_connection* c=p_connection;
    if (c)
    {
    set_connection(NULL);

      c->disconnect();
      delete c;
      c=NULL;
    }
    p_private->p_databasename="";
    set_drivername(drvname);


}


knodamaindockwindow* knodamaindockwindowbase::internal_new_dockwindow(void)
{
 struct_commands commands;
 struct_commandlinefields cp;
 cp.p_guicommands=&commands;
 commands.p_showlistwindow=(p_private->p_viewcontainer!=NULL);
 cp.runtime_only=runtime_only()||!commands.p_showlistwindow;
  knodamaindockwindow* w=new knodamaindockwindow(&cp);
 return w;
}















void knodamaindockwindowbase::set_drivername(const hk_string& dr)
{
 hk_connection* con=p_private->p_drivermanager->new_connection(dr);
 if (con!=NULL)
  {
  	if (!con->show_passworddialog())
       	{
      	delete con;
        return;
      	}
       if (con->server_needs(hk_connection::NEEDS_DATABASENAME))
	   {
	     internal_set_database(con->defaultdatabase());
	   }
       if (con->connect())
        {
 	  set_connection(con);
       if (con->server_needs(hk_connection::NEEDS_DATABASENAME))
	   {
	     internal_set_database(con->defaultdatabase());
	   }


	}
	else
	{
	 delete con;

	}
   }
}



void knodamaindockwindowbase::slot_activate_closeaction()
{
  const QPtrList<KParts::Part>* p=p_partmanager->parts();
  if (!p) p_closeaction->setEnabled(false);
  else p_closeaction->setEnabled(!p->isEmpty());
}


void knodamaindockwindowbase::slot_closewindow()
{
  KParts::Part* p=p_partmanager->activePart();
  if (!p) return;
  p->widget()->close();
}


void knodamaindockwindowbase::slot_disconnect(void)
{

 if (p_connection)p_connection->disconnect();
 delete p_connection;
 p_openlocaldbaction->setEnabled(false);
 p_referentialintegrityaction->setEnabled(false);
 p_objecthandleraction->setEnabled(false);
 p_importaction->setEnabled(false);
 p_exportaction->setEnabled(false);
 set_connection(NULL);
}


void knodamaindockwindowbase::slot_open_localdatabase()
{
  if (!p_connection) return;
  QStringList l;
  QString xmime=QString::fromUtf8(l2u(p_connection->mimetype()).c_str());
  l.append(xmime);cerr <<"add xmime:"<<xmime<<endl;
  l.append("all/allfiles");
  QString p=":"+QString::fromUtf8(l2u(p_connection->drivername()).c_str());
  QString filename;
  filename=QString::null;

  if (p_connection->server_needs(hk_connection::NEEDS_DIRECTORY_AS_DATABASE))
  {
    KDirSelectDialog* d=new KDirSelectDialog(p,false,this,0,true);
    d->exec();
    filename=d->url().directory(false,false);
    if (!filename.isNull())
      if (!d->url().fileName().isEmpty())
      filename+=d->url().fileName();
    delete d;
  
  }
  else
  {
    KFileDialog* d=new KFileDialog(p,QString::null,this,0,true);
    d->setMimeFilter(l,xmime);
    d->exec();
    filename=d->selectedFile();
    delete d;
  }
  if (!filename.isNull())
  {
  cerr <<"FILENAME="<<filename<<endl;
      if (p_databasecombobox)
        p_databasecombobox->insertItem(filename);
     internal_set_database(u2l(filename.utf8().data()));
  }
}


void knodamaindockwindowbase::slot_referentialintegrity()
{
    if (!p_private->p_designer)
       p_private->p_designer=new hk_kdedbdesignerwindow();
//    connect (p_private->p_designer,SIGNAL(signal_closed()),this,SLOT(designer_deleted()));
    p_private->p_designer->designer()->set_database(p_database);
    hk_referentialintegrity* rf=new hk_referentialintegrity();
    rf->set_database(p_database);
    rf->load_referentialintegrity();
    p_private->p_designer->designer()->set_presentation(rf);
    //set_block_has_changed(true);
    p_private->p_designer->show();
    //set_block_has_changed(false);
    connect (p_private->p_designer,SIGNAL(signal_closed()),this,SLOT(designer_deleted()));

}

void knodamaindockwindowbase::designer_deleted(void)
{
cerr<<"designer_deleted"<<endl;

p_private->p_designer=NULL;
}



void knodamaindockwindowbase::slot_load_connection()
{
  if (!p_private->p_drivermanager) return;
  QStringList l;
  QString xmime="application/x-hk_connection";
  l.append(xmime);
KFileDialog* d=new KFileDialog(":hkc",QString::null,this,0,true);
d->setMimeFilter(l,xmime);
d->exec();
QString filename=d->selectedFile();
  if (!filename.isNull())
  {
//execute new connection
   hk_database* db=p_private->p_drivermanager->open_connectionfile(u2l(filename.utf8().data()));
   if (db)
   {
     hk_string dbname=db->name();
    if (p_connection)
    {
       knodamaindockwindow* w=internal_new_dockwindow();

	w->set_connection(db->connection());
	w->internal_set_database(dbname);
	w->show();

    }
    else
    {
     set_connection(db->connection());
     internal_set_database(dbname);
    }
   }
  }
delete d;
}


void knodamaindockwindowbase::slot_store_connection()
{
  if (!p_database) return;
  QStringList l;
  QString xmime="application/x-hk_connection";
  l.append(xmime);cerr <<"add xmime:"<<xmime<<endl;
KFileDialog* d=new KFileDialog(":hkc",QString::null,this,0,true);
d->setMimeFilter(l,xmime);
d->setOperationMode(KFileDialog::Saving);
d->exec();

QString filename=d->selectedFile();
  if (!filename.isNull())
  {
  KConfig* c=kapp->config();
  c->setGroup("Preferences");
  bool g=c->readBoolEntry("StorePassword",false);
   p_database->store_connectionfile(u2l(filename.utf8().data()),g);
  }
delete d;
}



