//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFPROTOCOLLISTVIEW_H
#define KMFPROTOCOLLISTVIEW_H

#include "kmyfirewallprotocollistview.h"

#include <qptrlist.h>
#include <qstring.h>
#include <qguardedptr.h>
#include <qpixmap.h>
#include <quuid.h>



class QListViewItem;

namespace KMF {
class KMFProtocolUsage;
class KMFProtocolCategory;
class KMFNetZone;
class KMFNetHost;

class KMFProtocolListView : public KMyFirewallProtocolListView {
		Q_OBJECT

	public:
		KMFProtocolListView ( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~KMFProtocolListView();
		/*$PUBLIC_FUNCTIONS$*/
		void setHost( KMFNetHost* host );
		void setZone( KMFNetZone* zone );
		void loadProtocols();
	public slots:
		/*$PUBLIC_SLOTS$*/

	protected:
		/*$PROTECTED_FUNCTIONS$*/

	protected slots:
		/*$PROTECTED_SLOTS$*/
		void slotNewProtocolSelected( QListViewItem* );
		void slotOnProtocolDeleted( QObject* );
		
	private:
		QGuardedPtr<KMFNetHost> *m_host;
		QGuardedPtr<KMFNetZone> *m_zone;
		bool m_reloading;
		
	signals:
		void sigProtocolClicked( KMFProtocolUsage*, bool );
		void sigProtocolCategoryClicked( KMFProtocolCategory* );
};
}
#endif

