/***************************************************************************
                          contactpropertiesdialog.cpp  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002 by Michael Curtis
    email                : magnalium@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qobject.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qtoolbutton.h>

#include <kdebug.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <klocale.h>

#include "../contact/contact.h"
#include "../kmessdebug.h"
#include "contactpropertiesdialog.h"



ContactPropertiesDialog::ContactPropertiesDialog(QWidget *parent, const char *name )
 : KDialogBase( parent, name, false, QString::null, Ok | Cancel , Ok, true )
{
  KIconLoader *loader = KGlobal::iconLoader();
  QSize        size;

  // Set the dialog size
  size = configDialogSize("ContactPropertiesDialog");
  if ( ( size.height() == 0 ) && ( size.width() == 0 ) )
  {
    size.setWidth(450);
    size.setHeight(220);
  }

  // Create the widgets
  QWidget *page = new QWidget( this );
  setMainWidget( page );

  QVBoxLayout *mainLayout = new QVBoxLayout( page, 0, spacingHint() );

  // Create the email address: line
  emailLabel_ = new QLabel( page, "emailLabel" );
  mainLayout->addWidget( emailLabel_ );

  // Create the "Current Name: blah*#89!" line
  trueNameLabel_ = new QLabel( page, "trueNameLabel" );
  mainLayout->addWidget( trueNameLabel_ );

  // Create the "[X] Use alternative name" line
  alternativeNameCheckBox_ = new QCheckBox( i18n( "Use an alternative name for this person" ), page, "alternativeNameCheckBox" );
  mainLayout->addWidget( alternativeNameCheckBox_ );

  // Create the "  ____name____" line
  nameEdit_ = new KLineEdit( page, "nameEdit" );
  mainLayout->addWidget( nameEdit_ );

  // Create the "[X] Show a notification" line
  notifyOnlineCheckBox_ = new QCheckBox( i18n( "Show a popup balloon when this person goes online or offline" ), page, "notifyOnlineCheckBox" );
  mainLayout->addWidget( notifyOnlineCheckBox_ );

  // Create a grid layout for the " Picture: __blah.png___ [...] " line
  //  and the " Sound: __blah.ogg___ [...] " line
  QGridLayout *fileLayout = new QGridLayout( 0, 3, 3, 0, 0, "fileLayout" );

  QLabel *pictureLabel = new QLabel( i18n("Picture:"), page, "pictureLabel" );
  pictureLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
  fileLayout->addWidget( pictureLabel, 0, 0 );

  pictureEdit_ = new KLineEdit( page, "pictureEdit" );
  fileLayout->addWidget( pictureEdit_, 0, 1  );

  QToolButton *pictureButton = new QToolButton( page, "pictureButton" );
  pictureButton->setPixmap( loader->loadIcon( "fileopen", KIcon::Small ) );
  fileLayout->addWidget( pictureButton, 0, 2 );

  QLabel *soundLabel = new QLabel( i18n("Sound:"), page, "soundLabel" );
  soundLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
  fileLayout->addWidget( soundLabel, 1, 0 );

  soundEdit_ = new KLineEdit( page, "soundEdit" );
  fileLayout->addWidget( soundEdit_, 1, 1 );

  QToolButton *soundButton = new QToolButton( page, "soundButton" );
  soundButton->setPixmap( loader->loadIcon( "fileopen", KIcon::Small ) );
  fileLayout->addWidget( soundButton, 1, 2 );

  mainLayout->addLayout( fileLayout );

  connect( alternativeNameCheckBox_, SIGNAL(                         toggled(bool) ),
           this,                     SLOT  (  alternativeNameCheckBoxToggled(bool) ) );
  connect( notifyOnlineCheckBox_,    SIGNAL(                         toggled(bool) ),
           this,                     SLOT  (     notifyOnlineCheckBoxToggled(bool) ) );
  connect( pictureButton,            SIGNAL(                         clicked()     ),
           this,                     SLOT  (                   choosePicture()     ) );
  connect( soundButton,              SIGNAL(                         clicked()     ),
           this,                     SLOT  (                     chooseSound()     ) );
}



ContactPropertiesDialog::~ContactPropertiesDialog()
{
#ifdef KMESSDEBUG_CONTACTPROPERTIES
  kdDebug() << "DESTROYED ContactPropertiesDialog" << endl;
#endif
}


// The alt name checkbox was toggled.
void ContactPropertiesDialog::alternativeNameCheckBoxToggled(bool checked)
{
  nameEdit_->setEnabled( checked );
}



// Apply all values in the widgets to the contact extension.
void ContactPropertiesDialog::applyChanges()
{
  ContactExtension *extension;

  extension = contact_->getExtension();

  // if the user clears the name edit, be user-friendly and decide that what
  // they really wanted to do was turn off the alternative name override.
  if ( nameEdit_->text().isEmpty() )
  {
    extension->setUseAlternativeName( false );
  }
  else
  {
    extension->setUseAlternativeName( alternativeNameCheckBox_->isChecked() );
  }
  extension->setAlternativeName( nameEdit_->text() );

  extension->setNotifyOnline( notifyOnlineCheckBox_->isChecked() );
  extension->setContactPicturePath( pictureEdit_->text() );
  extension->setContactSoundPath  ( soundEdit_->text() );
}



// Get the location of a file from the user, using a KFile dialog
//  Uses the contents of the KLineEdit as a default, and replaces the contents
//   of said widget with the result of the file selection dialog.
void ContactPropertiesDialog::chooseFile(KLineEdit *edit, QString wildcard)
{
  QString file;

  file = edit->text();

  file = KFileDialog::getOpenFileName( file, wildcard, this );
  
  if ( !file.isEmpty() )
  {
    edit->setText( file );
  }
  
}



// Choose a picture file (KFile dialog)
void ContactPropertiesDialog::choosePicture()
{
  chooseFile( pictureEdit_, "*.png" );
}



// Choose a sound file (KFile dialog)
void ContactPropertiesDialog::chooseSound()
{
  chooseFile( soundEdit_, "*.ogg" );
}



// Show the dialog and obtain the contact handle.
bool ContactPropertiesDialog::launch(Contact *contact)
{
#ifdef KMESSDEBUG_CONTACTPROPERTIES
  kdDebug() << "ContactPropertiesDialog - Launch with contact " << contact->getHandle() << endl;
#endif
  QString dialogCaption;

  // Reset the "ok"
  ok_ = false;

  // Copy the pointer to the contact class
  contact_ = contact;

  // Set the dialog title
  dialogCaption = i18n("Contact Properties for %1").arg( contact->getHandle() );
  setCaption( dialogCaption );

  // Setup the dialog
  setupWidgets();

  // Show the dialog modally
  exec();

  // If the ok button was pressed..
  if ( ok_ )
  {
    applyChanges();
  }

  return ok_;
}



// The online notification checkbox was toggled
void ContactPropertiesDialog::notifyOnlineCheckBoxToggled(bool checked)
{
  pictureEdit_->setEnabled( checked );
  soundEdit_->setEnabled( checked );
}



// Setup the dialog's widgets
void ContactPropertiesDialog::setupWidgets()
{
  emailLabel_->setText( i18n("Email address: ") + contact_->getHandle() );
  trueNameLabel_->setText( i18n("Current name: ") + contact_->getTrueFriendlyName() );
  alternativeNameCheckBox_->setChecked( contact_->getExtension()->getUseAlternativeName() );
  alternativeNameCheckBoxToggled( contact_->getExtension()->getUseAlternativeName() );
  nameEdit_->setText( contact_->getExtension()->getAlternativeName() );
  notifyOnlineCheckBox_->setChecked( contact_->getExtension()->getNotifyOnline() );
  notifyOnlineCheckBoxToggled( contact_->getExtension()->getNotifyOnline() );
  pictureEdit_->setText( contact_->getExtension()->getContactPicturePath() );
  soundEdit_  ->setText( contact_->getExtension()->getContactSoundPath()   );
}



// The Cancel button was pressed.
void ContactPropertiesDialog::slotCancel()
{
  saveDialogSize("ContactPropertiesDialog");
  reject();
}



// The OK button was pressed.
void ContactPropertiesDialog::slotOk()
{
  saveDialogSize("ContactPropertiesDialog");
  ok_ = true;
  accept();
}


#include "contactpropertiesdialog.moc"
