/***************************************************************************
                          emoticonchooser.cpp  -  description
                             -------------------
    begin                : Mon May 6 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "emoticonchooser.h"

#include <math.h>
#include <stdio.h>

#include <qevent.h>

#include <kapp.h>
#include <kdebug.h>
#include <kpushbutton.h>

#include "../kmessdebug.h"
#include "../emoticon.h"
#include "../emoticoncollection.h"
#include "emoticonbutton.h"

EmoticonChooser::EmoticonChooser(QWidget *parent, const char *name )
 : QDialog(parent, name, false, WStyle_Customize | WStyle_NoBorder ),
   buttonCount_(0),
   buttonHeight_(30),
   buttonsPerRow_(8),
   buttonWidth_(30),
   nCols_(0),
   nRows_(0)

{
  EmoticonCollection *emoticons;
  Emoticon *emoticon;

  setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
  setGeometry(100, 100, 200, 200);
  // Track the mouse so that the dialog can be hidden if the mouse is  moved off
  setMouseTracking(true);

  emoticons = EmoticonCollection::instance();

  for (emoticon = emoticons->first(); emoticon; emoticon = emoticons->next() )
  {
     if ( emoticon->isValid() )
     {
       createEmoticonButton( emoticon );
     }
  }
}



EmoticonChooser::~EmoticonChooser()
{
}



// Create an emoticon button on this dialog.
void EmoticonChooser::createEmoticonButton(const Emoticon *emoticon)
{
  EmoticonButton *button;
  unsigned int    row, col;

  // Create the button
  button = new EmoticonButton(emoticon, this);
  // Connect the button's insertEmoticon signal
  connect( button, SIGNAL( insertEmoticon( QString ) ),
           this, SLOT( requestInsertEmoticon( QString ) ) );
  // Figure out the button's placement.
  // Find the button's proper row and column.
  row = static_cast<unsigned int>( static_cast<double>(buttonCount_)
        / static_cast<double>(buttonsPerRow_) );
  col = buttonCount_ - row * buttonsPerRow_;
  // Check if the number of rows and columns should be increased.
  if ( row >= nRows_ )
    nRows_ = row + 1;
  if ( col >= nCols_ )
    nCols_ = col + 1;
  // Set the geometry of the button.
  button->setGeometry( row * buttonWidth_, col * buttonHeight_,
                       buttonWidth_, buttonHeight_ );
  button->setEnabled( true );

  // Set the width and height of the form.
  setFixedWidth( nRows_ * buttonWidth_ );
  setFixedHeight( nCols_ * buttonHeight_ );

  buttonCount_++;
}



// Hide the dialog when the user has moved his or her mouse off it.
void EmoticonChooser::leaveEvent ( QEvent * )
{
#ifdef KMESSDEBUG_EMOTICONCHOOSER
  kdDebug() << "EmoticonChooser::leaveEvent Leave" << endl;
#endif
  // Hide the dialog after leaving.
  hide();
}



// Show the dialog at the given position
void EmoticonChooser::popup( const QPoint & pos, int /*indexAtPoint*/)
{
#ifdef KMESSDEBUG_EMOTICONCHOOSER
  kdDebug() << "EmoticonChooser::popup" << endl;
#endif
  // Added/Updated by Scott Morgan - 2002-10-16
  // Make a QRect object to hold the position data
  QRect geo( pos, QSize( nRows_ * buttonWidth_, nCols_ * buttonHeight_ ) );

  // Which screen is this supposed to be on?
  int screen = kapp->desktop()->screenNumber( pos );
  if( screen >= 0 ) {
    // We've got the screen so lets adjust the position to fit within it
    QRect screenSize = kapp->desktop()->screenGeometry(screen);

    // Are we off the right hand side (most common)?
    if( geo.right() > screenSize.right() ) {
      geo.moveBy( screenSize.right()-geo.right(), 0 );
    }

    // Are we off the bottom of the screen?
    if( geo.bottom() > screenSize.bottom() ) {
      geo.moveBy( 0, screenSize.bottom()-geo.bottom() );
    }

    // Because everything is position from the top-left corner
    // there is no need to check that

    setGeometry( geo );
  } else {
    // Couldn't ID desktop use the default behaviour
    // (almost certainly not needed, but best to be safe)
    setGeometry( pos.x(), pos.y(), 200, 200 );
  }
  // End of changes
  /* Original code
  setGeometry( pos.x(), pos.y(), 200, 200 );
  */

  show();
}



// Signal (presumably to the chat view) to  insert the emoticon.
void EmoticonChooser::requestInsertEmoticon(QString html)
{
  emit insertEmoticon(html);
}

#include "emoticonchooser.moc"
