/***************************************************************************
                          chatwindow.h  -  description
                             -------------------
    begin                : Wed Jan 15 22:41:32 CST 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATWINDOW_H
#define CHATWINDOW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdatetime.h>
#include <qptrlist.h>
#include <qtimer.h>

#include <kapp.h>
#include <kdockwidget.h>

#include "chatwindowinterface.h"

// Forward declarations
class ChatInformation;
class ChatView;          
class Contact;
class ContactAction;
class ContactList;
class ContactSidebar;
class CurrentAccount;
class KMessTest;
class QDir;
class MsnSwitchboardConnection;

/* ChatWindow is the main window for a chat with one or more contacts */
class ChatWindow : public ChatWindowInterface
{
  Q_OBJECT 

  friend class KMessTest;

  public:
    // The construtor
                       ChatWindow(QWidget* parent=0, const char *name=0);
    // The destructor 
                      ~ChatWindow();
    // Initialize the object
    bool               initialize();
    // Return whether or not this is an exclusive chat with the given contact
    bool               isExclusiveChatWithContact( const QString& handle );
    // Start a chat
    void               startChat( ChatInformation *chatInfo );
    // Returns the switchboard connection: needed by the chatmaster networkwindow code
    MsnSwitchboardConnection *getSwitchboardConnection() const;

  protected:
    // Restore the window properties (called by KMainWindow)
    virtual void       readProperties(KConfig *config);
    // Save the window properties (called by KMainWindow)
    virtual void       saveProperties(KConfig *config);

  protected slots:
    // put the marked text/object into the clipboard and remove
    //	it from the document
    void               editCut();
    // put the marked text/object into the clipboard
    void               editCopy();
    // Bring up a dialog to change the message font color.
    void               editFontColor();
    // Bring up a dialog to change the message font color.
    void               editFont();
    // paste the clipboard into the document
    void               editPaste();
    // "Show status bar" was toggled.
    void               showStatusBar();
    // Start GnomeMeeting with a contact.
    void               startMeeting();
    // Change the status bar message.
    void               statusMessage(QString message);
    // Called when the "use emoticons" action is called.
    void               toggleEmoticons(bool useEmoticons);
    // Called when the "show sidebar" action is called.
    void               toggleSidebar();
    // Send a file to a contact.
    void               transferFile();
    //Voice conversation
    void               startConversation();

  private: // Private methods
    // Check if the user enabled an auto-reply, and send it
    void               checkAutoReply();
    // Check if the message is the first message and if so, pop up a window with the text.
    void               checkFirstMessage(const QString& handle, const QString& text);
    // Toggle the sidebar based on account preferences
    void               checkSidebarPreferences();
    // Create the contact actions
    void               createContactActions(ContactList *contactList);
    // Create the docking widgets
    bool               createDocking();
    // Return the contact action with the given handle
    ContactAction*     getContactActionByHandle(const QString& handle);
    // Set up the main chat view
    bool               initializeChatView();
    // Set up the contact sidebar
    bool               initializeContactSidebar();
    // Set up the current account
    bool               initializeCurrentAccount();
    // Set up the docking
    bool               initializeDocking();
    // Set up the switchboard connection
    bool               initializeSwitchboardConnection();
    // The application is exiting
    bool               queryExit();
    // The chat window is closing
    bool               queryClose();
    // Save the chat if necessary
    void               saveChatAutomatically();
    // Save the chat to the given file
    void               saveChatToFile(QString path);
    // Start blinking the caption
    void               startBlink();

  private slots: // Private slots
    // Make the caption blink if the window still doesn't have focus
    void               blinkCaption();
    // A contact joined the chat
    void               contactJoined(QString handle, QString friendlyName);
    // A contact left the chat
    void               contactLeft(QString handle);
    // A contact is typing
    void               contactTyping(QString handle, QString friendlyName);
    // The emoticon button was pressed.
    void               emoticonButtonPressed();
    // Invite a contact to the chat
    void               inviteContact(QString handle);
    // Notify the user of an application message.
    void               receivedAppMessage(QString html);
    // Notify the user of a system message.
    void               receivedSystemMessage(QString message);
    // A message was received from a contact.
    void               receivedMessage(QString handle, QString name, QString text, QFont font, QString color, QString nameColor);
    // Save the chat according to the user's request
    void               saveChat();
    // The sidebar is docking
    void               sidebarDocking(KDockWidget *dockWidget, KDockWidget::DockPosition dockPosition);
    // Reset the typing label
    void               stopTyping();

  private: // Private attributes
    // A timer used to make the caption blink on new messages.
    QTimer             blinkTimer_;
    // Whether to blink to upper (true) or lower (false) case
    bool               blinkToUpper_;
    // The stored window caption
    QString            caption_;
    // The chat view widget
    ChatView          *chatView_;
    // The contact actions in the invite menu
    QPtrList<ContactAction> contactActions_;
    // The contact dock widget
    KDockWidget       *contactDockWidget_;
    // The contact list
    ContactList       *contactList_;
    // The contact sidebar, which goes in the dock widget
    ContactSidebar    *contactSidebar_;
    // A pointer to the instance of the current account
    CurrentAccount    *currentAccount_;
    // The first contact who joined the chat
    QString            firstContact_;
    // Whether or not the incoming message is the first incoming message
    bool               firstMessage_;
    // Whether or not the object was initialized
    bool               initialized_;
    // The main dock widget
    KDockWidget       *mainDockWidget_;
    // The object that connects to the switchboard server.
    MsnSwitchboardConnection *msnSwitchboardConnection_;
    // The last docking position of the sidebar
    KDockWidget::DockPosition sidebarDockPosition_;
    // The sidebar heights and widths
    int                sidebarHeight_, sidebarWidth_;
    // The date/time the chat started
    QDate              startDate_;
    QTime              startTime_;
    // A timer to time the duration that the typing label is shown
    QTimer             typingTimer_;

  signals: // Public signals
    // Signal that a new chat has started
    void               newChat(const Contact *contact, QString message, ChatWindow *chatWindow);
};

#endif
