/***************************************************************************
                          autologinview.cpp  -  description
                             -------------------
    begin                : Mon Feb 10 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "autologinview.h"

#include <qcolor.h>
#include <qfont.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kiconloader.h>
#include <klocale.h>

// The constructor
AutologinView::AutologinView(QWidget *parent, const char *name )
 : QWidget(parent,name)
{
  KIconLoader *loader = KGlobal::iconLoader();
  QFont        font;

  setPaletteBackgroundColor( QColor( 85, 170, 255 ) );

  QVBoxLayout *mainLayout = new QVBoxLayout( this, 0, 0, "mainLayout" );

  QLabel *logoPixmapLabel = new QLabel( this, "logoPixmapLabel" );
  logoPixmapLabel->setScaledContents( FALSE );
  logoPixmapLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignHCenter ) );
  logoPixmapLabel->setPixmap( loader->loadIcon( "kmesslogo", KIcon::User ) );
  mainLayout->addWidget( logoPixmapLabel );

  QLabel *connectingLabel = new QLabel( i18n("Logging in..."), this, "connectingLabel" );
  connectingLabel->setAlignment( int( QLabel::AlignHCenter ) );
  font = connectingLabel->font();
  font.setPointSize( 18 );
  font.setBold( true );
  connectingLabel->setFont( font );
  mainLayout->addWidget( connectingLabel );
}



// The destructor
AutologinView::~AutologinView()
{
}

#include "autologinview.moc"
