<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version = '1.0'
    xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" encoding="iso-8859-1"
  doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>

<xsl:param name="lang" select="'fi'"/>
<xsl:param name="output_dir">default</xsl:param>
<xsl:include href="date-routines.xsl"/>

<xsl:variable name="page_main">kipina-report</xsl:variable>
<xsl:variable name="page_stats">log-stats</xsl:variable>
<xsl:variable name="page_list">log-list</xsl:variable>
<xsl:variable name="i18n-strings" select="document ('i18n.xml')"/>

<xsl:key name="d_mon" match="datetime" use="substring(., 1, 7)"/>
<xsl:key name="d_year" match="datetime" use="substring(., 1, 4)"/>


<xsl:template name="check_params">
  <xsl:if test="$output_dir = 'default'">
      <xsl:message terminate="yes">
              How is this possible?
              Param $output_dir is missing!
      </xsl:message>
  </xsl:if>
  
</xsl:template>

<xsl:template match="/">
  <xsl:call-template name="check_params"/>
  
  <xsl:variable name="navi">
    <div class="navi">
      <div class="navi_header">navi</div>
    
      <xsl:call-template name="create-navi"/>
      <xsl:call-template name="create-month-navi"/>
    </div>
  </xsl:variable>

  <html>
  <head>
    <title>List of workouts</title>
    <link rel="stylesheet" type="text/css" href="log.css"/>
  </head>
  <body>

  <!-- Generate year pages -->
  <xsl:for-each select="//workout/datetime[generate-id() = 
                        generate-id(key('d_year', substring(.,1,4)))]">
                        
    <xsl:call-template name="create-year-stats-page">
      <xsl:with-param name="year" select="number(substring(.,1,4))"/>
      <!--<xsl:with-param name="navi" select=""/>-->
    </xsl:call-template>
    
  </xsl:for-each>
 
  <!-- Generate month pages -->
  <xsl:for-each select="//workout/datetime[generate-id() =
                        generate-id(key('d_mon', substring(.,1,7)))]">
                        
    <xsl:variable name="shit" select="key('d_mon', substring(.,1,7))"/>
    <xsl:variable name="month" select="substring(.,6,2)"/>
    <xsl:variable name="year" select="substring(.,1,4)"/>
   
    <xsl:call-template name="create-month-stats-page">
      <xsl:with-param name="month" select="$month"/>
      <xsl:with-param name="year" select="$year"/>
      <xsl:with-param name="navi" select="$navi"/>
    </xsl:call-template>
  </xsl:for-each>


  <table width="100%" class="top_box" cellpadding="0" cellspacing="0" border="0">
  <tr>
    <td>
      <h1 style="letter-spacing: 2px; margin-left: 1em; color: #333333;">
        Kipin
        <xsl:call-template name="gettext">
          <xsl:with-param name="text" select="'report'"/>
        </xsl:call-template>
      </h1>
    </td>
  </tr>
  </table>

  <table width="100%">
  <tr>
    <td valign="top" width="200">
      <xsl:copy-of select="$navi"/>

      <div class="navi">
        <div class="navi_header">Top 5 distance</div>
        <ul>
          <li/>25km
          <li/>18km
          <li/>17km
          <li/>15km
          <li/>15km
        </ul>
      </div>
    </td>
    
    <td valign="top" align="left">
    <p style="margin-top: 1em;">
      <xsl:variable name="str1">
        <xsl:call-template name="gettext">
          <xsl:with-param name="text" select="'There are # workouts in the log'"/>
        </xsl:call-template>
      </xsl:variable>

      <xsl:variable name="str2">
        <xsl:call-template name="gettext">
          <xsl:with-param name="text" select="'Their distance is totally # kilometers'"/>
        </xsl:call-template>
      </xsl:variable>
     
      <xsl:value-of select="format-number (count (//workout), $str1)"/>.
      <xsl:value-of select="format-number (sum(//workout/param[@name='distance']), $str2)"/>.
    </p>
    </td>
    
    <td valign="top" align="right" width="200">
      <div class="navi" align="left">
        <div class="navi_header">Top 5 months</div>
        <ul>
          <li/>Jan 2004
          <li/>Feb 2004
          <li/>Dec 2003
          <li/>Oct 2002 
          <li/>-
         </ul>
      </div>
    </td>
  </tr>
  </table>
  </body>
  </html>
</xsl:template>




<xsl:template name="create-month-navi">
  <ul style="padding-right: 1em;">

  <xsl:for-each select="//workout/datetime[generate-id() =
                        generate-id(key('d_mon', substring(.,1,7)))]">
                        
    <xsl:variable name="shit" select="key('d_mon', substring(.,1,7))"/>
    <xsl:variable name="month" select="substring(.,6,2)"/>
    <xsl:variable name="year" select="substring(.,1,4)"/>
    
    <li/><a href="{$page_stats}-{$year}-{$month}.html">
          <xsl:value-of select="$month"/>
          <xsl:text>/</xsl:text>
          <xsl:value-of select="$year"/>
      </a>

  </xsl:for-each>

  </ul>
</xsl:template>


<xsl:template name="create-navi">
  <ul>
    <li/>
      <a href="{$page_main}.html">
      <xsl:call-template name="gettext">
        <xsl:with-param name="text" select="'main page'"/>
      </xsl:call-template>
      </a>
  </ul>
</xsl:template>




<xsl:template name="create-year-stats-page">
  <xsl:param name="year"/>
  <xsl:param name="navi"/>
 
  <xsl:param name="dir">
    <xsl:value-of select="$output_dir"/>
  </xsl:param>
  
  <xsl:variable name="filename">
    <xsl:value-of select="concat($page_stats,'-',$year,'.html')"/>
  </xsl:variable>

  <xsl:document href="{$dir}/{$filename}" method="html" encoding="iso-8859-1"
                doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN">
  <html>
  <head>
    <link rel="stylesheet" type="text/css" href="log.css"/>
    <title>
      <xsl:call-template name="gettext">
        <xsl:with-param name="text" select="february"/>
      </xsl:call-template>
    </title>
  </head>
  <body>
  <table width="100%" class="top_box" cellpadding="0" cellspacing="0" border="0">
  <tr>
    <td>
      <xsl:copy-of select="$navi"/>
      <h1><xsl:value-of select="$year"/></h1>
    </td>
  </tr>
  </table>
  <br/><br/>

  <!-- Create diagram --> 

<!--  <xsl:call-template name="create-stats-diagram">
    <xsl:with-param name="year" select="$year"/>
    <xsl:with-param name="month" select="$month"/>
    <xsl:with-param name="days" select="12"/>
  </xsl:call-template>-->

  <table class="table_stats" cellspacing="0" cellpading="0" border="2" width="100%" align="center">
  <tr>
    <td valign="top" style="margin:0; padding: 0;">
      <table width="100%" class="table_summary" cellspacing="0" cellpadding="0" border="0">
        <xsl:call-template name="create-workout-list">
          <xsl:with-param name="year" select="$year"/>
        </xsl:call-template>
      </table>
    </td>
  </tr>
  <tr>
    <td valign="top" style="margin: 0; padding: 0;">
      <xsl:call-template name="create-stats-table">
        <xsl:with-param name="year" select="$year"/>
      </xsl:call-template>
    </td>
  </tr>
  </table>
  </body>
  </html>
  </xsl:document>


</xsl:template>




<xsl:template name="create-month-stats-page">
  <xsl:param name="month"/>
  <xsl:param name="year"/>
  <xsl:param name="navi"/>

  <xsl:param name="dir">
    <xsl:value-of select="$output_dir"/>
  </xsl:param>
  
  <xsl:variable name="filename">
    <xsl:value-of select="concat($page_stats,'-',$year,'-',$month,'.html')"/>
  </xsl:variable>

  <xsl:variable name="month-name">
    <xsl:call-template name="date_get_month_name">
      <xsl:with-param name="month" select="number($month)"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:document href="{$dir}/{$filename}" method="html" encoding="iso-8859-1"
                doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN">
  <html>
  <head>
    <link rel="stylesheet" type="text/css" href="log.css"/>
    <title>
      <xsl:call-template name="gettext">
        <xsl:with-param name="text" select="$month-name"/>
      </xsl:call-template>
      <xsl:text> </xsl:text>
      <xsl:value-of select="$year"/>
    </title>
  </head>
  <body>
  <table width="100%" class="top_box" cellpadding="0" cellspacing="0" border="0">
  <tr>
    <td>
      <h1>
        <xsl:call-template name="gettext">
          <xsl:with-param name="text" select="$month-name"/>
        </xsl:call-template>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$year"/>
      </h1>
    </td>
  </tr>
  </table>
  <br/><br/>

  <!-- Create diagram --> 
  <xsl:variable name="days">
    <xsl:call-template name="date_get_month_len">
      <xsl:with-param name="year" select="$year"/>
      <xsl:with-param name="month" select="$month"/>
    </xsl:call-template>
  </xsl:variable>

  <table width="100%" border="0">
  <tr>
    <td valign="top">
      <xsl:copy-of select="$navi"/>
    </td>
    <td valign="top">
      <xsl:call-template name="create-stats-diagram">
        <xsl:with-param name="year" select="$year"/>
        <xsl:with-param name="month" select="$month"/>
        <xsl:with-param name="days" select="$days"/>
      </xsl:call-template>
 
      <table class="table_stats" cellspacing="10" cellpading="0" width="100%" align="center">
      <tr>
        <td valign="top" style="margin: 0; padding: 0;">
          <xsl:call-template name="create-stats-table">
            <xsl:with-param name="month" select="$month"/>
            <xsl:with-param name="year" select="$year"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td valign="top" style="margin:0; padding: 0;">
          <table width="100%" class="table_summary" cellspacing="0" cellpadding="0" border="0">
            <xsl:call-template name="create-workout-list">
              <xsl:with-param name="month" select="$month"/>
              <xsl:with-param name="year" select="$year"/>
            </xsl:call-template>
          </table>
        </td>
      </tr>
      </table>
    </td>
  </tr>
  </table>
  </body>
  </html>
  </xsl:document>
</xsl:template>


  <!-- Template create-stats-table creates statistics -->
  <!-- tables for all types of workout done in this -->
  <!-- particular month. -->
  
<xsl:template name="create-stats-table">
  <xsl:param name="year"/>
  <xsl:param name="month"/>

  <!-- Go through every type of workout in this month -->
  <xsl:for-each select="//workout/@type[not(. = preceding::node()/@type)]">
    <xsl:sort select="."/>
  
    <xsl:variable name="type" select="."/>

    <xsl:variable name="n" select="count(//workout[@type=$type
                                    and substring(datetime,6,2)=$month
                                    and substring(datetime,1,4)=$year])"/>

    <xsl:variable name="distance">
      <xsl:value-of select="sum(//workout/param[@name='distance'
                                    and ../@type=$type
                                    and substring(../datetime,6,2)=$month])"/>
    </xsl:variable>

    <!-- Get max-distance in this month -->
    <xsl:variable name="max">
      <xsl:choose>
        <xsl:when test="count(//workout/param[@name='distance'
                   and ../@type=$type
                   and substring(../datetime,1,7)=concat($year,'-',$month)]) &gt; 0">
                      
          <xsl:for-each select="//workout/param[@name='distance'
                                                and ../@type=$type
                                                and substring(../datetime,6,2)=$month
                                             ]">
            <xsl:sort select="." data-type="number" order="descending"/>
            <xsl:if test="position() = 1">
              <xsl:value-of select="format-number(., '###.0 km')"/>
            </xsl:if>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="percent">
      <xsl:value-of select="format-number (
                            count(//workout/param[@name='distance'
                            and ../@type=$type
                            and substring(../datetime,6,2) = $month
                            and substring(../datetime,1,4) = $year])
                            div $n, '## %')"/>
    </xsl:variable>

    <!-- TODO -->

    <xsl:variable name="duration" select="0"/>
    <xsl:variable name="maxduration" select="0"/>

    <xsl:if test="$n &gt; 0">
      <xsl:call-template name="create-stats-table-html">
        <xsl:with-param name="n" select="$n"/>
        <xsl:with-param name="distance" select="$distance"/>
        <xsl:with-param name="duration" select="$duration"/>
        <xsl:with-param name="maxdistance" select="$max"/>
        <xsl:with-param name="maxduration" select="$maxduration"/>
        <xsl:with-param name="percent" select="$percent"/>
        <xsl:with-param name="type" select="$type"/>
      </xsl:call-template>
    </xsl:if>

<!--    <xsl:if test="$n &gt; 0">
    <table width="100%" class="table_summary" cellspacing="0" cellpadding="0" border="0">
      <tr>
        <td colspan="3" class="table_mid_header">
          <big>
            <xsl:value-of select="$type"/>
          </big>
        </td>
      </tr>
      <tr>
        <td class="sum_table_item">Number of workouts</td>
        <td class="sum_table_item" align="right">
          <b>
            <xsl:value-of select='format-number ($n, "###")'/>
          </b>
        </td>
        <td class="sum_table_item">&#xA0;</td>
      </tr>
      <tr>
        <td class="sum_table_item">Average distance</td>
        <td class="sum_table_item" align="right">
          <xsl:value-of select='format-number($distance div $n, "###.0 km")'/>
        </td>
        <td class="sum_table_item">&#xA0;</td>
      </tr>
      <tr>
        <td class="sum_table_item">Maximum distance</td>
        <td class="sum_table_item" align="right">
          <xsl:value-of select="$max"/>
        </td>
        <td class="sum_table_item"></td>
      </tr>
      <tr>
        <td class="sum_table_item">Total distance</td>
        <td class="sum_table_item" align="right">
          <b>
            <xsl:value-of select="format-number($distance, '###.0 km')"/>
          </b>
        </td>
        <td class="sum_table_item"><xsl:value-of select="$percent"/></td>
      </tr>
    </table>
    </xsl:if>-->
  </xsl:for-each>
</xsl:template>


<xsl:template name="create-stats-table-html">
  <xsl:param name="type"/>
  <xsl:param name="n"/>
  <xsl:param name="distance"/>
  <xsl:param name="duration"/>
  <xsl:param name="maxdistance"/>
  <xsl:param name="maxduration"/>
  <xsl:param name="percent"/>

  <table width="100%" class="table_summary" cellspacing="0" cellpadding="0">
    <tr>
      <td colspan="2" class="table_mid_header">
        <big>
        <xsl:call-template name="gettext">
          <xsl:with-param name="text" select="$type"/>
        </xsl:call-template>
        </big>
      </td>
    </tr>
    <tr>
      <td class="sum_table_item">
        <xsl:call-template name="gettext">
          <xsl:with-param name="text" select="'number of workouts'"/>
        </xsl:call-template>
      </td>
      <td class="sum_table_item" align="right">
        <b><xsl:value-of select='format-number ($n, "###")'/></b>
      </td>
    </tr>
    <tr>
      <td class="sum_table_item">
        <xsl:call-template name="gettext">
          <xsl:with-param name="text" select="'average distance'"/>
        </xsl:call-template>
      </td>
      <td class="sum_table_item" align="right">
        <xsl:value-of select='format-number($distance div $n, "###.0 km")'/>
      </td>
    </tr>
    <tr>
      <td class="sum_table_item">
        <xsl:call-template name="gettext">
          <xsl:with-param name="text" select="'maximum distance'"/>
        </xsl:call-template>
      </td>
      <td class="sum_table_item" align="right"><xsl:value-of select="$maxdistance"/></td>
    </tr>
    <tr>
      <td class="sum_table_item">
        <xsl:call-template name="gettext">
          <xsl:with-param name="text" select="'total distance'"/>
        </xsl:call-template>
      </td>
      <td class="sum_table_item" align="right">
        <b><xsl:value-of select="format-number($distance, '###.0 km')"/></b>
      </td>
    </tr>
  </table>
  <br/>
</xsl:template>



<xsl:template name="find-max">
  <xsl:param name="year"/>
  <xsl:param name="month"/>
  <xsl:param name="param"/>
  
  <xsl:key name="params_year" match="workout" use="
    concat(substring(datetime, 1,7), param[@name], @type)"/>

    <xsl:choose>
      <xsl:when test="count(//workout/param[@name='distance'
                      and ../@type=$type
                      and substring(../datetime,6,2)=$month]) &gt; 0">
                      
        <xsl:for-each select="//workout/param[@name='distance'
                                              and ../@type=$type
                                              and substring(../datetime,6,2)=$month
                                           ]">
          <xsl:sort select="." data-type="number" order="descending"/>
          <xsl:if test="position() = 1">
            <xsl:value-of select="format-number(., '###.0 km')"/>
          </xsl:if>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        0
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<xsl:template name="create-stats-diagram">
  <xsl:param name="month"/>
  <xsl:param name="year"/>
  <xsl:param name="days"/>

  <xsl:variable name="max">
    <xsl:call-template name="get-month-max-distance">
      <xsl:with-param name="month" select="$month"/>
      <xsl:with-param name="year" select="$year"/>
      <xsl:with-param name="day" select="$days"/>
      <xsl:with-param name="max" select="0"/>
    </xsl:call-template>
  </xsl:variable>

  <table border="0" style="margin: 1em">
    <tr>
      <xsl:call-template name="create-diagram-col">
        <xsl:with-param name="month" select="$month"/>
        <xsl:with-param name="year" select="$year"/>
        <xsl:with-param name="days" select="number($days)"/>
        <xsl:with-param name="max" select="$max"/>
        <xsl:with-param name="n" select="1"/>
      </xsl:call-template>
    </tr>
  </table>
</xsl:template>




<xsl:template name="get-month-max-distance">
  <xsl:param name="year"/>
  <xsl:param name="month"/>
  <xsl:param name="day"/>
  <xsl:param name="max"/>

  <xsl:variable name="tmp" select="sum(//workout/param[@name='distance' 
                                       and substring(../datetime,1,4) = $year
                                       and substring(../datetime,6,2) = $month
                                       and substring(../datetime,9,2) = $day])"/>

  <xsl:variable name="m">
    <xsl:choose>
      <xsl:when test="number($tmp) &gt; number($max)">
        <xsl:value-of select="$tmp"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$max"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
 
  <xsl:choose>
    <xsl:when test="number($day) &gt; 0">
      <xsl:call-template name="get-month-max-distance">
        <xsl:with-param name="year" select="$year"/>
        <xsl:with-param name="month" select="$month"/>
        <xsl:with-param name="day" select="number($day)-1"/>
        <xsl:with-param name="max" select="$m"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$m"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>






<xsl:template name="create-diagram-col">
  <xsl:param name="month"/>
  <xsl:param name="year"/>
  <xsl:param name="days"/>
  <xsl:param name="n"/>
  <xsl:param name="max"/>

  <td width="20" valign="bottom" align="center">

    <xsl:variable name="height">
      <xsl:value-of select="number(round((sum(//workout/param[@name='distance'
                                      and substring(../datetime,1,4) = $year
                                      and substring(../datetime,6,2) = $month
                                      and substring(../datetime,9,2) = $n])
                                  div number($max)) * 100))"/>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="$height &gt; 0">
        <img class="tower" src="horiz.png" width="10" height="{$height}"/><br/>
      </xsl:when>
      <xsl:otherwise>
        <img class="tower_zero" src="horiz.png" width="10" height="0"/><br/>
      </xsl:otherwise>
    </xsl:choose>
    <small>
      <xsl:value-of select="$n"/>
    </small>
  </td>

  <xsl:if test="number($n) &lt; number($days)">
    <xsl:call-template name="create-diagram-col">
      <xsl:with-param name="month" select="$month"/>
      <xsl:with-param name="year" select="$year"/>
      <xsl:with-param name="n" select="number($n) + 1"/>
      <xsl:with-param name="days" select="$days"/>
      <xsl:with-param name="max" select="$max"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<!--
 *
 * CREATE LIST OF WORKOUTS
 *
-->
<xsl:template name="create-workout-list">
  <xsl:param name="year"/>
  <xsl:param name="month"/>
  <xsl:param name="sort"/>

  <tr>
    <td class="table_mid_header" colspan="5">
      <big>Workouts</big>
    </td>
  </tr>

  <xsl:if test="number($year) &gt; 0 and string(number($month)) = 'NaN'">
    <xsl:for-each select="//workout[substring(datetime,1,4) = $year]">
      <xsl:sort select="substring(datetime, 6, 2)"/>
      <xsl:sort select="substring(datetime, 9, 2)"/>
      <xsl:call-template name="workout-list-row-print"/>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test="number($year) &gt; 0 and number($month) &gt; 0">
     <xsl:for-each select="//workout[substring(datetime,1,4) = $year
                          and substring(datetime,6,2) = $month]">
      <xsl:sort select="@type"/>
      <xsl:call-template name="workout-list-row-print"/>
    </xsl:for-each>
  </xsl:if>
  
  
<!--  <xsl:choose>
    <xsl:when test="$year &gt; 0 and $month &gt; 0">
       <xsl:for-each select="//workout[substring(date,1,4) = $year
                                   and substring(date,6,2) = $month]">
        <xsl:sort select="@type"/>
        <xsl:call-template name="workout-list-row-print"/>
      </xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
      <xsl:for-each select="//workout">
        <xsl:sort select="@type"/>
        <xsl:call-template name="workout-list-row-print"/>
      </xsl:for-each>
    </xsl:otherwise>
  </xsl:choose>-->
</xsl:template>


<xsl:template name="workout-list-row-print">
<tr>
  <!-- Date -->
  <td class="sum_table_item">
    <b>
      <xsl:value-of select="number(substring(datetime,9,2))"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="number(substring(datetime,6,2))"/>
    </b>
  </td>
 
  <!-- type -->
  <td class="sum_table_item">
    <xsl:value-of select='@type'/>
  </td>
 
  <!-- duration -->
  <td class="sum_table_item">
    <xsl:choose>
      <xsl:when test='string-length (param[@name="duration"]) &gt; 0'>
        <xsl:value-of select='param[@name = "duration"]'/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>&#xA0;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </td>
  <!-- comment -->
  <td class="sum_table_item">
    <i>
    <xsl:choose>
      <xsl:when test='string-length (param[@name = "comment"]) &gt; 15'>
        <xsl:value-of select='substring(param[@name = "comment"], 1, 15)'/>...
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select='param[@name = "comment"]'/>
        &#xA0;
      </xsl:otherwise>
    </xsl:choose>
    </i>
  </td>

  <!-- distance -->
  <td class="sum_table_item" align="right">
    <xsl:choose>
      <xsl:when test='number(param[@name="distance"]) &gt; 0'>
        <xsl:value-of select='format-number(number(param[@name = "distance"]),
                             "###.### km")'/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>&#xA0;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </td>

</tr>
</xsl:template>


<!-- Implement basic translation tool... -->
<xsl:template name="gettext">
  <xsl:param name="text"/>

  <xsl:variable name="string" select="$i18n-strings/strings/string[@text=$text]"/>
  <xsl:choose>
    <xsl:when test="$string[lang($lang)]">
      <xsl:value-of select="$string[lang($lang)][1]"/>
    </xsl:when>
    <xsl:when test="$string">
      <xsl:value-of select="$string[1]"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:message terminate="no">
        Warning: Translated string can't be found for:<xsl:value-of select="$text"/> 
      </xsl:message>
      <xsl:value-of select="$text"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>

