/*
 * System call argument to DTrace register array converstion.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * $FreeBSD$
 * This file is part of the DTrace syscall provider.
 */

static void
systrace_args(int sysnum, void *params, uint64_t *uarg, int *n_args)
{
	int64_t *iarg  = (int64_t *) uarg;
	switch (sysnum) {
#if !defined(PAD64_REQUIRED) && (defined(__powerpc__) || defined(__mips__))
#define PAD64_REQUIRED
#endif
	/* nosys */
	case 0: {
		*n_args = 0;
		break;
	}
	/* sys_exit */
	case 1: {
		struct sys_exit_args *p = params;
		iarg[0] = p->rval; /* int */
		*n_args = 1;
		break;
	}
	/* fork */
	case 2: {
		*n_args = 0;
		break;
	}
	/* read */
	case 3: {
		struct read_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* void * */
		uarg[2] = p->nbyte; /* size_t */
		*n_args = 3;
		break;
	}
	/* write */
	case 4: {
		struct write_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* const void * */
		uarg[2] = p->nbyte; /* size_t */
		*n_args = 3;
		break;
	}
	/* open */
	case 5: {
		struct open_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* int */
		iarg[2] = p->mode; /* int */
		*n_args = 3;
		break;
	}
	/* close */
	case 6: {
		struct close_args *p = params;
		iarg[0] = p->fd; /* int */
		*n_args = 1;
		break;
	}
	/* freebsd32_wait4 */
	case 7: {
		struct freebsd32_wait4_args *p = params;
		iarg[0] = p->pid; /* int */
		uarg[1] = (intptr_t) p->status; /* int * */
		iarg[2] = p->options; /* int */
		uarg[3] = (intptr_t) p->rusage; /* struct rusage32 * */
		*n_args = 4;
		break;
	}
	/* link */
	case 9: {
		struct link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->link; /* char * */
		*n_args = 2;
		break;
	}
	/* unlink */
	case 10: {
		struct unlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* chdir */
	case 12: {
		struct chdir_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* fchdir */
	case 13: {
		struct fchdir_args *p = params;
		iarg[0] = p->fd; /* int */
		*n_args = 1;
		break;
	}
	/* mknod */
	case 14: {
		struct mknod_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* int */
		iarg[2] = p->dev; /* int */
		*n_args = 3;
		break;
	}
	/* chmod */
	case 15: {
		struct chmod_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* int */
		*n_args = 2;
		break;
	}
	/* chown */
	case 16: {
		struct chown_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->uid; /* int */
		iarg[2] = p->gid; /* int */
		*n_args = 3;
		break;
	}
	/* obreak */
	case 17: {
		struct obreak_args *p = params;
		uarg[0] = (intptr_t) p->nsize; /* char * */
		*n_args = 1;
		break;
	}
	/* getpid */
	case 20: {
		*n_args = 0;
		break;
	}
	/* mount */
	case 21: {
		struct mount_args *p = params;
		uarg[0] = (intptr_t) p->type; /* char * */
		uarg[1] = (intptr_t) p->path; /* char * */
		iarg[2] = p->flags; /* int */
		uarg[3] = (intptr_t) p->data; /* caddr_t */
		*n_args = 4;
		break;
	}
	/* unmount */
	case 22: {
		struct unmount_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* setuid */
	case 23: {
		struct setuid_args *p = params;
		uarg[0] = p->uid; /* uid_t */
		*n_args = 1;
		break;
	}
	/* getuid */
	case 24: {
		*n_args = 0;
		break;
	}
	/* geteuid */
	case 25: {
		*n_args = 0;
		break;
	}
	/* ptrace */
	case 26: {
		struct ptrace_args *p = params;
		iarg[0] = p->req; /* int */
		iarg[1] = p->pid; /* pid_t */
		uarg[2] = (intptr_t) p->addr; /* caddr_t */
		iarg[3] = p->data; /* int */
		*n_args = 4;
		break;
	}
	/* freebsd32_recvmsg */
	case 27: {
		struct freebsd32_recvmsg_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->msg; /* struct msghdr32 * */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* freebsd32_sendmsg */
	case 28: {
		struct freebsd32_sendmsg_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->msg; /* struct msghdr32 * */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* freebsd32_recvfrom */
	case 29: {
		struct freebsd32_recvfrom_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = p->buf; /* u_int32_t */
		uarg[2] = p->len; /* u_int32_t */
		iarg[3] = p->flags; /* int */
		uarg[4] = p->from; /* u_int32_t */
		uarg[5] = p->fromlenaddr; /* u_int32_t */
		*n_args = 6;
		break;
	}
	/* accept */
	case 30: {
		struct accept_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->name; /* caddr_t */
		uarg[2] = (intptr_t) p->anamelen; /* int * */
		*n_args = 3;
		break;
	}
	/* getpeername */
	case 31: {
		struct getpeername_args *p = params;
		iarg[0] = p->fdes; /* int */
		uarg[1] = (intptr_t) p->asa; /* caddr_t */
		uarg[2] = (intptr_t) p->alen; /* int * */
		*n_args = 3;
		break;
	}
	/* getsockname */
	case 32: {
		struct getsockname_args *p = params;
		iarg[0] = p->fdes; /* int */
		uarg[1] = (intptr_t) p->asa; /* caddr_t */
		uarg[2] = (intptr_t) p->alen; /* int * */
		*n_args = 3;
		break;
	}
	/* access */
	case 33: {
		struct access_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->amode; /* int */
		*n_args = 2;
		break;
	}
	/* chflags */
	case 34: {
		struct chflags_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* fchflags */
	case 35: {
		struct fchflags_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* sync */
	case 36: {
		*n_args = 0;
		break;
	}
	/* kill */
	case 37: {
		struct kill_args *p = params;
		iarg[0] = p->pid; /* int */
		iarg[1] = p->signum; /* int */
		*n_args = 2;
		break;
	}
	/* getppid */
	case 39: {
		*n_args = 0;
		break;
	}
	/* dup */
	case 41: {
		struct dup_args *p = params;
		uarg[0] = p->fd; /* u_int */
		*n_args = 1;
		break;
	}
	/* pipe */
	case 42: {
		*n_args = 0;
		break;
	}
	/* getegid */
	case 43: {
		*n_args = 0;
		break;
	}
	/* profil */
	case 44: {
		struct profil_args *p = params;
		uarg[0] = (intptr_t) p->samples; /* caddr_t */
		uarg[1] = p->size; /* size_t */
		uarg[2] = p->offset; /* size_t */
		uarg[3] = p->scale; /* u_int */
		*n_args = 4;
		break;
	}
	/* ktrace */
	case 45: {
		struct ktrace_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* const char * */
		iarg[1] = p->ops; /* int */
		iarg[2] = p->facs; /* int */
		iarg[3] = p->pid; /* int */
		*n_args = 4;
		break;
	}
	/* getgid */
	case 47: {
		*n_args = 0;
		break;
	}
	/* getlogin */
	case 49: {
		struct getlogin_args *p = params;
		uarg[0] = (intptr_t) p->namebuf; /* char * */
		uarg[1] = p->namelen; /* u_int */
		*n_args = 2;
		break;
	}
	/* setlogin */
	case 50: {
		struct setlogin_args *p = params;
		uarg[0] = (intptr_t) p->namebuf; /* char * */
		*n_args = 1;
		break;
	}
	/* acct */
	case 51: {
		struct acct_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* freebsd32_sigaltstack */
	case 53: {
		struct freebsd32_sigaltstack_args *p = params;
		uarg[0] = (intptr_t) p->ss; /* struct sigaltstack32 * */
		uarg[1] = (intptr_t) p->oss; /* struct sigaltstack32 * */
		*n_args = 2;
		break;
	}
	/* freebsd32_ioctl */
	case 54: {
		struct freebsd32_ioctl_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = p->com; /* uint32_t */
		uarg[2] = (intptr_t) p->data; /* struct md_ioctl32 * */
		*n_args = 3;
		break;
	}
	/* reboot */
	case 55: {
		struct reboot_args *p = params;
		iarg[0] = p->opt; /* int */
		*n_args = 1;
		break;
	}
	/* revoke */
	case 56: {
		struct revoke_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* symlink */
	case 57: {
		struct symlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->link; /* char * */
		*n_args = 2;
		break;
	}
	/* readlink */
	case 58: {
		struct readlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->buf; /* char * */
		uarg[2] = p->count; /* size_t */
		*n_args = 3;
		break;
	}
	/* freebsd32_execve */
	case 59: {
		struct freebsd32_execve_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* char * */
		uarg[1] = (intptr_t) p->argv; /* u_int32_t * */
		uarg[2] = (intptr_t) p->envv; /* u_int32_t * */
		*n_args = 3;
		break;
	}
	/* umask */
	case 60: {
		struct umask_args *p = params;
		iarg[0] = p->newmask; /* int */
		*n_args = 1;
		break;
	}
	/* chroot */
	case 61: {
		struct chroot_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* msync */
	case 65: {
		struct msync_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* vfork */
	case 66: {
		*n_args = 0;
		break;
	}
	/* sbrk */
	case 69: {
		struct sbrk_args *p = params;
		iarg[0] = p->incr; /* int */
		*n_args = 1;
		break;
	}
	/* sstk */
	case 70: {
		struct sstk_args *p = params;
		iarg[0] = p->incr; /* int */
		*n_args = 1;
		break;
	}
	/* ovadvise */
	case 72: {
		struct ovadvise_args *p = params;
		iarg[0] = p->anom; /* int */
		*n_args = 1;
		break;
	}
	/* munmap */
	case 73: {
		struct munmap_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* freebsd32_mprotect */
	case 74: {
		struct freebsd32_mprotect_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->prot; /* int */
		*n_args = 3;
		break;
	}
	/* madvise */
	case 75: {
		struct madvise_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->behav; /* int */
		*n_args = 3;
		break;
	}
	/* mincore */
	case 78: {
		struct mincore_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		uarg[2] = (intptr_t) p->vec; /* char * */
		*n_args = 3;
		break;
	}
	/* getgroups */
	case 79: {
		struct getgroups_args *p = params;
		uarg[0] = p->gidsetsize; /* u_int */
		uarg[1] = (intptr_t) p->gidset; /* gid_t * */
		*n_args = 2;
		break;
	}
	/* setgroups */
	case 80: {
		struct setgroups_args *p = params;
		uarg[0] = p->gidsetsize; /* u_int */
		uarg[1] = (intptr_t) p->gidset; /* gid_t * */
		*n_args = 2;
		break;
	}
	/* getpgrp */
	case 81: {
		*n_args = 0;
		break;
	}
	/* setpgid */
	case 82: {
		struct setpgid_args *p = params;
		iarg[0] = p->pid; /* int */
		iarg[1] = p->pgid; /* int */
		*n_args = 2;
		break;
	}
	/* freebsd32_setitimer */
	case 83: {
		struct freebsd32_setitimer_args *p = params;
		uarg[0] = p->which; /* u_int */
		uarg[1] = (intptr_t) p->itv; /* struct itimerval32 * */
		uarg[2] = (intptr_t) p->oitv; /* struct itimerval32 * */
		*n_args = 3;
		break;
	}
	/* swapon */
	case 85: {
		struct swapon_args *p = params;
		uarg[0] = (intptr_t) p->name; /* char * */
		*n_args = 1;
		break;
	}
	/* freebsd32_getitimer */
	case 86: {
		struct freebsd32_getitimer_args *p = params;
		uarg[0] = p->which; /* u_int */
		uarg[1] = (intptr_t) p->itv; /* struct itimerval32 * */
		*n_args = 2;
		break;
	}
	/* getdtablesize */
	case 89: {
		*n_args = 0;
		break;
	}
	/* dup2 */
	case 90: {
		struct dup2_args *p = params;
		uarg[0] = p->from; /* u_int */
		uarg[1] = p->to; /* u_int */
		*n_args = 2;
		break;
	}
	/* fcntl */
	case 92: {
		struct fcntl_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->cmd; /* int */
		iarg[2] = p->arg; /* long */
		*n_args = 3;
		break;
	}
	/* freebsd32_select */
	case 93: {
		struct freebsd32_select_args *p = params;
		iarg[0] = p->nd; /* int */
		uarg[1] = (intptr_t) p->in; /* fd_set * */
		uarg[2] = (intptr_t) p->ou; /* fd_set * */
		uarg[3] = (intptr_t) p->ex; /* fd_set * */
		uarg[4] = (intptr_t) p->tv; /* struct timeval32 * */
		*n_args = 5;
		break;
	}
	/* fsync */
	case 95: {
		struct fsync_args *p = params;
		iarg[0] = p->fd; /* int */
		*n_args = 1;
		break;
	}
	/* setpriority */
	case 96: {
		struct setpriority_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->who; /* int */
		iarg[2] = p->prio; /* int */
		*n_args = 3;
		break;
	}
	/* socket */
	case 97: {
		struct socket_args *p = params;
		iarg[0] = p->domain; /* int */
		iarg[1] = p->type; /* int */
		iarg[2] = p->protocol; /* int */
		*n_args = 3;
		break;
	}
	/* connect */
	case 98: {
		struct connect_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->name; /* caddr_t */
		iarg[2] = p->namelen; /* int */
		*n_args = 3;
		break;
	}
	/* getpriority */
	case 100: {
		struct getpriority_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->who; /* int */
		*n_args = 2;
		break;
	}
	/* bind */
	case 104: {
		struct bind_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->name; /* caddr_t */
		iarg[2] = p->namelen; /* int */
		*n_args = 3;
		break;
	}
	/* setsockopt */
	case 105: {
		struct setsockopt_args *p = params;
		iarg[0] = p->s; /* int */
		iarg[1] = p->level; /* int */
		iarg[2] = p->name; /* int */
		uarg[3] = (intptr_t) p->val; /* caddr_t */
		iarg[4] = p->valsize; /* int */
		*n_args = 5;
		break;
	}
	/* listen */
	case 106: {
		struct listen_args *p = params;
		iarg[0] = p->s; /* int */
		iarg[1] = p->backlog; /* int */
		*n_args = 2;
		break;
	}
	/* freebsd32_gettimeofday */
	case 116: {
		struct freebsd32_gettimeofday_args *p = params;
		uarg[0] = (intptr_t) p->tp; /* struct timeval32 * */
		uarg[1] = (intptr_t) p->tzp; /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* freebsd32_getrusage */
	case 117: {
		struct freebsd32_getrusage_args *p = params;
		iarg[0] = p->who; /* int */
		uarg[1] = (intptr_t) p->rusage; /* struct rusage32 * */
		*n_args = 2;
		break;
	}
	/* getsockopt */
	case 118: {
		struct getsockopt_args *p = params;
		iarg[0] = p->s; /* int */
		iarg[1] = p->level; /* int */
		iarg[2] = p->name; /* int */
		uarg[3] = (intptr_t) p->val; /* caddr_t */
		uarg[4] = (intptr_t) p->avalsize; /* int * */
		*n_args = 5;
		break;
	}
	/* freebsd32_readv */
	case 120: {
		struct freebsd32_readv_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->iovp; /* struct iovec32 * */
		uarg[2] = p->iovcnt; /* u_int */
		*n_args = 3;
		break;
	}
	/* freebsd32_writev */
	case 121: {
		struct freebsd32_writev_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->iovp; /* struct iovec32 * */
		uarg[2] = p->iovcnt; /* u_int */
		*n_args = 3;
		break;
	}
	/* freebsd32_settimeofday */
	case 122: {
		struct freebsd32_settimeofday_args *p = params;
		uarg[0] = (intptr_t) p->tv; /* struct timeval32 * */
		uarg[1] = (intptr_t) p->tzp; /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* fchown */
	case 123: {
		struct fchown_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->uid; /* int */
		iarg[2] = p->gid; /* int */
		*n_args = 3;
		break;
	}
	/* fchmod */
	case 124: {
		struct fchmod_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->mode; /* int */
		*n_args = 2;
		break;
	}
	/* setreuid */
	case 126: {
		struct setreuid_args *p = params;
		iarg[0] = p->ruid; /* int */
		iarg[1] = p->euid; /* int */
		*n_args = 2;
		break;
	}
	/* setregid */
	case 127: {
		struct setregid_args *p = params;
		iarg[0] = p->rgid; /* int */
		iarg[1] = p->egid; /* int */
		*n_args = 2;
		break;
	}
	/* rename */
	case 128: {
		struct rename_args *p = params;
		uarg[0] = (intptr_t) p->from; /* char * */
		uarg[1] = (intptr_t) p->to; /* char * */
		*n_args = 2;
		break;
	}
	/* flock */
	case 131: {
		struct flock_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->how; /* int */
		*n_args = 2;
		break;
	}
	/* mkfifo */
	case 132: {
		struct mkfifo_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* int */
		*n_args = 2;
		break;
	}
	/* sendto */
	case 133: {
		struct sendto_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->buf; /* caddr_t */
		uarg[2] = p->len; /* size_t */
		iarg[3] = p->flags; /* int */
		uarg[4] = (intptr_t) p->to; /* caddr_t */
		iarg[5] = p->tolen; /* int */
		*n_args = 6;
		break;
	}
	/* shutdown */
	case 134: {
		struct shutdown_args *p = params;
		iarg[0] = p->s; /* int */
		iarg[1] = p->how; /* int */
		*n_args = 2;
		break;
	}
	/* socketpair */
	case 135: {
		struct socketpair_args *p = params;
		iarg[0] = p->domain; /* int */
		iarg[1] = p->type; /* int */
		iarg[2] = p->protocol; /* int */
		uarg[3] = (intptr_t) p->rsv; /* int * */
		*n_args = 4;
		break;
	}
	/* mkdir */
	case 136: {
		struct mkdir_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* int */
		*n_args = 2;
		break;
	}
	/* rmdir */
	case 137: {
		struct rmdir_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* freebsd32_utimes */
	case 138: {
		struct freebsd32_utimes_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->tptr; /* struct timeval32 * */
		*n_args = 2;
		break;
	}
	/* freebsd32_adjtime */
	case 140: {
		struct freebsd32_adjtime_args *p = params;
		uarg[0] = (intptr_t) p->delta; /* struct timeval32 * */
		uarg[1] = (intptr_t) p->olddelta; /* struct timeval32 * */
		*n_args = 2;
		break;
	}
	/* setsid */
	case 147: {
		*n_args = 0;
		break;
	}
	/* quotactl */
	case 148: {
		struct quotactl_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->cmd; /* int */
		iarg[2] = p->uid; /* int */
		uarg[3] = (intptr_t) p->arg; /* caddr_t */
		*n_args = 4;
		break;
	}
	/* getfh */
	case 161: {
		struct getfh_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* char * */
		uarg[1] = (intptr_t) p->fhp; /* struct fhandle * */
		*n_args = 2;
		break;
	}
	/* freebsd32_sysarch */
	case 165: {
		struct freebsd32_sysarch_args *p = params;
		iarg[0] = p->op; /* int */
		uarg[1] = (intptr_t) p->parms; /* char * */
		*n_args = 2;
		break;
	}
	/* rtprio */
	case 166: {
		struct rtprio_args *p = params;
		iarg[0] = p->function; /* int */
		iarg[1] = p->pid; /* pid_t */
		uarg[2] = (intptr_t) p->rtp; /* struct rtprio * */
		*n_args = 3;
		break;
	}
	/* freebsd32_semsys */
	case 169: {
		struct freebsd32_semsys_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->a2; /* int */
		iarg[2] = p->a3; /* int */
		iarg[3] = p->a4; /* int */
		iarg[4] = p->a5; /* int */
		*n_args = 5;
		break;
	}
	/* freebsd32_msgsys */
	case 170: {
		struct freebsd32_msgsys_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->a2; /* int */
		iarg[2] = p->a3; /* int */
		iarg[3] = p->a4; /* int */
		iarg[4] = p->a5; /* int */
		iarg[5] = p->a6; /* int */
		*n_args = 6;
		break;
	}
	/* freebsd32_shmsys */
	case 171: {
		struct freebsd32_shmsys_args *p = params;
		uarg[0] = p->which; /* uint32_t */
		uarg[1] = p->a2; /* uint32_t */
		uarg[2] = p->a3; /* uint32_t */
		uarg[3] = p->a4; /* uint32_t */
		*n_args = 4;
		break;
	}
	/* ntp_adjtime */
	case 176: {
		struct ntp_adjtime_args *p = params;
		uarg[0] = (intptr_t) p->tp; /* struct timex * */
		*n_args = 1;
		break;
	}
	/* setgid */
	case 181: {
		struct setgid_args *p = params;
		iarg[0] = p->gid; /* gid_t */
		*n_args = 1;
		break;
	}
	/* setegid */
	case 182: {
		struct setegid_args *p = params;
		iarg[0] = p->egid; /* gid_t */
		*n_args = 1;
		break;
	}
	/* seteuid */
	case 183: {
		struct seteuid_args *p = params;
		uarg[0] = p->euid; /* uid_t */
		*n_args = 1;
		break;
	}
	/* freebsd32_stat */
	case 188: {
		struct freebsd32_stat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->ub; /* struct stat32 * */
		*n_args = 2;
		break;
	}
	/* freebsd32_fstat */
	case 189: {
		struct freebsd32_fstat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->ub; /* struct stat32 * */
		*n_args = 2;
		break;
	}
	/* freebsd32_lstat */
	case 190: {
		struct freebsd32_lstat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->ub; /* struct stat32 * */
		*n_args = 2;
		break;
	}
	/* pathconf */
	case 191: {
		struct pathconf_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->name; /* int */
		*n_args = 2;
		break;
	}
	/* fpathconf */
	case 192: {
		struct fpathconf_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->name; /* int */
		*n_args = 2;
		break;
	}
	/* getrlimit */
	case 194: {
		struct __getrlimit_args *p = params;
		uarg[0] = p->which; /* u_int */
		uarg[1] = (intptr_t) p->rlp; /* struct rlimit * */
		*n_args = 2;
		break;
	}
	/* setrlimit */
	case 195: {
		struct __setrlimit_args *p = params;
		uarg[0] = p->which; /* u_int */
		uarg[1] = (intptr_t) p->rlp; /* struct rlimit * */
		*n_args = 2;
		break;
	}
	/* freebsd32_getdirentries */
	case 196: {
		struct freebsd32_getdirentries_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* char * */
		uarg[2] = p->count; /* u_int */
		uarg[3] = (intptr_t) p->basep; /* int32_t * */
		*n_args = 4;
		break;
	}
	/* nosys */
	case 198: {
		*n_args = 0;
		break;
	}
	/* freebsd32_sysctl */
	case 202: {
		struct freebsd32_sysctl_args *p = params;
		uarg[0] = (intptr_t) p->name; /* int * */
		uarg[1] = p->namelen; /* u_int */
		uarg[2] = (intptr_t) p->old; /* void * */
		uarg[3] = (intptr_t) p->oldlenp; /* u_int32_t * */
		uarg[4] = (intptr_t) p->new; /* void * */
		uarg[5] = p->newlen; /* u_int32_t */
		*n_args = 6;
		break;
	}
	/* mlock */
	case 203: {
		struct mlock_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* munlock */
	case 204: {
		struct munlock_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* undelete */
	case 205: {
		struct undelete_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* freebsd32_futimes */
	case 206: {
		struct freebsd32_futimes_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->tptr; /* struct timeval32 * */
		*n_args = 2;
		break;
	}
	/* getpgid */
	case 207: {
		struct getpgid_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		*n_args = 1;
		break;
	}
	/* poll */
	case 209: {
		struct poll_args *p = params;
		uarg[0] = (intptr_t) p->fds; /* struct pollfd * */
		uarg[1] = p->nfds; /* u_int */
		iarg[2] = p->timeout; /* int */
		*n_args = 3;
		break;
	}
	/* lkmnosys */
	case 210: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 211: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 212: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 213: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 214: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 215: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 216: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 217: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 218: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 219: {
		*n_args = 0;
		break;
	}
	/* semget */
	case 221: {
		struct semget_args *p = params;
		iarg[0] = p->key; /* key_t */
		iarg[1] = p->nsems; /* int */
		iarg[2] = p->semflg; /* int */
		*n_args = 3;
		break;
	}
	/* semop */
	case 222: {
		struct semop_args *p = params;
		iarg[0] = p->semid; /* int */
		uarg[1] = (intptr_t) p->sops; /* struct sembuf * */
		uarg[2] = p->nsops; /* u_int */
		*n_args = 3;
		break;
	}
	/* msgget */
	case 225: {
		struct msgget_args *p = params;
		iarg[0] = p->key; /* key_t */
		iarg[1] = p->msgflg; /* int */
		*n_args = 2;
		break;
	}
	/* freebsd32_msgsnd */
	case 226: {
		struct freebsd32_msgsnd_args *p = params;
		iarg[0] = p->msqid; /* int */
		uarg[1] = (intptr_t) p->msgp; /* void * */
		uarg[2] = p->msgsz; /* size_t */
		iarg[3] = p->msgflg; /* int */
		*n_args = 4;
		break;
	}
	/* freebsd32_msgrcv */
	case 227: {
		struct freebsd32_msgrcv_args *p = params;
		iarg[0] = p->msqid; /* int */
		uarg[1] = (intptr_t) p->msgp; /* void * */
		uarg[2] = p->msgsz; /* size_t */
		iarg[3] = p->msgtyp; /* long */
		iarg[4] = p->msgflg; /* int */
		*n_args = 5;
		break;
	}
	/* shmat */
	case 228: {
		struct shmat_args *p = params;
		iarg[0] = p->shmid; /* int */
		uarg[1] = (intptr_t) p->shmaddr; /* void * */
		iarg[2] = p->shmflg; /* int */
		*n_args = 3;
		break;
	}
	/* shmdt */
	case 230: {
		struct shmdt_args *p = params;
		uarg[0] = (intptr_t) p->shmaddr; /* void * */
		*n_args = 1;
		break;
	}
	/* shmget */
	case 231: {
		struct shmget_args *p = params;
		iarg[0] = p->key; /* key_t */
		iarg[1] = p->size; /* int */
		iarg[2] = p->shmflg; /* int */
		*n_args = 3;
		break;
	}
	/* freebsd32_clock_gettime */
	case 232: {
		struct freebsd32_clock_gettime_args *p = params;
		iarg[0] = p->clock_id; /* clockid_t */
		uarg[1] = (intptr_t) p->tp; /* struct timespec32 * */
		*n_args = 2;
		break;
	}
	/* freebsd32_clock_settime */
	case 233: {
		struct freebsd32_clock_settime_args *p = params;
		iarg[0] = p->clock_id; /* clockid_t */
		uarg[1] = (intptr_t) p->tp; /* const struct timespec32 * */
		*n_args = 2;
		break;
	}
	/* freebsd32_clock_getres */
	case 234: {
		struct freebsd32_clock_getres_args *p = params;
		iarg[0] = p->clock_id; /* clockid_t */
		uarg[1] = (intptr_t) p->tp; /* struct timespec32 * */
		*n_args = 2;
		break;
	}
	/* freebsd32_nanosleep */
	case 240: {
		struct freebsd32_nanosleep_args *p = params;
		uarg[0] = (intptr_t) p->rqtp; /* const struct timespec32 * */
		uarg[1] = (intptr_t) p->rmtp; /* struct timespec32 * */
		*n_args = 2;
		break;
	}
	/* ffclock_getcounter */
	case 241: {
		struct ffclock_getcounter_args *p = params;
		uarg[0] = (intptr_t) p->ffcount; /* ffcounter * */
		*n_args = 1;
		break;
	}
	/* ffclock_setestimate */
	case 242: {
		struct ffclock_setestimate_args *p = params;
		uarg[0] = (intptr_t) p->cest; /* struct ffclock_estimate * */
		*n_args = 1;
		break;
	}
	/* ffclock_getestimate */
	case 243: {
		struct ffclock_getestimate_args *p = params;
		uarg[0] = (intptr_t) p->cest; /* struct ffclock_estimate * */
		*n_args = 1;
		break;
	}
	/* minherit */
	case 250: {
		struct minherit_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->inherit; /* int */
		*n_args = 3;
		break;
	}
	/* rfork */
	case 251: {
		struct rfork_args *p = params;
		iarg[0] = p->flags; /* int */
		*n_args = 1;
		break;
	}
	/* openbsd_poll */
	case 252: {
		struct openbsd_poll_args *p = params;
		uarg[0] = (intptr_t) p->fds; /* struct pollfd * */
		uarg[1] = p->nfds; /* u_int */
		iarg[2] = p->timeout; /* int */
		*n_args = 3;
		break;
	}
	/* issetugid */
	case 253: {
		*n_args = 0;
		break;
	}
	/* lchown */
	case 254: {
		struct lchown_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->uid; /* int */
		iarg[2] = p->gid; /* int */
		*n_args = 3;
		break;
	}
	/* freebsd32_aio_read */
	case 255: {
		struct freebsd32_aio_read_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb32 * */
		*n_args = 1;
		break;
	}
	/* freebsd32_aio_write */
	case 256: {
		struct freebsd32_aio_write_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb32 * */
		*n_args = 1;
		break;
	}
	/* freebsd32_lio_listio */
	case 257: {
		struct freebsd32_lio_listio_args *p = params;
		iarg[0] = p->mode; /* int */
		uarg[1] = (intptr_t) p->acb_list; /* struct aiocb32 *const * */
		iarg[2] = p->nent; /* int */
		uarg[3] = (intptr_t) p->sig; /* struct sigevent * */
		*n_args = 4;
		break;
	}
	/* getdents */
	case 272: {
		struct getdents_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* char * */
		uarg[2] = p->count; /* size_t */
		*n_args = 3;
		break;
	}
	/* lchmod */
	case 274: {
		struct lchmod_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* mode_t */
		*n_args = 2;
		break;
	}
	/* lchown */
	case 275: {
		struct lchown_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = p->uid; /* uid_t */
		iarg[2] = p->gid; /* gid_t */
		*n_args = 3;
		break;
	}
	/* freebsd32_lutimes */
	case 276: {
		struct freebsd32_lutimes_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->tptr; /* struct timeval32 * */
		*n_args = 2;
		break;
	}
	/* msync */
	case 277: {
		struct msync_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* nstat */
	case 278: {
		struct nstat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->ub; /* struct nstat * */
		*n_args = 2;
		break;
	}
	/* nfstat */
	case 279: {
		struct nfstat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->sb; /* struct nstat * */
		*n_args = 2;
		break;
	}
	/* nlstat */
	case 280: {
		struct nlstat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->ub; /* struct nstat * */
		*n_args = 2;
		break;
	}
	/* freebsd32_preadv */
	case 289: {
		struct freebsd32_preadv_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->iovp; /* struct iovec32 * */
		uarg[2] = p->iovcnt; /* u_int */
		uarg[3] = p->offset1; /* u_int32_t */
		uarg[4] = p->offset2; /* u_int32_t */
		*n_args = 5;
		break;
	}
	/* freebsd32_pwritev */
	case 290: {
		struct freebsd32_pwritev_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->iovp; /* struct iovec32 * */
		uarg[2] = p->iovcnt; /* u_int */
		uarg[3] = p->offset1; /* u_int32_t */
		uarg[4] = p->offset2; /* u_int32_t */
		*n_args = 5;
		break;
	}
	/* fhopen */
	case 298: {
		struct fhopen_args *p = params;
		uarg[0] = (intptr_t) p->u_fhp; /* const struct fhandle * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* fhstat */
	case 299: {
		struct fhstat_args *p = params;
		uarg[0] = (intptr_t) p->u_fhp; /* const struct fhandle * */
		uarg[1] = (intptr_t) p->sb; /* struct stat * */
		*n_args = 2;
		break;
	}
	/* modnext */
	case 300: {
		struct modnext_args *p = params;
		iarg[0] = p->modid; /* int */
		*n_args = 1;
		break;
	}
	/* freebsd32_modstat */
	case 301: {
		struct freebsd32_modstat_args *p = params;
		iarg[0] = p->modid; /* int */
		uarg[1] = (intptr_t) p->stat; /* struct module_stat32 * */
		*n_args = 2;
		break;
	}
	/* modfnext */
	case 302: {
		struct modfnext_args *p = params;
		iarg[0] = p->modid; /* int */
		*n_args = 1;
		break;
	}
	/* modfind */
	case 303: {
		struct modfind_args *p = params;
		uarg[0] = (intptr_t) p->name; /* const char * */
		*n_args = 1;
		break;
	}
	/* kldload */
	case 304: {
		struct kldload_args *p = params;
		uarg[0] = (intptr_t) p->file; /* const char * */
		*n_args = 1;
		break;
	}
	/* kldunload */
	case 305: {
		struct kldunload_args *p = params;
		iarg[0] = p->fileid; /* int */
		*n_args = 1;
		break;
	}
	/* kldfind */
	case 306: {
		struct kldfind_args *p = params;
		uarg[0] = (intptr_t) p->file; /* const char * */
		*n_args = 1;
		break;
	}
	/* kldnext */
	case 307: {
		struct kldnext_args *p = params;
		iarg[0] = p->fileid; /* int */
		*n_args = 1;
		break;
	}
	/* freebsd32_kldstat */
	case 308: {
		struct freebsd32_kldstat_args *p = params;
		iarg[0] = p->fileid; /* int */
		uarg[1] = (intptr_t) p->stat; /* struct kld32_file_stat * */
		*n_args = 2;
		break;
	}
	/* kldfirstmod */
	case 309: {
		struct kldfirstmod_args *p = params;
		iarg[0] = p->fileid; /* int */
		*n_args = 1;
		break;
	}
	/* getsid */
	case 310: {
		struct getsid_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		*n_args = 1;
		break;
	}
	/* setresuid */
	case 311: {
		struct setresuid_args *p = params;
		uarg[0] = p->ruid; /* uid_t */
		uarg[1] = p->euid; /* uid_t */
		uarg[2] = p->suid; /* uid_t */
		*n_args = 3;
		break;
	}
	/* setresgid */
	case 312: {
		struct setresgid_args *p = params;
		iarg[0] = p->rgid; /* gid_t */
		iarg[1] = p->egid; /* gid_t */
		iarg[2] = p->sgid; /* gid_t */
		*n_args = 3;
		break;
	}
	/* freebsd32_aio_return */
	case 314: {
		struct freebsd32_aio_return_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb32 * */
		*n_args = 1;
		break;
	}
	/* freebsd32_aio_suspend */
	case 315: {
		struct freebsd32_aio_suspend_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb32 *const * */
		iarg[1] = p->nent; /* int */
		uarg[2] = (intptr_t) p->timeout; /* const struct timespec32 * */
		*n_args = 3;
		break;
	}
	/* freebsd32_aio_cancel */
	case 316: {
		struct freebsd32_aio_cancel_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->aiocbp; /* struct aiocb32 * */
		*n_args = 2;
		break;
	}
	/* freebsd32_aio_error */
	case 317: {
		struct freebsd32_aio_error_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb32 * */
		*n_args = 1;
		break;
	}
	/* freebsd32_oaio_read */
	case 318: {
		struct freebsd32_oaio_read_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct oaiocb32 * */
		*n_args = 1;
		break;
	}
	/* freebsd32_oaio_write */
	case 319: {
		struct freebsd32_oaio_write_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct oaiocb32 * */
		*n_args = 1;
		break;
	}
	/* freebsd32_olio_listio */
	case 320: {
		struct freebsd32_olio_listio_args *p = params;
		iarg[0] = p->mode; /* int */
		uarg[1] = (intptr_t) p->acb_list; /* struct oaiocb32 *const * */
		iarg[2] = p->nent; /* int */
		uarg[3] = (intptr_t) p->sig; /* struct osigevent32 * */
		*n_args = 4;
		break;
	}
	/* yield */
	case 321: {
		*n_args = 0;
		break;
	}
	/* mlockall */
	case 324: {
		struct mlockall_args *p = params;
		iarg[0] = p->how; /* int */
		*n_args = 1;
		break;
	}
	/* munlockall */
	case 325: {
		*n_args = 0;
		break;
	}
	/* __getcwd */
	case 326: {
		struct __getcwd_args *p = params;
		uarg[0] = (intptr_t) p->buf; /* u_char * */
		uarg[1] = p->buflen; /* u_int */
		*n_args = 2;
		break;
	}
	/* sched_setparam */
	case 327: {
		struct sched_setparam_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		uarg[1] = (intptr_t) p->param; /* const struct sched_param * */
		*n_args = 2;
		break;
	}
	/* sched_getparam */
	case 328: {
		struct sched_getparam_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		uarg[1] = (intptr_t) p->param; /* struct sched_param * */
		*n_args = 2;
		break;
	}
	/* sched_setscheduler */
	case 329: {
		struct sched_setscheduler_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		iarg[1] = p->policy; /* int */
		uarg[2] = (intptr_t) p->param; /* const struct sched_param * */
		*n_args = 3;
		break;
	}
	/* sched_getscheduler */
	case 330: {
		struct sched_getscheduler_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		*n_args = 1;
		break;
	}
	/* sched_yield */
	case 331: {
		*n_args = 0;
		break;
	}
	/* sched_get_priority_max */
	case 332: {
		struct sched_get_priority_max_args *p = params;
		iarg[0] = p->policy; /* int */
		*n_args = 1;
		break;
	}
	/* sched_get_priority_min */
	case 333: {
		struct sched_get_priority_min_args *p = params;
		iarg[0] = p->policy; /* int */
		*n_args = 1;
		break;
	}
	/* sched_rr_get_interval */
	case 334: {
		struct sched_rr_get_interval_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		uarg[1] = (intptr_t) p->interval; /* struct timespec * */
		*n_args = 2;
		break;
	}
	/* utrace */
	case 335: {
		struct utrace_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* kldsym */
	case 337: {
		struct kldsym_args *p = params;
		iarg[0] = p->fileid; /* int */
		iarg[1] = p->cmd; /* int */
		uarg[2] = (intptr_t) p->data; /* void * */
		*n_args = 3;
		break;
	}
	/* freebsd32_jail */
	case 338: {
		struct freebsd32_jail_args *p = params;
		uarg[0] = (intptr_t) p->jail; /* struct jail32 * */
		*n_args = 1;
		break;
	}
	/* sigprocmask */
	case 340: {
		struct sigprocmask_args *p = params;
		iarg[0] = p->how; /* int */
		uarg[1] = (intptr_t) p->set; /* const sigset_t * */
		uarg[2] = (intptr_t) p->oset; /* sigset_t * */
		*n_args = 3;
		break;
	}
	/* sigsuspend */
	case 341: {
		struct sigsuspend_args *p = params;
		uarg[0] = (intptr_t) p->sigmask; /* const sigset_t * */
		*n_args = 1;
		break;
	}
	/* sigpending */
	case 343: {
		struct sigpending_args *p = params;
		uarg[0] = (intptr_t) p->set; /* sigset_t * */
		*n_args = 1;
		break;
	}
	/* freebsd32_sigtimedwait */
	case 345: {
		struct freebsd32_sigtimedwait_args *p = params;
		uarg[0] = (intptr_t) p->set; /* const sigset_t * */
		uarg[1] = (intptr_t) p->info; /* siginfo_t * */
		uarg[2] = (intptr_t) p->timeout; /* const struct timespec * */
		*n_args = 3;
		break;
	}
	/* freebsd32_sigwaitinfo */
	case 346: {
		struct freebsd32_sigwaitinfo_args *p = params;
		uarg[0] = (intptr_t) p->set; /* const sigset_t * */
		uarg[1] = (intptr_t) p->info; /* siginfo_t * */
		*n_args = 2;
		break;
	}
	/* __acl_get_file */
	case 347: {
		struct __acl_get_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_set_file */
	case 348: {
		struct __acl_set_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_get_fd */
	case 349: {
		struct __acl_get_fd_args *p = params;
		iarg[0] = p->filedes; /* int */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_set_fd */
	case 350: {
		struct __acl_set_fd_args *p = params;
		iarg[0] = p->filedes; /* int */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_delete_file */
	case 351: {
		struct __acl_delete_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		*n_args = 2;
		break;
	}
	/* __acl_delete_fd */
	case 352: {
		struct __acl_delete_fd_args *p = params;
		iarg[0] = p->filedes; /* int */
		iarg[1] = p->type; /* acl_type_t */
		*n_args = 2;
		break;
	}
	/* __acl_aclcheck_file */
	case 353: {
		struct __acl_aclcheck_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_aclcheck_fd */
	case 354: {
		struct __acl_aclcheck_fd_args *p = params;
		iarg[0] = p->filedes; /* int */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* extattrctl */
	case 355: {
		struct extattrctl_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->cmd; /* int */
		uarg[2] = (intptr_t) p->filename; /* const char * */
		iarg[3] = p->attrnamespace; /* int */
		uarg[4] = (intptr_t) p->attrname; /* const char * */
		*n_args = 5;
		break;
	}
	/* extattr_set_file */
	case 356: {
		struct extattr_set_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_get_file */
	case 357: {
		struct extattr_get_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_delete_file */
	case 358: {
		struct extattr_delete_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		*n_args = 3;
		break;
	}
	/* freebsd32_aio_waitcomplete */
	case 359: {
		struct freebsd32_aio_waitcomplete_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb32 ** */
		uarg[1] = (intptr_t) p->timeout; /* struct timespec32 * */
		*n_args = 2;
		break;
	}
	/* getresuid */
	case 360: {
		struct getresuid_args *p = params;
		uarg[0] = (intptr_t) p->ruid; /* uid_t * */
		uarg[1] = (intptr_t) p->euid; /* uid_t * */
		uarg[2] = (intptr_t) p->suid; /* uid_t * */
		*n_args = 3;
		break;
	}
	/* getresgid */
	case 361: {
		struct getresgid_args *p = params;
		uarg[0] = (intptr_t) p->rgid; /* gid_t * */
		uarg[1] = (intptr_t) p->egid; /* gid_t * */
		uarg[2] = (intptr_t) p->sgid; /* gid_t * */
		*n_args = 3;
		break;
	}
	/* kqueue */
	case 362: {
		*n_args = 0;
		break;
	}
	/* freebsd32_kevent */
	case 363: {
		struct freebsd32_kevent_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->changelist; /* const struct kevent32 * */
		iarg[2] = p->nchanges; /* int */
		uarg[3] = (intptr_t) p->eventlist; /* struct kevent32 * */
		iarg[4] = p->nevents; /* int */
		uarg[5] = (intptr_t) p->timeout; /* const struct timespec32 * */
		*n_args = 6;
		break;
	}
	/* extattr_set_fd */
	case 371: {
		struct extattr_set_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_get_fd */
	case 372: {
		struct extattr_get_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_delete_fd */
	case 373: {
		struct extattr_delete_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		*n_args = 3;
		break;
	}
	/* __setugid */
	case 374: {
		struct __setugid_args *p = params;
		iarg[0] = p->flag; /* int */
		*n_args = 1;
		break;
	}
	/* eaccess */
	case 376: {
		struct eaccess_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->amode; /* int */
		*n_args = 2;
		break;
	}
	/* freebsd32_nmount */
	case 378: {
		struct freebsd32_nmount_args *p = params;
		uarg[0] = (intptr_t) p->iovp; /* struct iovec32 * */
		uarg[1] = p->iovcnt; /* unsigned int */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* kenv */
	case 390: {
		struct kenv_args *p = params;
		iarg[0] = p->what; /* int */
		uarg[1] = (intptr_t) p->name; /* const char * */
		uarg[2] = (intptr_t) p->value; /* char * */
		iarg[3] = p->len; /* int */
		*n_args = 4;
		break;
	}
	/* lchflags */
	case 391: {
		struct lchflags_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* uuidgen */
	case 392: {
		struct uuidgen_args *p = params;
		uarg[0] = (intptr_t) p->store; /* struct uuid * */
		iarg[1] = p->count; /* int */
		*n_args = 2;
		break;
	}
	/* freebsd32_sendfile */
	case 393: {
		struct freebsd32_sendfile_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->s; /* int */
		uarg[2] = p->offset1; /* u_int32_t */
		uarg[3] = p->offset2; /* u_int32_t */
		uarg[4] = p->nbytes; /* size_t */
		uarg[5] = (intptr_t) p->hdtr; /* struct sf_hdtr32 * */
		uarg[6] = (intptr_t) p->sbytes; /* off_t * */
		iarg[7] = p->flags; /* int */
		*n_args = 8;
		break;
	}
	/* getfsstat */
	case 395: {
		struct getfsstat_args *p = params;
		uarg[0] = (intptr_t) p->buf; /* struct statfs * */
		iarg[1] = p->bufsize; /* long */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* statfs */
	case 396: {
		struct statfs_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->buf; /* struct statfs * */
		*n_args = 2;
		break;
	}
	/* fstatfs */
	case 397: {
		struct fstatfs_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* struct statfs * */
		*n_args = 2;
		break;
	}
	/* fhstatfs */
	case 398: {
		struct fhstatfs_args *p = params;
		uarg[0] = (intptr_t) p->u_fhp; /* const struct fhandle * */
		uarg[1] = (intptr_t) p->buf; /* struct statfs * */
		*n_args = 2;
		break;
	}
	/* ksem_close */
	case 400: {
		struct ksem_close_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* ksem_post */
	case 401: {
		struct ksem_post_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* ksem_wait */
	case 402: {
		struct ksem_wait_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* ksem_trywait */
	case 403: {
		struct ksem_trywait_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* freebsd32_ksem_init */
	case 404: {
		struct freebsd32_ksem_init_args *p = params;
		uarg[0] = (intptr_t) p->idp; /* semid_t * */
		uarg[1] = p->value; /* unsigned int */
		*n_args = 2;
		break;
	}
	/* freebsd32_ksem_open */
	case 405: {
		struct freebsd32_ksem_open_args *p = params;
		uarg[0] = (intptr_t) p->idp; /* semid_t * */
		uarg[1] = (intptr_t) p->name; /* const char * */
		iarg[2] = p->oflag; /* int */
		iarg[3] = p->mode; /* mode_t */
		uarg[4] = p->value; /* unsigned int */
		*n_args = 5;
		break;
	}
	/* ksem_unlink */
	case 406: {
		struct ksem_unlink_args *p = params;
		uarg[0] = (intptr_t) p->name; /* const char * */
		*n_args = 1;
		break;
	}
	/* ksem_getvalue */
	case 407: {
		struct ksem_getvalue_args *p = params;
		iarg[0] = p->id; /* semid_t */
		uarg[1] = (intptr_t) p->val; /* int * */
		*n_args = 2;
		break;
	}
	/* ksem_destroy */
	case 408: {
		struct ksem_destroy_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* extattr_set_link */
	case 412: {
		struct extattr_set_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_get_link */
	case 413: {
		struct extattr_get_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_delete_link */
	case 414: {
		struct extattr_delete_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		*n_args = 3;
		break;
	}
	/* freebsd32_sigaction */
	case 416: {
		struct freebsd32_sigaction_args *p = params;
		iarg[0] = p->sig; /* int */
		uarg[1] = (intptr_t) p->act; /* struct sigaction32 * */
		uarg[2] = (intptr_t) p->oact; /* struct sigaction32 * */
		*n_args = 3;
		break;
	}
	/* freebsd32_sigreturn */
	case 417: {
		struct freebsd32_sigreturn_args *p = params;
		uarg[0] = (intptr_t) p->sigcntxp; /* const struct freebsd32_ucontext * */
		*n_args = 1;
		break;
	}
	/* freebsd32_getcontext */
	case 421: {
		struct freebsd32_getcontext_args *p = params;
		uarg[0] = (intptr_t) p->ucp; /* struct freebsd32_ucontext * */
		*n_args = 1;
		break;
	}
	/* freebsd32_setcontext */
	case 422: {
		struct freebsd32_setcontext_args *p = params;
		uarg[0] = (intptr_t) p->ucp; /* const struct freebsd32_ucontext * */
		*n_args = 1;
		break;
	}
	/* freebsd32_swapcontext */
	case 423: {
		struct freebsd32_swapcontext_args *p = params;
		uarg[0] = (intptr_t) p->oucp; /* struct freebsd32_ucontext * */
		uarg[1] = (intptr_t) p->ucp; /* const struct freebsd32_ucontext * */
		*n_args = 2;
		break;
	}
	/* __acl_get_link */
	case 425: {
		struct __acl_get_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_set_link */
	case 426: {
		struct __acl_set_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_delete_link */
	case 427: {
		struct __acl_delete_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		*n_args = 2;
		break;
	}
	/* __acl_aclcheck_link */
	case 428: {
		struct __acl_aclcheck_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* sigwait */
	case 429: {
		struct sigwait_args *p = params;
		uarg[0] = (intptr_t) p->set; /* const sigset_t * */
		uarg[1] = (intptr_t) p->sig; /* int * */
		*n_args = 2;
		break;
	}
	/* thr_exit */
	case 431: {
		struct thr_exit_args *p = params;
		uarg[0] = (intptr_t) p->state; /* long * */
		*n_args = 1;
		break;
	}
	/* thr_self */
	case 432: {
		struct thr_self_args *p = params;
		uarg[0] = (intptr_t) p->id; /* long * */
		*n_args = 1;
		break;
	}
	/* thr_kill */
	case 433: {
		struct thr_kill_args *p = params;
		iarg[0] = p->id; /* long */
		iarg[1] = p->sig; /* int */
		*n_args = 2;
		break;
	}
	/* freebsd32_umtx_lock */
	case 434: {
		struct freebsd32_umtx_lock_args *p = params;
		uarg[0] = (intptr_t) p->umtx; /* struct umtx * */
		*n_args = 1;
		break;
	}
	/* freebsd32_umtx_unlock */
	case 435: {
		struct freebsd32_umtx_unlock_args *p = params;
		uarg[0] = (intptr_t) p->umtx; /* struct umtx * */
		*n_args = 1;
		break;
	}
	/* jail_attach */
	case 436: {
		struct jail_attach_args *p = params;
		iarg[0] = p->jid; /* int */
		*n_args = 1;
		break;
	}
	/* extattr_list_fd */
	case 437: {
		struct extattr_list_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->data; /* void * */
		uarg[3] = p->nbytes; /* size_t */
		*n_args = 4;
		break;
	}
	/* extattr_list_file */
	case 438: {
		struct extattr_list_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->data; /* void * */
		uarg[3] = p->nbytes; /* size_t */
		*n_args = 4;
		break;
	}
	/* extattr_list_link */
	case 439: {
		struct extattr_list_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->data; /* void * */
		uarg[3] = p->nbytes; /* size_t */
		*n_args = 4;
		break;
	}
	/* freebsd32_ksem_timedwait */
	case 441: {
		struct freebsd32_ksem_timedwait_args *p = params;
		iarg[0] = p->id; /* semid_t */
		uarg[1] = (intptr_t) p->abstime; /* const struct timespec32 * */
		*n_args = 2;
		break;
	}
	/* freebsd32_thr_suspend */
	case 442: {
		struct freebsd32_thr_suspend_args *p = params;
		uarg[0] = (intptr_t) p->timeout; /* const struct timespec32 * */
		*n_args = 1;
		break;
	}
	/* thr_wake */
	case 443: {
		struct thr_wake_args *p = params;
		iarg[0] = p->id; /* long */
		*n_args = 1;
		break;
	}
	/* kldunloadf */
	case 444: {
		struct kldunloadf_args *p = params;
		iarg[0] = p->fileid; /* int */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* audit */
	case 445: {
		struct audit_args *p = params;
		uarg[0] = (intptr_t) p->record; /* const void * */
		uarg[1] = p->length; /* u_int */
		*n_args = 2;
		break;
	}
	/* auditon */
	case 446: {
		struct auditon_args *p = params;
		iarg[0] = p->cmd; /* int */
		uarg[1] = (intptr_t) p->data; /* void * */
		uarg[2] = p->length; /* u_int */
		*n_args = 3;
		break;
	}
	/* getauid */
	case 447: {
		struct getauid_args *p = params;
		uarg[0] = (intptr_t) p->auid; /* uid_t * */
		*n_args = 1;
		break;
	}
	/* setauid */
	case 448: {
		struct setauid_args *p = params;
		uarg[0] = (intptr_t) p->auid; /* uid_t * */
		*n_args = 1;
		break;
	}
	/* getaudit */
	case 449: {
		struct getaudit_args *p = params;
		uarg[0] = (intptr_t) p->auditinfo; /* struct auditinfo * */
		*n_args = 1;
		break;
	}
	/* setaudit */
	case 450: {
		struct setaudit_args *p = params;
		uarg[0] = (intptr_t) p->auditinfo; /* struct auditinfo * */
		*n_args = 1;
		break;
	}
	/* getaudit_addr */
	case 451: {
		struct getaudit_addr_args *p = params;
		uarg[0] = (intptr_t) p->auditinfo_addr; /* struct auditinfo_addr * */
		uarg[1] = p->length; /* u_int */
		*n_args = 2;
		break;
	}
	/* setaudit_addr */
	case 452: {
		struct setaudit_addr_args *p = params;
		uarg[0] = (intptr_t) p->auditinfo_addr; /* struct auditinfo_addr * */
		uarg[1] = p->length; /* u_int */
		*n_args = 2;
		break;
	}
	/* auditctl */
	case 453: {
		struct auditctl_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* freebsd32_umtx_op */
	case 454: {
		struct freebsd32_umtx_op_args *p = params;
		uarg[0] = (intptr_t) p->obj; /* void * */
		iarg[1] = p->op; /* int */
		uarg[2] = p->val; /* u_long */
		uarg[3] = (intptr_t) p->uaddr; /* void * */
		uarg[4] = (intptr_t) p->uaddr2; /* void * */
		*n_args = 5;
		break;
	}
	/* freebsd32_thr_new */
	case 455: {
		struct freebsd32_thr_new_args *p = params;
		uarg[0] = (intptr_t) p->param; /* struct thr_param32 * */
		iarg[1] = p->param_size; /* int */
		*n_args = 2;
		break;
	}
	/* sigqueue */
	case 456: {
		struct sigqueue_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		iarg[1] = p->signum; /* int */
		uarg[2] = (intptr_t) p->value; /* void * */
		*n_args = 3;
		break;
	}
	/* freebsd32_kmq_open */
	case 457: {
		struct freebsd32_kmq_open_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->flags; /* int */
		iarg[2] = p->mode; /* mode_t */
		uarg[3] = (intptr_t) p->attr; /* const struct mq_attr32 * */
		*n_args = 4;
		break;
	}
	/* freebsd32_kmq_setattr */
	case 458: {
		struct freebsd32_kmq_setattr_args *p = params;
		iarg[0] = p->mqd; /* int */
		uarg[1] = (intptr_t) p->attr; /* const struct mq_attr32 * */
		uarg[2] = (intptr_t) p->oattr; /* struct mq_attr32 * */
		*n_args = 3;
		break;
	}
	/* freebsd32_kmq_timedreceive */
	case 459: {
		struct freebsd32_kmq_timedreceive_args *p = params;
		iarg[0] = p->mqd; /* int */
		uarg[1] = (intptr_t) p->msg_ptr; /* char * */
		uarg[2] = p->msg_len; /* size_t */
		uarg[3] = (intptr_t) p->msg_prio; /* unsigned * */
		uarg[4] = (intptr_t) p->abs_timeout; /* const struct timespec32 * */
		*n_args = 5;
		break;
	}
	/* freebsd32_kmq_timedsend */
	case 460: {
		struct freebsd32_kmq_timedsend_args *p = params;
		iarg[0] = p->mqd; /* int */
		uarg[1] = (intptr_t) p->msg_ptr; /* const char * */
		uarg[2] = p->msg_len; /* size_t */
		uarg[3] = p->msg_prio; /* unsigned */
		uarg[4] = (intptr_t) p->abs_timeout; /* const struct timespec32 * */
		*n_args = 5;
		break;
	}
	/* kmq_notify */
	case 461: {
		struct kmq_notify_args *p = params;
		iarg[0] = p->mqd; /* int */
		uarg[1] = (intptr_t) p->sigev; /* const struct sigevent * */
		*n_args = 2;
		break;
	}
	/* kmq_unlink */
	case 462: {
		struct kmq_unlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		*n_args = 1;
		break;
	}
	/* abort2 */
	case 463: {
		struct abort2_args *p = params;
		uarg[0] = (intptr_t) p->why; /* const char * */
		iarg[1] = p->nargs; /* int */
		uarg[2] = (intptr_t) p->args; /* void ** */
		*n_args = 3;
		break;
	}
	/* thr_set_name */
	case 464: {
		struct thr_set_name_args *p = params;
		iarg[0] = p->id; /* long */
		uarg[1] = (intptr_t) p->name; /* const char * */
		*n_args = 2;
		break;
	}
	/* freebsd32_aio_fsync */
	case 465: {
		struct freebsd32_aio_fsync_args *p = params;
		iarg[0] = p->op; /* int */
		uarg[1] = (intptr_t) p->aiocbp; /* struct aiocb32 * */
		*n_args = 2;
		break;
	}
	/* rtprio_thread */
	case 466: {
		struct rtprio_thread_args *p = params;
		iarg[0] = p->function; /* int */
		iarg[1] = p->lwpid; /* lwpid_t */
		uarg[2] = (intptr_t) p->rtp; /* struct rtprio * */
		*n_args = 3;
		break;
	}
	/* sctp_peeloff */
	case 471: {
		struct sctp_peeloff_args *p = params;
		iarg[0] = p->sd; /* int */
		uarg[1] = p->name; /* uint32_t */
		*n_args = 2;
		break;
	}
	/* sctp_generic_sendmsg */
	case 472: {
		struct sctp_generic_sendmsg_args *p = params;
		iarg[0] = p->sd; /* int */
		uarg[1] = (intptr_t) p->msg; /* caddr_t */
		iarg[2] = p->mlen; /* int */
		uarg[3] = (intptr_t) p->to; /* caddr_t */
		iarg[4] = p->tolen; /* __socklen_t */
		uarg[5] = (intptr_t) p->sinfo; /* struct sctp_sndrcvinfo * */
		iarg[6] = p->flags; /* int */
		*n_args = 7;
		break;
	}
	/* sctp_generic_sendmsg_iov */
	case 473: {
		struct sctp_generic_sendmsg_iov_args *p = params;
		iarg[0] = p->sd; /* int */
		uarg[1] = (intptr_t) p->iov; /* struct iovec * */
		iarg[2] = p->iovlen; /* int */
		uarg[3] = (intptr_t) p->to; /* caddr_t */
		iarg[4] = p->tolen; /* __socklen_t */
		uarg[5] = (intptr_t) p->sinfo; /* struct sctp_sndrcvinfo * */
		iarg[6] = p->flags; /* int */
		*n_args = 7;
		break;
	}
	/* sctp_generic_recvmsg */
	case 474: {
		struct sctp_generic_recvmsg_args *p = params;
		iarg[0] = p->sd; /* int */
		uarg[1] = (intptr_t) p->iov; /* struct iovec * */
		iarg[2] = p->iovlen; /* int */
		uarg[3] = (intptr_t) p->from; /* struct sockaddr * */
		uarg[4] = (intptr_t) p->fromlenaddr; /* __socklen_t * */
		uarg[5] = (intptr_t) p->sinfo; /* struct sctp_sndrcvinfo * */
		uarg[6] = (intptr_t) p->msg_flags; /* int * */
		*n_args = 7;
		break;
	}
#ifdef PAD64_REQUIRED
	/* freebsd32_pread */
	case 475: {
		struct freebsd32_pread_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* void * */
		uarg[2] = p->nbyte; /* size_t */
		iarg[3] = p->pad; /* int */
		uarg[4] = p->offset1; /* u_int32_t */
		uarg[5] = p->offset2; /* u_int32_t */
		*n_args = 6;
		break;
	}
	/* freebsd32_pwrite */
	case 476: {
		struct freebsd32_pwrite_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* const void * */
		uarg[2] = p->nbyte; /* size_t */
		iarg[3] = p->pad; /* int */
		uarg[4] = p->offset1; /* u_int32_t */
		uarg[5] = p->offset2; /* u_int32_t */
		*n_args = 6;
		break;
	}
	/* freebsd32_mmap */
	case 477: {
		struct freebsd32_mmap_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* caddr_t */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->prot; /* int */
		iarg[3] = p->flags; /* int */
		iarg[4] = p->fd; /* int */
		iarg[5] = p->pad; /* int */
		uarg[6] = p->pos1; /* u_int32_t */
		uarg[7] = p->pos2; /* u_int32_t */
		*n_args = 8;
		break;
	}
	/* freebsd32_lseek */
	case 478: {
		struct freebsd32_lseek_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->pad; /* int */
		uarg[2] = p->offset1; /* u_int32_t */
		uarg[3] = p->offset2; /* u_int32_t */
		iarg[4] = p->whence; /* int */
		*n_args = 5;
		break;
	}
	/* freebsd32_truncate */
	case 479: {
		struct freebsd32_truncate_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->pad; /* int */
		uarg[2] = p->length1; /* u_int32_t */
		uarg[3] = p->length2; /* u_int32_t */
		*n_args = 4;
		break;
	}
	/* freebsd32_ftruncate */
	case 480: {
		struct freebsd32_ftruncate_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->pad; /* int */
		uarg[2] = p->length1; /* u_int32_t */
		uarg[3] = p->length2; /* u_int32_t */
		*n_args = 4;
		break;
	}
#else
	/* freebsd32_pread */
	case 475: {
		struct freebsd32_pread_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* void * */
		uarg[2] = p->nbyte; /* size_t */
		uarg[3] = p->offset1; /* u_int32_t */
		uarg[4] = p->offset2; /* u_int32_t */
		*n_args = 5;
		break;
	}
	/* freebsd32_pwrite */
	case 476: {
		struct freebsd32_pwrite_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* const void * */
		uarg[2] = p->nbyte; /* size_t */
		uarg[3] = p->offset1; /* u_int32_t */
		uarg[4] = p->offset2; /* u_int32_t */
		*n_args = 5;
		break;
	}
	/* freebsd32_mmap */
	case 477: {
		struct freebsd32_mmap_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* caddr_t */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->prot; /* int */
		iarg[3] = p->flags; /* int */
		iarg[4] = p->fd; /* int */
		uarg[5] = p->pos1; /* u_int32_t */
		uarg[6] = p->pos2; /* u_int32_t */
		*n_args = 7;
		break;
	}
	/* freebsd32_lseek */
	case 478: {
		struct freebsd32_lseek_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = p->offset1; /* u_int32_t */
		uarg[2] = p->offset2; /* u_int32_t */
		iarg[3] = p->whence; /* int */
		*n_args = 4;
		break;
	}
	/* freebsd32_truncate */
	case 479: {
		struct freebsd32_truncate_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = p->length1; /* u_int32_t */
		uarg[2] = p->length2; /* u_int32_t */
		*n_args = 3;
		break;
	}
	/* freebsd32_ftruncate */
	case 480: {
		struct freebsd32_ftruncate_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = p->length1; /* u_int32_t */
		uarg[2] = p->length2; /* u_int32_t */
		*n_args = 3;
		break;
	}
#endif
	/* thr_kill2 */
	case 481: {
		struct thr_kill2_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		iarg[1] = p->id; /* long */
		iarg[2] = p->sig; /* int */
		*n_args = 3;
		break;
	}
	/* shm_open */
	case 482: {
		struct shm_open_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->flags; /* int */
		iarg[2] = p->mode; /* mode_t */
		*n_args = 3;
		break;
	}
	/* shm_unlink */
	case 483: {
		struct shm_unlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		*n_args = 1;
		break;
	}
	/* cpuset */
	case 484: {
		struct cpuset_args *p = params;
		uarg[0] = (intptr_t) p->setid; /* cpusetid_t * */
		*n_args = 1;
		break;
	}
#ifdef PAD64_REQUIRED
	/* freebsd32_cpuset_setid */
	case 485: {
		struct freebsd32_cpuset_setid_args *p = params;
		iarg[0] = p->which; /* cpuwhich_t */
		iarg[1] = p->pad; /* int */
		uarg[2] = p->id1; /* u_int32_t */
		uarg[3] = p->id2; /* u_int32_t */
		iarg[4] = p->setid; /* cpusetid_t */
		*n_args = 5;
		break;
	}
#else
	/* freebsd32_cpuset_setid */
	case 485: {
		struct freebsd32_cpuset_setid_args *p = params;
		iarg[0] = p->which; /* cpuwhich_t */
		uarg[1] = p->id1; /* u_int32_t */
		uarg[2] = p->id2; /* u_int32_t */
		iarg[3] = p->setid; /* cpusetid_t */
		*n_args = 4;
		break;
	}
#endif
	/* freebsd32_cpuset_getid */
	case 486: {
		struct freebsd32_cpuset_getid_args *p = params;
		iarg[0] = p->level; /* cpulevel_t */
		iarg[1] = p->which; /* cpuwhich_t */
		uarg[2] = p->id1; /* u_int32_t */
		uarg[3] = p->id2; /* u_int32_t */
		uarg[4] = (intptr_t) p->setid; /* cpusetid_t * */
		*n_args = 5;
		break;
	}
	/* freebsd32_cpuset_getaffinity */
	case 487: {
		struct freebsd32_cpuset_getaffinity_args *p = params;
		iarg[0] = p->level; /* cpulevel_t */
		iarg[1] = p->which; /* cpuwhich_t */
		uarg[2] = p->id1; /* u_int32_t */
		uarg[3] = p->id2; /* u_int32_t */
		uarg[4] = p->cpusetsize; /* size_t */
		uarg[5] = (intptr_t) p->mask; /* cpuset_t * */
		*n_args = 6;
		break;
	}
	/* freebsd32_cpuset_setaffinity */
	case 488: {
		struct freebsd32_cpuset_setaffinity_args *p = params;
		iarg[0] = p->level; /* cpulevel_t */
		iarg[1] = p->which; /* cpuwhich_t */
		uarg[2] = p->id1; /* u_int32_t */
		uarg[3] = p->id2; /* u_int32_t */
		uarg[4] = p->cpusetsize; /* size_t */
		uarg[5] = (intptr_t) p->mask; /* const cpuset_t * */
		*n_args = 6;
		break;
	}
	/* faccessat */
	case 489: {
		struct faccessat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		iarg[2] = p->amode; /* int */
		iarg[3] = p->flag; /* int */
		*n_args = 4;
		break;
	}
	/* fchmodat */
	case 490: {
		struct fchmodat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* const char * */
		iarg[2] = p->mode; /* mode_t */
		iarg[3] = p->flag; /* int */
		*n_args = 4;
		break;
	}
	/* fchownat */
	case 491: {
		struct fchownat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		uarg[2] = p->uid; /* uid_t */
		iarg[3] = p->gid; /* gid_t */
		iarg[4] = p->flag; /* int */
		*n_args = 5;
		break;
	}
	/* freebsd32_fexecve */
	case 492: {
		struct freebsd32_fexecve_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->argv; /* u_int32_t * */
		uarg[2] = (intptr_t) p->envv; /* u_int32_t * */
		*n_args = 3;
		break;
	}
	/* freebsd32_fstatat */
	case 493: {
		struct freebsd32_fstatat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		uarg[2] = (intptr_t) p->buf; /* struct stat * */
		iarg[3] = p->flag; /* int */
		*n_args = 4;
		break;
	}
	/* freebsd32_futimesat */
	case 494: {
		struct freebsd32_futimesat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		uarg[2] = (intptr_t) p->times; /* struct timeval * */
		*n_args = 3;
		break;
	}
	/* linkat */
	case 495: {
		struct linkat_args *p = params;
		iarg[0] = p->fd1; /* int */
		uarg[1] = (intptr_t) p->path1; /* char * */
		iarg[2] = p->fd2; /* int */
		uarg[3] = (intptr_t) p->path2; /* char * */
		iarg[4] = p->flag; /* int */
		*n_args = 5;
		break;
	}
	/* mkdirat */
	case 496: {
		struct mkdirat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		iarg[2] = p->mode; /* mode_t */
		*n_args = 3;
		break;
	}
	/* mkfifoat */
	case 497: {
		struct mkfifoat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		iarg[2] = p->mode; /* mode_t */
		*n_args = 3;
		break;
	}
	/* mknodat */
	case 498: {
		struct mknodat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		iarg[2] = p->mode; /* mode_t */
		iarg[3] = p->dev; /* dev_t */
		*n_args = 4;
		break;
	}
	/* openat */
	case 499: {
		struct openat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		iarg[2] = p->flag; /* int */
		iarg[3] = p->mode; /* mode_t */
		*n_args = 4;
		break;
	}
	/* readlinkat */
	case 500: {
		struct readlinkat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		uarg[2] = (intptr_t) p->buf; /* char * */
		uarg[3] = p->bufsize; /* size_t */
		*n_args = 4;
		break;
	}
	/* renameat */
	case 501: {
		struct renameat_args *p = params;
		iarg[0] = p->oldfd; /* int */
		uarg[1] = (intptr_t) p->old; /* char * */
		iarg[2] = p->newfd; /* int */
		uarg[3] = (intptr_t) p->new; /* const char * */
		*n_args = 4;
		break;
	}
	/* symlinkat */
	case 502: {
		struct symlinkat_args *p = params;
		uarg[0] = (intptr_t) p->path1; /* char * */
		iarg[1] = p->fd; /* int */
		uarg[2] = (intptr_t) p->path2; /* char * */
		*n_args = 3;
		break;
	}
	/* unlinkat */
	case 503: {
		struct unlinkat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->path; /* char * */
		iarg[2] = p->flag; /* int */
		*n_args = 3;
		break;
	}
	/* posix_openpt */
	case 504: {
		struct posix_openpt_args *p = params;
		iarg[0] = p->flags; /* int */
		*n_args = 1;
		break;
	}
	/* freebsd32_jail_get */
	case 506: {
		struct freebsd32_jail_get_args *p = params;
		uarg[0] = (intptr_t) p->iovp; /* struct iovec32 * */
		uarg[1] = p->iovcnt; /* unsigned int */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* freebsd32_jail_set */
	case 507: {
		struct freebsd32_jail_set_args *p = params;
		uarg[0] = (intptr_t) p->iovp; /* struct iovec32 * */
		uarg[1] = p->iovcnt; /* unsigned int */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* jail_remove */
	case 508: {
		struct jail_remove_args *p = params;
		iarg[0] = p->jid; /* int */
		*n_args = 1;
		break;
	}
	/* closefrom */
	case 509: {
		struct closefrom_args *p = params;
		iarg[0] = p->lowfd; /* int */
		*n_args = 1;
		break;
	}
	/* freebsd32_semctl */
	case 510: {
		struct freebsd32_semctl_args *p = params;
		iarg[0] = p->semid; /* int */
		iarg[1] = p->semnum; /* int */
		iarg[2] = p->cmd; /* int */
		uarg[3] = (intptr_t) p->arg; /* union semun32 * */
		*n_args = 4;
		break;
	}
	/* freebsd32_msgctl */
	case 511: {
		struct freebsd32_msgctl_args *p = params;
		iarg[0] = p->msqid; /* int */
		iarg[1] = p->cmd; /* int */
		uarg[2] = (intptr_t) p->buf; /* struct msqid_ds32 * */
		*n_args = 3;
		break;
	}
	/* freebsd32_shmctl */
	case 512: {
		struct freebsd32_shmctl_args *p = params;
		iarg[0] = p->shmid; /* int */
		iarg[1] = p->cmd; /* int */
		uarg[2] = (intptr_t) p->buf; /* struct shmid_ds32 * */
		*n_args = 3;
		break;
	}
	/* lpathconf */
	case 513: {
		struct lpathconf_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->name; /* int */
		*n_args = 2;
		break;
	}
	/* cap_new */
	case 514: {
		struct cap_new_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = p->rights; /* u_int64_t */
		*n_args = 2;
		break;
	}
	/* cap_getrights */
	case 515: {
		struct cap_getrights_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->rightsp; /* u_int64_t * */
		*n_args = 2;
		break;
	}
	/* cap_enter */
	case 516: {
		*n_args = 0;
		break;
	}
	/* cap_getmode */
	case 517: {
		struct cap_getmode_args *p = params;
		uarg[0] = (intptr_t) p->modep; /* u_int * */
		*n_args = 1;
		break;
	}
	/* freebsd32_pselect */
	case 522: {
		struct freebsd32_pselect_args *p = params;
		iarg[0] = p->nd; /* int */
		uarg[1] = (intptr_t) p->in; /* fd_set * */
		uarg[2] = (intptr_t) p->ou; /* fd_set * */
		uarg[3] = (intptr_t) p->ex; /* fd_set * */
		uarg[4] = (intptr_t) p->ts; /* const struct timespec32 * */
		uarg[5] = (intptr_t) p->sm; /* const sigset_t * */
		*n_args = 6;
		break;
	}
	/* getloginclass */
	case 523: {
		struct getloginclass_args *p = params;
		uarg[0] = (intptr_t) p->namebuf; /* char * */
		uarg[1] = p->namelen; /* size_t */
		*n_args = 2;
		break;
	}
	/* setloginclass */
	case 524: {
		struct setloginclass_args *p = params;
		uarg[0] = (intptr_t) p->namebuf; /* const char * */
		*n_args = 1;
		break;
	}
	/* rctl_get_racct */
	case 525: {
		struct rctl_get_racct_args *p = params;
		uarg[0] = (intptr_t) p->inbufp; /* const void * */
		uarg[1] = p->inbuflen; /* size_t */
		uarg[2] = (intptr_t) p->outbufp; /* void * */
		uarg[3] = p->outbuflen; /* size_t */
		*n_args = 4;
		break;
	}
	/* rctl_get_rules */
	case 526: {
		struct rctl_get_rules_args *p = params;
		uarg[0] = (intptr_t) p->inbufp; /* const void * */
		uarg[1] = p->inbuflen; /* size_t */
		uarg[2] = (intptr_t) p->outbufp; /* void * */
		uarg[3] = p->outbuflen; /* size_t */
		*n_args = 4;
		break;
	}
	/* rctl_get_limits */
	case 527: {
		struct rctl_get_limits_args *p = params;
		uarg[0] = (intptr_t) p->inbufp; /* const void * */
		uarg[1] = p->inbuflen; /* size_t */
		uarg[2] = (intptr_t) p->outbufp; /* void * */
		uarg[3] = p->outbuflen; /* size_t */
		*n_args = 4;
		break;
	}
	/* rctl_add_rule */
	case 528: {
		struct rctl_add_rule_args *p = params;
		uarg[0] = (intptr_t) p->inbufp; /* const void * */
		uarg[1] = p->inbuflen; /* size_t */
		uarg[2] = (intptr_t) p->outbufp; /* void * */
		uarg[3] = p->outbuflen; /* size_t */
		*n_args = 4;
		break;
	}
	/* rctl_remove_rule */
	case 529: {
		struct rctl_remove_rule_args *p = params;
		uarg[0] = (intptr_t) p->inbufp; /* const void * */
		uarg[1] = p->inbuflen; /* size_t */
		uarg[2] = (intptr_t) p->outbufp; /* void * */
		uarg[3] = p->outbuflen; /* size_t */
		*n_args = 4;
		break;
	}
	/* freebsd32_posix_fallocate */
	case 530: {
		struct freebsd32_posix_fallocate_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = p->offset1; /* uint32_t */
		uarg[2] = p->offset2; /* uint32_t */
		uarg[3] = p->len1; /* uint32_t */
		uarg[4] = p->len2; /* uint32_t */
		*n_args = 5;
		break;
	}
	/* freebsd32_posix_fadvise */
	case 531: {
		struct freebsd32_posix_fadvise_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = p->offset1; /* uint32_t */
		uarg[2] = p->offset2; /* uint32_t */
		uarg[3] = p->len1; /* uint32_t */
		uarg[4] = p->len2; /* uint32_t */
		iarg[5] = p->advice; /* int */
		*n_args = 6;
		break;
	}
	default:
		*n_args = 0;
		break;
	};
}
static void
systrace_entry_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
#if !defined(PAD64_REQUIRED) && (defined(__powerpc__) || defined(__mips__))
#define PAD64_REQUIRED
#endif
	/* nosys */
	case 0:
		break;
	/* sys_exit */
	case 1:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* fork */
	case 2:
		break;
	/* read */
	case 3:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* write */
	case 4:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* open */
	case 5:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* close */
	case 6:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_wait4 */
	case 7:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct rusage32 *";
			break;
		default:
			break;
		};
		break;
	/* link */
	case 9:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* unlink */
	case 10:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* chdir */
	case 12:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* fchdir */
	case 13:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* mknod */
	case 14:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* chmod */
	case 15:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* chown */
	case 16:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* obreak */
	case 17:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* getpid */
	case 20:
		break;
	/* mount */
	case 21:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "caddr_t";
			break;
		default:
			break;
		};
		break;
	/* unmount */
	case 22:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* setuid */
	case 23:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* getuid */
	case 24:
		break;
	/* geteuid */
	case 25:
		break;
	/* ptrace */
	case 26:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "pid_t";
			break;
		case 2:
			p = "caddr_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_recvmsg */
	case 27:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct msghdr32 *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_sendmsg */
	case 28:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct msghdr32 *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_recvfrom */
	case 29:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_int32_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "u_int32_t";
			break;
		case 5:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* accept */
	case 30:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "caddr_t";
			break;
		case 2:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* getpeername */
	case 31:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "caddr_t";
			break;
		case 2:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* getsockname */
	case 32:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "caddr_t";
			break;
		case 2:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* access */
	case 33:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* chflags */
	case 34:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* fchflags */
	case 35:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sync */
	case 36:
		break;
	/* kill */
	case 37:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* getppid */
	case 39:
		break;
	/* dup */
	case 41:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* pipe */
	case 42:
		break;
	/* getegid */
	case 43:
		break;
	/* profil */
	case 44:
		switch(ndx) {
		case 0:
			p = "caddr_t";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* ktrace */
	case 45:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* getgid */
	case 47:
		break;
	/* getlogin */
	case 49:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* setlogin */
	case 50:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* acct */
	case 51:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_sigaltstack */
	case 53:
		switch(ndx) {
		case 0:
			p = "struct sigaltstack32 *";
			break;
		case 1:
			p = "struct sigaltstack32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_ioctl */
	case 54:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uint32_t";
			break;
		case 2:
			p = "struct md_ioctl32 *";
			break;
		default:
			break;
		};
		break;
	/* reboot */
	case 55:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* revoke */
	case 56:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* symlink */
	case 57:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* readlink */
	case 58:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_execve */
	case 59:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "u_int32_t *";
			break;
		case 2:
			p = "u_int32_t *";
			break;
		default:
			break;
		};
		break;
	/* umask */
	case 60:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* chroot */
	case 61:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* msync */
	case 65:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* vfork */
	case 66:
		break;
	/* sbrk */
	case 69:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sstk */
	case 70:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* ovadvise */
	case 72:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* munmap */
	case 73:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_mprotect */
	case 74:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* madvise */
	case 75:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* mincore */
	case 78:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* getgroups */
	case 79:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* setgroups */
	case 80:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* getpgrp */
	case 81:
		break;
	/* setpgid */
	case 82:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_setitimer */
	case 83:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "struct itimerval32 *";
			break;
		case 2:
			p = "struct itimerval32 *";
			break;
		default:
			break;
		};
		break;
	/* swapon */
	case 85:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_getitimer */
	case 86:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "struct itimerval32 *";
			break;
		default:
			break;
		};
		break;
	/* getdtablesize */
	case 89:
		break;
	/* dup2 */
	case 90:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* fcntl */
	case 92:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_select */
	case 93:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "struct timeval32 *";
			break;
		default:
			break;
		};
		break;
	/* fsync */
	case 95:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* setpriority */
	case 96:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* socket */
	case 97:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* connect */
	case 98:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "caddr_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* getpriority */
	case 100:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* bind */
	case 104:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "caddr_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* setsockopt */
	case 105:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "caddr_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* listen */
	case 106:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_gettimeofday */
	case 116:
		switch(ndx) {
		case 0:
			p = "struct timeval32 *";
			break;
		case 1:
			p = "struct timezone *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_getrusage */
	case 117:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct rusage32 *";
			break;
		default:
			break;
		};
		break;
	/* getsockopt */
	case 118:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "caddr_t";
			break;
		case 4:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_readv */
	case 120:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct iovec32 *";
			break;
		case 2:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_writev */
	case 121:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct iovec32 *";
			break;
		case 2:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_settimeofday */
	case 122:
		switch(ndx) {
		case 0:
			p = "struct timeval32 *";
			break;
		case 1:
			p = "struct timezone *";
			break;
		default:
			break;
		};
		break;
	/* fchown */
	case 123:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* fchmod */
	case 124:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* setreuid */
	case 126:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* setregid */
	case 127:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* rename */
	case 128:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* flock */
	case 131:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* mkfifo */
	case 132:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sendto */
	case 133:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "caddr_t";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "caddr_t";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* shutdown */
	case 134:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* socketpair */
	case 135:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* mkdir */
	case 136:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* rmdir */
	case 137:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_utimes */
	case 138:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct timeval32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_adjtime */
	case 140:
		switch(ndx) {
		case 0:
			p = "struct timeval32 *";
			break;
		case 1:
			p = "struct timeval32 *";
			break;
		default:
			break;
		};
		break;
	/* setsid */
	case 147:
		break;
	/* quotactl */
	case 148:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "caddr_t";
			break;
		default:
			break;
		};
		break;
	/* getfh */
	case 161:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct fhandle *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_sysarch */
	case 165:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* rtprio */
	case 166:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "pid_t";
			break;
		case 2:
			p = "struct rtprio *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_semsys */
	case 169:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_msgsys */
	case 170:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_shmsys */
	case 171:
		switch(ndx) {
		case 0:
			p = "uint32_t";
			break;
		case 1:
			p = "uint32_t";
			break;
		case 2:
			p = "uint32_t";
			break;
		case 3:
			p = "uint32_t";
			break;
		default:
			break;
		};
		break;
	/* ntp_adjtime */
	case 176:
		switch(ndx) {
		case 0:
			p = "struct timex *";
			break;
		default:
			break;
		};
		break;
	/* setgid */
	case 181:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* setegid */
	case 182:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* seteuid */
	case 183:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_stat */
	case 188:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct stat32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_fstat */
	case 189:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct stat32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_lstat */
	case 190:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct stat32 *";
			break;
		default:
			break;
		};
		break;
	/* pathconf */
	case 191:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* fpathconf */
	case 192:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* getrlimit */
	case 194:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "struct rlimit *";
			break;
		default:
			break;
		};
		break;
	/* setrlimit */
	case 195:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "struct rlimit *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_getdirentries */
	case 196:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "u_int";
			break;
		case 3:
			p = "int32_t *";
			break;
		default:
			break;
		};
		break;
	/* nosys */
	case 198:
		break;
	/* freebsd32_sysctl */
	case 202:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "u_int32_t *";
			break;
		case 4:
			p = "void *";
			break;
		case 5:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* mlock */
	case 203:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* munlock */
	case 204:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* undelete */
	case 205:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_futimes */
	case 206:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct timeval32 *";
			break;
		default:
			break;
		};
		break;
	/* getpgid */
	case 207:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* poll */
	case 209:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* lkmnosys */
	case 210:
		break;
	/* lkmnosys */
	case 211:
		break;
	/* lkmnosys */
	case 212:
		break;
	/* lkmnosys */
	case 213:
		break;
	/* lkmnosys */
	case 214:
		break;
	/* lkmnosys */
	case 215:
		break;
	/* lkmnosys */
	case 216:
		break;
	/* lkmnosys */
	case 217:
		break;
	/* lkmnosys */
	case 218:
		break;
	/* lkmnosys */
	case 219:
		break;
	/* semget */
	case 221:
		switch(ndx) {
		case 0:
			p = "key_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* semop */
	case 222:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sembuf *";
			break;
		case 2:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* msgget */
	case 225:
		switch(ndx) {
		case 0:
			p = "key_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_msgsnd */
	case 226:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_msgrcv */
	case 227:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "long";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* shmat */
	case 228:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* shmdt */
	case 230:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* shmget */
	case 231:
		switch(ndx) {
		case 0:
			p = "key_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_clock_gettime */
	case 232:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_clock_settime */
	case 233:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "const struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_clock_getres */
	case 234:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_nanosleep */
	case 240:
		switch(ndx) {
		case 0:
			p = "const struct timespec32 *";
			break;
		case 1:
			p = "struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* ffclock_getcounter */
	case 241:
		switch(ndx) {
		case 0:
			p = "ffcounter *";
			break;
		default:
			break;
		};
		break;
	/* ffclock_setestimate */
	case 242:
		switch(ndx) {
		case 0:
			p = "struct ffclock_estimate *";
			break;
		default:
			break;
		};
		break;
	/* ffclock_getestimate */
	case 243:
		switch(ndx) {
		case 0:
			p = "struct ffclock_estimate *";
			break;
		default:
			break;
		};
		break;
	/* minherit */
	case 250:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* rfork */
	case 251:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* openbsd_poll */
	case 252:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* issetugid */
	case 253:
		break;
	/* lchown */
	case 254:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_aio_read */
	case 255:
		switch(ndx) {
		case 0:
			p = "struct aiocb32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_aio_write */
	case 256:
		switch(ndx) {
		case 0:
			p = "struct aiocb32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_lio_listio */
	case 257:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct aiocb32 *const *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct sigevent *";
			break;
		default:
			break;
		};
		break;
	/* getdents */
	case 272:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* lchmod */
	case 274:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* lchown */
	case 275:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_lutimes */
	case 276:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct timeval32 *";
			break;
		default:
			break;
		};
		break;
	/* msync */
	case 277:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* nstat */
	case 278:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct nstat *";
			break;
		default:
			break;
		};
		break;
	/* nfstat */
	case 279:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct nstat *";
			break;
		default:
			break;
		};
		break;
	/* nlstat */
	case 280:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct nstat *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_preadv */
	case 289:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct iovec32 *";
			break;
		case 2:
			p = "u_int";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_pwritev */
	case 290:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct iovec32 *";
			break;
		case 2:
			p = "u_int";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* fhopen */
	case 298:
		switch(ndx) {
		case 0:
			p = "const struct fhandle *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* fhstat */
	case 299:
		switch(ndx) {
		case 0:
			p = "const struct fhandle *";
			break;
		case 1:
			p = "struct stat *";
			break;
		default:
			break;
		};
		break;
	/* modnext */
	case 300:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_modstat */
	case 301:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct module_stat32 *";
			break;
		default:
			break;
		};
		break;
	/* modfnext */
	case 302:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* modfind */
	case 303:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* kldload */
	case 304:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* kldunload */
	case 305:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* kldfind */
	case 306:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* kldnext */
	case 307:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_kldstat */
	case 308:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct kld32_file_stat *";
			break;
		default:
			break;
		};
		break;
	/* kldfirstmod */
	case 309:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* getsid */
	case 310:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* setresuid */
	case 311:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* setresgid */
	case 312:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_aio_return */
	case 314:
		switch(ndx) {
		case 0:
			p = "struct aiocb32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_aio_suspend */
	case 315:
		switch(ndx) {
		case 0:
			p = "struct aiocb32 *const *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_aio_cancel */
	case 316:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct aiocb32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_aio_error */
	case 317:
		switch(ndx) {
		case 0:
			p = "struct aiocb32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_oaio_read */
	case 318:
		switch(ndx) {
		case 0:
			p = "struct oaiocb32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_oaio_write */
	case 319:
		switch(ndx) {
		case 0:
			p = "struct oaiocb32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_olio_listio */
	case 320:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct oaiocb32 *const *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct osigevent32 *";
			break;
		default:
			break;
		};
		break;
	/* yield */
	case 321:
		break;
	/* mlockall */
	case 324:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* munlockall */
	case 325:
		break;
	/* __getcwd */
	case 326:
		switch(ndx) {
		case 0:
			p = "u_char *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* sched_setparam */
	case 327:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "const struct sched_param *";
			break;
		default:
			break;
		};
		break;
	/* sched_getparam */
	case 328:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "struct sched_param *";
			break;
		default:
			break;
		};
		break;
	/* sched_setscheduler */
	case 329:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct sched_param *";
			break;
		default:
			break;
		};
		break;
	/* sched_getscheduler */
	case 330:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* sched_yield */
	case 331:
		break;
	/* sched_get_priority_max */
	case 332:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sched_get_priority_min */
	case 333:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sched_rr_get_interval */
	case 334:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* utrace */
	case 335:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* kldsym */
	case 337:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_jail */
	case 338:
		switch(ndx) {
		case 0:
			p = "struct jail32 *";
			break;
		default:
			break;
		};
		break;
	/* sigprocmask */
	case 340:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const sigset_t *";
			break;
		case 2:
			p = "sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sigsuspend */
	case 341:
		switch(ndx) {
		case 0:
			p = "const sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sigpending */
	case 343:
		switch(ndx) {
		case 0:
			p = "sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_sigtimedwait */
	case 345:
		switch(ndx) {
		case 0:
			p = "const sigset_t *";
			break;
		case 1:
			p = "siginfo_t *";
			break;
		case 2:
			p = "const struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_sigwaitinfo */
	case 346:
		switch(ndx) {
		case 0:
			p = "const sigset_t *";
			break;
		case 1:
			p = "siginfo_t *";
			break;
		default:
			break;
		};
		break;
	/* __acl_get_file */
	case 347:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "acl_type_t";
			break;
		case 2:
			p = "struct acl *";
			break;
		default:
			break;
		};
		break;
	/* __acl_set_file */
	case 348:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "acl_type_t";
			break;
		case 2:
			p = "struct acl *";
			break;
		default:
			break;
		};
		break;
	/* __acl_get_fd */
	case 349:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "acl_type_t";
			break;
		case 2:
			p = "struct acl *";
			break;
		default:
			break;
		};
		break;
	/* __acl_set_fd */
	case 350:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "acl_type_t";
			break;
		case 2:
			p = "struct acl *";
			break;
		default:
			break;
		};
		break;
	/* __acl_delete_file */
	case 351:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "acl_type_t";
			break;
		default:
			break;
		};
		break;
	/* __acl_delete_fd */
	case 352:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "acl_type_t";
			break;
		default:
			break;
		};
		break;
	/* __acl_aclcheck_file */
	case 353:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "acl_type_t";
			break;
		case 2:
			p = "struct acl *";
			break;
		default:
			break;
		};
		break;
	/* __acl_aclcheck_fd */
	case 354:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "acl_type_t";
			break;
		case 2:
			p = "struct acl *";
			break;
		default:
			break;
		};
		break;
	/* extattrctl */
	case 355:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* extattr_set_file */
	case 356:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* extattr_get_file */
	case 357:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* extattr_delete_file */
	case 358:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_aio_waitcomplete */
	case 359:
		switch(ndx) {
		case 0:
			p = "struct aiocb32 **";
			break;
		case 1:
			p = "struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* getresuid */
	case 360:
		switch(ndx) {
		case 0:
			p = "uid_t *";
			break;
		case 1:
			p = "uid_t *";
			break;
		case 2:
			p = "uid_t *";
			break;
		default:
			break;
		};
		break;
	/* getresgid */
	case 361:
		switch(ndx) {
		case 0:
			p = "gid_t *";
			break;
		case 1:
			p = "gid_t *";
			break;
		case 2:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* kqueue */
	case 362:
		break;
	/* freebsd32_kevent */
	case 363:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct kevent32 *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct kevent32 *";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "const struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* extattr_set_fd */
	case 371:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* extattr_get_fd */
	case 372:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* extattr_delete_fd */
	case 373:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* __setugid */
	case 374:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* eaccess */
	case 376:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_nmount */
	case 378:
		switch(ndx) {
		case 0:
			p = "struct iovec32 *";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* kenv */
	case 390:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "char *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* lchflags */
	case 391:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* uuidgen */
	case 392:
		switch(ndx) {
		case 0:
			p = "struct uuid *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_sendfile */
	case 393:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "size_t";
			break;
		case 5:
			p = "struct sf_hdtr32 *";
			break;
		case 6:
			p = "off_t *";
			break;
		case 7:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* getfsstat */
	case 395:
		switch(ndx) {
		case 0:
			p = "struct statfs *";
			break;
		case 1:
			p = "long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* statfs */
	case 396:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct statfs *";
			break;
		default:
			break;
		};
		break;
	/* fstatfs */
	case 397:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct statfs *";
			break;
		default:
			break;
		};
		break;
	/* fhstatfs */
	case 398:
		switch(ndx) {
		case 0:
			p = "const struct fhandle *";
			break;
		case 1:
			p = "struct statfs *";
			break;
		default:
			break;
		};
		break;
	/* ksem_close */
	case 400:
		switch(ndx) {
		case 0:
			p = "semid_t";
			break;
		default:
			break;
		};
		break;
	/* ksem_post */
	case 401:
		switch(ndx) {
		case 0:
			p = "semid_t";
			break;
		default:
			break;
		};
		break;
	/* ksem_wait */
	case 402:
		switch(ndx) {
		case 0:
			p = "semid_t";
			break;
		default:
			break;
		};
		break;
	/* ksem_trywait */
	case 403:
		switch(ndx) {
		case 0:
			p = "semid_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_ksem_init */
	case 404:
		switch(ndx) {
		case 0:
			p = "semid_t *";
			break;
		case 1:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_ksem_open */
	case 405:
		switch(ndx) {
		case 0:
			p = "semid_t *";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "mode_t";
			break;
		case 4:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* ksem_unlink */
	case 406:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* ksem_getvalue */
	case 407:
		switch(ndx) {
		case 0:
			p = "semid_t";
			break;
		case 1:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* ksem_destroy */
	case 408:
		switch(ndx) {
		case 0:
			p = "semid_t";
			break;
		default:
			break;
		};
		break;
	/* extattr_set_link */
	case 412:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* extattr_get_link */
	case 413:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* extattr_delete_link */
	case 414:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_sigaction */
	case 416:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sigaction32 *";
			break;
		case 2:
			p = "struct sigaction32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_sigreturn */
	case 417:
		switch(ndx) {
		case 0:
			p = "const struct freebsd32_ucontext *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_getcontext */
	case 421:
		switch(ndx) {
		case 0:
			p = "struct freebsd32_ucontext *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_setcontext */
	case 422:
		switch(ndx) {
		case 0:
			p = "const struct freebsd32_ucontext *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_swapcontext */
	case 423:
		switch(ndx) {
		case 0:
			p = "struct freebsd32_ucontext *";
			break;
		case 1:
			p = "const struct freebsd32_ucontext *";
			break;
		default:
			break;
		};
		break;
	/* __acl_get_link */
	case 425:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "acl_type_t";
			break;
		case 2:
			p = "struct acl *";
			break;
		default:
			break;
		};
		break;
	/* __acl_set_link */
	case 426:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "acl_type_t";
			break;
		case 2:
			p = "struct acl *";
			break;
		default:
			break;
		};
		break;
	/* __acl_delete_link */
	case 427:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "acl_type_t";
			break;
		default:
			break;
		};
		break;
	/* __acl_aclcheck_link */
	case 428:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "acl_type_t";
			break;
		case 2:
			p = "struct acl *";
			break;
		default:
			break;
		};
		break;
	/* sigwait */
	case 429:
		switch(ndx) {
		case 0:
			p = "const sigset_t *";
			break;
		case 1:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* thr_exit */
	case 431:
		switch(ndx) {
		case 0:
			p = "long *";
			break;
		default:
			break;
		};
		break;
	/* thr_self */
	case 432:
		switch(ndx) {
		case 0:
			p = "long *";
			break;
		default:
			break;
		};
		break;
	/* thr_kill */
	case 433:
		switch(ndx) {
		case 0:
			p = "long";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_umtx_lock */
	case 434:
		switch(ndx) {
		case 0:
			p = "struct umtx *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_umtx_unlock */
	case 435:
		switch(ndx) {
		case 0:
			p = "struct umtx *";
			break;
		default:
			break;
		};
		break;
	/* jail_attach */
	case 436:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* extattr_list_fd */
	case 437:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* extattr_list_file */
	case 438:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* extattr_list_link */
	case 439:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_ksem_timedwait */
	case 441:
		switch(ndx) {
		case 0:
			p = "semid_t";
			break;
		case 1:
			p = "const struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_thr_suspend */
	case 442:
		switch(ndx) {
		case 0:
			p = "const struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* thr_wake */
	case 443:
		switch(ndx) {
		case 0:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* kldunloadf */
	case 444:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* audit */
	case 445:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* auditon */
	case 446:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* getauid */
	case 447:
		switch(ndx) {
		case 0:
			p = "uid_t *";
			break;
		default:
			break;
		};
		break;
	/* setauid */
	case 448:
		switch(ndx) {
		case 0:
			p = "uid_t *";
			break;
		default:
			break;
		};
		break;
	/* getaudit */
	case 449:
		switch(ndx) {
		case 0:
			p = "struct auditinfo *";
			break;
		default:
			break;
		};
		break;
	/* setaudit */
	case 450:
		switch(ndx) {
		case 0:
			p = "struct auditinfo *";
			break;
		default:
			break;
		};
		break;
	/* getaudit_addr */
	case 451:
		switch(ndx) {
		case 0:
			p = "struct auditinfo_addr *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* setaudit_addr */
	case 452:
		switch(ndx) {
		case 0:
			p = "struct auditinfo_addr *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* auditctl */
	case 453:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_umtx_op */
	case 454:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "u_long";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_thr_new */
	case 455:
		switch(ndx) {
		case 0:
			p = "struct thr_param32 *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sigqueue */
	case 456:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_kmq_open */
	case 457:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "const struct mq_attr32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_kmq_setattr */
	case 458:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct mq_attr32 *";
			break;
		case 2:
			p = "struct mq_attr32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_kmq_timedreceive */
	case 459:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned *";
			break;
		case 4:
			p = "const struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_kmq_timedsend */
	case 460:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned";
			break;
		case 4:
			p = "const struct timespec32 *";
			break;
		default:
			break;
		};
		break;
	/* kmq_notify */
	case 461:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct sigevent *";
			break;
		default:
			break;
		};
		break;
	/* kmq_unlink */
	case 462:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* abort2 */
	case 463:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void **";
			break;
		default:
			break;
		};
		break;
	/* thr_set_name */
	case 464:
		switch(ndx) {
		case 0:
			p = "long";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_aio_fsync */
	case 465:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct aiocb32 *";
			break;
		default:
			break;
		};
		break;
	/* rtprio_thread */
	case 466:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "struct rtprio *";
			break;
		default:
			break;
		};
		break;
	/* sctp_peeloff */
	case 471:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uint32_t";
			break;
		default:
			break;
		};
		break;
	/* sctp_generic_sendmsg */
	case 472:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "caddr_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "caddr_t";
			break;
		case 4:
			p = "__socklen_t";
			break;
		case 5:
			p = "struct sctp_sndrcvinfo *";
			break;
		case 6:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sctp_generic_sendmsg_iov */
	case 473:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "caddr_t";
			break;
		case 4:
			p = "__socklen_t";
			break;
		case 5:
			p = "struct sctp_sndrcvinfo *";
			break;
		case 6:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sctp_generic_recvmsg */
	case 474:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct sockaddr *";
			break;
		case 4:
			p = "__socklen_t *";
			break;
		case 5:
			p = "struct sctp_sndrcvinfo *";
			break;
		case 6:
			p = "int *";
			break;
		default:
			break;
		};
		break;
#ifdef PAD64_REQUIRED
	/* freebsd32_pread */
	case 475:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "u_int32_t";
			break;
		case 5:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_pwrite */
	case 476:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "u_int32_t";
			break;
		case 5:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_mmap */
	case 477:
		switch(ndx) {
		case 0:
			p = "caddr_t";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "int";
			break;
		case 6:
			p = "u_int32_t";
			break;
		case 7:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_lseek */
	case 478:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_truncate */
	case 479:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_ftruncate */
	case 480:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
#else
	/* freebsd32_pread */
	case 475:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_pwrite */
	case 476:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_mmap */
	case 477:
		switch(ndx) {
		case 0:
			p = "caddr_t";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "u_int32_t";
			break;
		case 6:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_lseek */
	case 478:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_int32_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_truncate */
	case 479:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "u_int32_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_ftruncate */
	case 480:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_int32_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		default:
			break;
		};
		break;
#endif
	/* thr_kill2 */
	case 481:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* shm_open */
	case 482:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* shm_unlink */
	case 483:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* cpuset */
	case 484:
		switch(ndx) {
		case 0:
			p = "cpusetid_t *";
			break;
		default:
			break;
		};
		break;
#ifdef PAD64_REQUIRED
	/* freebsd32_cpuset_setid */
	case 485:
		switch(ndx) {
		case 0:
			p = "cpuwhich_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "cpusetid_t";
			break;
		default:
			break;
		};
		break;
#else
	/* freebsd32_cpuset_setid */
	case 485:
		switch(ndx) {
		case 0:
			p = "cpuwhich_t";
			break;
		case 1:
			p = "u_int32_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "cpusetid_t";
			break;
		default:
			break;
		};
		break;
#endif
	/* freebsd32_cpuset_getid */
	case 486:
		switch(ndx) {
		case 0:
			p = "cpulevel_t";
			break;
		case 1:
			p = "cpuwhich_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "cpusetid_t *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_cpuset_getaffinity */
	case 487:
		switch(ndx) {
		case 0:
			p = "cpulevel_t";
			break;
		case 1:
			p = "cpuwhich_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "size_t";
			break;
		case 5:
			p = "cpuset_t *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_cpuset_setaffinity */
	case 488:
		switch(ndx) {
		case 0:
			p = "cpulevel_t";
			break;
		case 1:
			p = "cpuwhich_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "u_int32_t";
			break;
		case 4:
			p = "size_t";
			break;
		case 5:
			p = "const cpuset_t *";
			break;
		default:
			break;
		};
		break;
	/* faccessat */
	case 489:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* fchmodat */
	case 490:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* fchownat */
	case 491:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "uid_t";
			break;
		case 3:
			p = "gid_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_fexecve */
	case 492:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_int32_t *";
			break;
		case 2:
			p = "u_int32_t *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_fstatat */
	case 493:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "struct stat *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_futimesat */
	case 494:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "struct timeval *";
			break;
		default:
			break;
		};
		break;
	/* linkat */
	case 495:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "char *";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* mkdirat */
	case 496:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* mkfifoat */
	case 497:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* mknodat */
	case 498:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "dev_t";
			break;
		default:
			break;
		};
		break;
	/* openat */
	case 499:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* readlinkat */
	case 500:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "char *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* renameat */
	case 501:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* symlinkat */
	case 502:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* unlinkat */
	case 503:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* posix_openpt */
	case 504:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_jail_get */
	case 506:
		switch(ndx) {
		case 0:
			p = "struct iovec32 *";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_jail_set */
	case 507:
		switch(ndx) {
		case 0:
			p = "struct iovec32 *";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* jail_remove */
	case 508:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* closefrom */
	case 509:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_semctl */
	case 510:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "union semun32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_msgctl */
	case 511:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct msqid_ds32 *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_shmctl */
	case 512:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct shmid_ds32 *";
			break;
		default:
			break;
		};
		break;
	/* lpathconf */
	case 513:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* cap_new */
	case 514:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_int64_t";
			break;
		default:
			break;
		};
		break;
	/* cap_getrights */
	case 515:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_int64_t *";
			break;
		default:
			break;
		};
		break;
	/* cap_enter */
	case 516:
		break;
	/* cap_getmode */
	case 517:
		switch(ndx) {
		case 0:
			p = "u_int *";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_pselect */
	case 522:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "const struct timespec32 *";
			break;
		case 5:
			p = "const sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* getloginclass */
	case 523:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* setloginclass */
	case 524:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* rctl_get_racct */
	case 525:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* rctl_get_rules */
	case 526:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* rctl_get_limits */
	case 527:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* rctl_add_rule */
	case 528:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* rctl_remove_rule */
	case 529:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_posix_fallocate */
	case 530:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uint32_t";
			break;
		case 2:
			p = "uint32_t";
			break;
		case 3:
			p = "uint32_t";
			break;
		case 4:
			p = "uint32_t";
			break;
		default:
			break;
		};
		break;
	/* freebsd32_posix_fadvise */
	case 531:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uint32_t";
			break;
		case 2:
			p = "uint32_t";
			break;
		case 3:
			p = "uint32_t";
			break;
		case 4:
			p = "uint32_t";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
static void
systrace_return_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
#if !defined(PAD64_REQUIRED) && (defined(__powerpc__) || defined(__mips__))
#define PAD64_REQUIRED
#endif
	/* nosys */
	case 0:
	/* sys_exit */
	case 1:
		if (ndx == 0 || ndx == 1)
			p = "void";
		break;
	/* fork */
	case 2:
	/* read */
	case 3:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* write */
	case 4:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* open */
	case 5:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* close */
	case 6:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_wait4 */
	case 7:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* link */
	case 9:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* unlink */
	case 10:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* chdir */
	case 12:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchdir */
	case 13:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mknod */
	case 14:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* chmod */
	case 15:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* chown */
	case 16:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* obreak */
	case 17:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getpid */
	case 20:
	/* mount */
	case 21:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* unmount */
	case 22:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setuid */
	case 23:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getuid */
	case 24:
	/* geteuid */
	case 25:
	/* ptrace */
	case 26:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_recvmsg */
	case 27:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_sendmsg */
	case 28:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_recvfrom */
	case 29:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* accept */
	case 30:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getpeername */
	case 31:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getsockname */
	case 32:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* access */
	case 33:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* chflags */
	case 34:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchflags */
	case 35:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sync */
	case 36:
	/* kill */
	case 37:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getppid */
	case 39:
	/* dup */
	case 41:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* pipe */
	case 42:
	/* getegid */
	case 43:
	/* profil */
	case 44:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ktrace */
	case 45:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getgid */
	case 47:
	/* getlogin */
	case 49:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setlogin */
	case 50:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* acct */
	case 51:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_sigaltstack */
	case 53:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_ioctl */
	case 54:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* reboot */
	case 55:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* revoke */
	case 56:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* symlink */
	case 57:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* readlink */
	case 58:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* freebsd32_execve */
	case 59:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* umask */
	case 60:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* chroot */
	case 61:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* msync */
	case 65:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* vfork */
	case 66:
	/* sbrk */
	case 69:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sstk */
	case 70:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ovadvise */
	case 72:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* munmap */
	case 73:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_mprotect */
	case 74:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* madvise */
	case 75:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mincore */
	case 78:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getgroups */
	case 79:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setgroups */
	case 80:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getpgrp */
	case 81:
	/* setpgid */
	case 82:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_setitimer */
	case 83:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* swapon */
	case 85:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_getitimer */
	case 86:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getdtablesize */
	case 89:
	/* dup2 */
	case 90:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fcntl */
	case 92:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_select */
	case 93:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fsync */
	case 95:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setpriority */
	case 96:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* socket */
	case 97:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* connect */
	case 98:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getpriority */
	case 100:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* bind */
	case 104:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setsockopt */
	case 105:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* listen */
	case 106:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_gettimeofday */
	case 116:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_getrusage */
	case 117:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getsockopt */
	case 118:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_readv */
	case 120:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_writev */
	case 121:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_settimeofday */
	case 122:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchown */
	case 123:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchmod */
	case 124:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setreuid */
	case 126:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setregid */
	case 127:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rename */
	case 128:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* flock */
	case 131:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mkfifo */
	case 132:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sendto */
	case 133:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* shutdown */
	case 134:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* socketpair */
	case 135:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mkdir */
	case 136:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rmdir */
	case 137:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_utimes */
	case 138:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_adjtime */
	case 140:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setsid */
	case 147:
	/* quotactl */
	case 148:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getfh */
	case 161:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_sysarch */
	case 165:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rtprio */
	case 166:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_semsys */
	case 169:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_msgsys */
	case 170:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_shmsys */
	case 171:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ntp_adjtime */
	case 176:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setgid */
	case 181:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setegid */
	case 182:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* seteuid */
	case 183:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_stat */
	case 188:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_fstat */
	case 189:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_lstat */
	case 190:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* pathconf */
	case 191:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fpathconf */
	case 192:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getrlimit */
	case 194:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setrlimit */
	case 195:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_getdirentries */
	case 196:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* nosys */
	case 198:
	/* freebsd32_sysctl */
	case 202:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mlock */
	case 203:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* munlock */
	case 204:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* undelete */
	case 205:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_futimes */
	case 206:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getpgid */
	case 207:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* poll */
	case 209:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* lkmnosys */
	case 210:
	/* lkmnosys */
	case 211:
	/* lkmnosys */
	case 212:
	/* lkmnosys */
	case 213:
	/* lkmnosys */
	case 214:
	/* lkmnosys */
	case 215:
	/* lkmnosys */
	case 216:
	/* lkmnosys */
	case 217:
	/* lkmnosys */
	case 218:
	/* lkmnosys */
	case 219:
	/* semget */
	case 221:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* semop */
	case 222:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* msgget */
	case 225:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_msgsnd */
	case 226:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_msgrcv */
	case 227:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* shmat */
	case 228:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* shmdt */
	case 230:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* shmget */
	case 231:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_clock_gettime */
	case 232:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_clock_settime */
	case 233:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_clock_getres */
	case 234:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_nanosleep */
	case 240:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ffclock_getcounter */
	case 241:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ffclock_setestimate */
	case 242:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ffclock_getestimate */
	case 243:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* minherit */
	case 250:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rfork */
	case 251:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* openbsd_poll */
	case 252:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* issetugid */
	case 253:
	/* lchown */
	case 254:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_aio_read */
	case 255:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_aio_write */
	case 256:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_lio_listio */
	case 257:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getdents */
	case 272:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* lchmod */
	case 274:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* lchown */
	case 275:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_lutimes */
	case 276:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* msync */
	case 277:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* nstat */
	case 278:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* nfstat */
	case 279:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* nlstat */
	case 280:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_preadv */
	case 289:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* freebsd32_pwritev */
	case 290:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* fhopen */
	case 298:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fhstat */
	case 299:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* modnext */
	case 300:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_modstat */
	case 301:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* modfnext */
	case 302:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* modfind */
	case 303:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kldload */
	case 304:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kldunload */
	case 305:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kldfind */
	case 306:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kldnext */
	case 307:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_kldstat */
	case 308:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kldfirstmod */
	case 309:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getsid */
	case 310:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setresuid */
	case 311:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setresgid */
	case 312:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_aio_return */
	case 314:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_aio_suspend */
	case 315:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_aio_cancel */
	case 316:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_aio_error */
	case 317:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_oaio_read */
	case 318:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_oaio_write */
	case 319:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_olio_listio */
	case 320:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* yield */
	case 321:
	/* mlockall */
	case 324:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* munlockall */
	case 325:
	/* __getcwd */
	case 326:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sched_setparam */
	case 327:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sched_getparam */
	case 328:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sched_setscheduler */
	case 329:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sched_getscheduler */
	case 330:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sched_yield */
	case 331:
	/* sched_get_priority_max */
	case 332:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sched_get_priority_min */
	case 333:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sched_rr_get_interval */
	case 334:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* utrace */
	case 335:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kldsym */
	case 337:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_jail */
	case 338:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sigprocmask */
	case 340:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sigsuspend */
	case 341:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sigpending */
	case 343:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_sigtimedwait */
	case 345:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_sigwaitinfo */
	case 346:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_get_file */
	case 347:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_set_file */
	case 348:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_get_fd */
	case 349:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_set_fd */
	case 350:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_delete_file */
	case 351:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_delete_fd */
	case 352:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_aclcheck_file */
	case 353:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_aclcheck_fd */
	case 354:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* extattrctl */
	case 355:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* extattr_set_file */
	case 356:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* extattr_get_file */
	case 357:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* extattr_delete_file */
	case 358:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_aio_waitcomplete */
	case 359:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getresuid */
	case 360:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getresgid */
	case 361:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kqueue */
	case 362:
	/* freebsd32_kevent */
	case 363:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* extattr_set_fd */
	case 371:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* extattr_get_fd */
	case 372:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* extattr_delete_fd */
	case 373:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __setugid */
	case 374:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* eaccess */
	case 376:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_nmount */
	case 378:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kenv */
	case 390:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* lchflags */
	case 391:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* uuidgen */
	case 392:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_sendfile */
	case 393:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getfsstat */
	case 395:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* statfs */
	case 396:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fstatfs */
	case 397:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fhstatfs */
	case 398:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ksem_close */
	case 400:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ksem_post */
	case 401:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ksem_wait */
	case 402:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ksem_trywait */
	case 403:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_ksem_init */
	case 404:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_ksem_open */
	case 405:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ksem_unlink */
	case 406:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ksem_getvalue */
	case 407:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* ksem_destroy */
	case 408:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* extattr_set_link */
	case 412:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* extattr_get_link */
	case 413:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* extattr_delete_link */
	case 414:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_sigaction */
	case 416:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_sigreturn */
	case 417:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_getcontext */
	case 421:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_setcontext */
	case 422:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_swapcontext */
	case 423:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_get_link */
	case 425:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_set_link */
	case 426:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_delete_link */
	case 427:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* __acl_aclcheck_link */
	case 428:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sigwait */
	case 429:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* thr_exit */
	case 431:
		if (ndx == 0 || ndx == 1)
			p = "void";
		break;
	/* thr_self */
	case 432:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* thr_kill */
	case 433:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_umtx_lock */
	case 434:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_umtx_unlock */
	case 435:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* jail_attach */
	case 436:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* extattr_list_fd */
	case 437:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* extattr_list_file */
	case 438:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* extattr_list_link */
	case 439:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* freebsd32_ksem_timedwait */
	case 441:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_thr_suspend */
	case 442:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* thr_wake */
	case 443:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kldunloadf */
	case 444:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* audit */
	case 445:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* auditon */
	case 446:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getauid */
	case 447:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setauid */
	case 448:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getaudit */
	case 449:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setaudit */
	case 450:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getaudit_addr */
	case 451:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setaudit_addr */
	case 452:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* auditctl */
	case 453:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_umtx_op */
	case 454:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_thr_new */
	case 455:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sigqueue */
	case 456:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_kmq_open */
	case 457:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_kmq_setattr */
	case 458:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_kmq_timedreceive */
	case 459:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_kmq_timedsend */
	case 460:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kmq_notify */
	case 461:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* kmq_unlink */
	case 462:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* abort2 */
	case 463:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* thr_set_name */
	case 464:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_aio_fsync */
	case 465:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rtprio_thread */
	case 466:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sctp_peeloff */
	case 471:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sctp_generic_sendmsg */
	case 472:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sctp_generic_sendmsg_iov */
	case 473:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sctp_generic_recvmsg */
	case 474:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#ifdef PAD64_REQUIRED
	/* freebsd32_pread */
	case 475:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* freebsd32_pwrite */
	case 476:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* freebsd32_mmap */
	case 477:
		if (ndx == 0 || ndx == 1)
			p = "caddr_t";
		break;
	/* freebsd32_lseek */
	case 478:
		if (ndx == 0 || ndx == 1)
			p = "off_t";
		break;
	/* freebsd32_truncate */
	case 479:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_ftruncate */
	case 480:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
	/* freebsd32_pread */
	case 475:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* freebsd32_pwrite */
	case 476:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* freebsd32_mmap */
	case 477:
		if (ndx == 0 || ndx == 1)
			p = "caddr_t";
		break;
	/* freebsd32_lseek */
	case 478:
		if (ndx == 0 || ndx == 1)
			p = "off_t";
		break;
	/* freebsd32_truncate */
	case 479:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_ftruncate */
	case 480:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#endif
	/* thr_kill2 */
	case 481:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* shm_open */
	case 482:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* shm_unlink */
	case 483:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* cpuset */
	case 484:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#ifdef PAD64_REQUIRED
	/* freebsd32_cpuset_setid */
	case 485:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
	/* freebsd32_cpuset_setid */
	case 485:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#endif
	/* freebsd32_cpuset_getid */
	case 486:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_cpuset_getaffinity */
	case 487:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_cpuset_setaffinity */
	case 488:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* faccessat */
	case 489:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchmodat */
	case 490:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchownat */
	case 491:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_fexecve */
	case 492:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_fstatat */
	case 493:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_futimesat */
	case 494:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linkat */
	case 495:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mkdirat */
	case 496:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mkfifoat */
	case 497:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mknodat */
	case 498:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* openat */
	case 499:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* readlinkat */
	case 500:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* renameat */
	case 501:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* symlinkat */
	case 502:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* unlinkat */
	case 503:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* posix_openpt */
	case 504:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_jail_get */
	case 506:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_jail_set */
	case 507:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* jail_remove */
	case 508:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* closefrom */
	case 509:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_semctl */
	case 510:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_msgctl */
	case 511:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_shmctl */
	case 512:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* lpathconf */
	case 513:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* cap_new */
	case 514:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* cap_getrights */
	case 515:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* cap_enter */
	case 516:
	/* cap_getmode */
	case 517:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_pselect */
	case 522:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getloginclass */
	case 523:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setloginclass */
	case 524:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rctl_get_racct */
	case 525:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rctl_get_rules */
	case 526:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rctl_get_limits */
	case 527:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rctl_add_rule */
	case 528:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* rctl_remove_rule */
	case 529:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_posix_fallocate */
	case 530:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* freebsd32_posix_fadvise */
	case 531:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
