/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qframe.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qlayout.h>
#include <qgroupbox.h>

#include <kpushbutton.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kdebug.h>

#include "DDataItem.h"
#include "BoxURL.h"
#include "TextProperties.h"

TextProperties::TextProperties(QWidget *parent, const char *name):
	TextProperties_base(parent, name)
{
	m_lastitem = NULL;
	textedit->setTextFormat( RichText );

	boldbt->setPixmap( BarIcon("text_bold", KGlobal::instance()) );
	italicbt->setPixmap( BarIcon("text_italic", KGlobal::instance()) );
	underlinebt->setPixmap( BarIcon("text_under", KGlobal::instance()) );

	linksbox->setColumnLayout(0, Qt::Vertical );
	linksbox->layout()->setSpacing( 6 );
	linksbox->layout()->setMargin( 11 );
	QGridLayout* layout = new QGridLayout( linksbox->layout() );
	layout->setAlignment( Qt::AlignTop );
	m_boxurl = new BoxURL( linksbox );
	layout->addWidget( m_boxurl, 0, 0 );

	linksbox->setEnabled(false);

	connect(summaryedit, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()));
	connect(textedit, SIGNAL(textChanged()), this, SLOT(updateItem()));
	connect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );
}

TextProperties::~TextProperties()
{
}

void TextProperties::setCurrentItem(DDataItem* item, bool force)
{
	disconnect(summaryedit, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()));
	disconnect(textedit, SIGNAL(textChanged()), this, SLOT(updateItem()));
	disconnect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );

	m_boxurl->setCurrentItem(item);

	if (item)
	{
		m_boxurl->setEnabled(true);
		linksbox->setEnabled(true);

		summaryedit->setEnabled(true);
		textedit->setReadOnly(false);

		if (item != m_lastitem || force)
		{
			summaryedit->setText(item->m_summary);
			textedit->setText(item->m_text);
		}
	}
	else
	{
		summaryedit->setEnabled(false);
		textedit->setReadOnly(true);
		m_boxurl->setEnabled(false);
		linksbox->setEnabled(false);

		boldbt->setDown(false);
		italicbt->setDown(false);
		underlinebt->setDown(false);

		if (item != m_lastitem || force)
		{
			summaryedit->clear();
			textedit->clear();
		}
	}

	m_lastitem = item;

	connect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );
	connect(summaryedit, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()));
	connect(textedit, SIGNAL(textChanged()), this, SLOT(updateItem()));
}

void TextProperties::itemChanged(int id)
{
	if (!m_lastitem)
	{
		return;
	}

	if (m_lastitem->Id() == id)
		if (summaryedit->text() != m_lastitem->m_summary)
			summaryedit->setText( m_lastitem->m_summary );
}

void TextProperties::updateItem()
{
	if (!m_lastitem) return;

	disconnect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );
	m_lastitem->m_summary = summaryedit->text();
	m_lastitem->m_text = textedit->text();
	m_lastitem->setChanged();
	connect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );
}

void TextProperties::showEvent(QShowEvent *ev)
{
	QWidget::showEvent(ev);
	activate();
}

void TextProperties::activate()
{
	setFocusProxy( summaryedit);
	//summaryedit->setFocus();
}

#include "TextProperties.moc"
