/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DGUI_ITEM_H
#define _DGUI_ITEM_H

#include "datastruct/DItem.h"
#include "datastruct/DDataItem.h"

class DGuiView;
/**
 * @short Base class for item views
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 */
class DGuiItem : public DItem
{
	public:
		DGuiItem(DGuiView*, int);
		~DGuiItem();

	protected:
		/**
		 * Return the data item associated
		 */
		DDataItem* data() const;

		/**
		 * Return the parent view
		 */
		DGuiView* m_parent;
};

#endif // _DGUI_ITEM_H
