/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DCANVASLINK_H
#define _DCANVASLINK_H

#include <qcanvas.h>
#include <qpointarray.h>

class DCanvasItem;
class DCanvasLinkEllipse;

class DCanvasLink : public QCanvasPolygon
{
	public:
		DCanvasLink(QCanvas*, DCanvasItem*);
		virtual ~DCanvasLink();

		virtual void updateColor();
		void updatePos();
		void setDest( DCanvasItem* );

		int IdOrig();
		int IdDest();

		static const int Rtti_DCanvasLink = 2222222;
		int rtti() const {return Rtti_DCanvasLink;}

		void drawShape(QPainter &p);

	protected:
		void setPosHide();
		void setPosLines();
		void setPosWeb();
		void setPosThickWeb();

		DCanvasItem *m_orig;
		DCanvasItem *m_dest;

		DCanvasLinkEllipse* m_ellipse;

	private:
		QPointArray m_pa;

		QPointArray m_splineUp;
		QPointArray m_splineDown;
		QPointArray m_spline;

		bool m_candraw;
};

class DCanvasLinkEllipse : public QCanvasEllipse
{
	public:
		DCanvasLinkEllipse(QCanvas*);
		virtual ~DCanvasLinkEllipse() { hide(); }

		static const int Rtti_DCanvasLinkEllipse = 2222223;
		int rtti() const {return Rtti_DCanvasLinkEllipse;}
};

#endif // _DCANVASLINK_H
