// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _V4LDEVTUNER_H
#define _V4LDEVTUNER_H

#include "v4ldev.h"

struct video_tuner;

/**
 * Interface for Video4Linux tuners.
 */
class V4LTuner : public V4LDev
{
    friend class V4LDev;

public:
    virtual ~V4LTuner();

    virtual int setFreq(unsigned long freq);
    virtual unsigned long freq() const;
    virtual unsigned long minFreq() const { return _minFreq; }
    virtual unsigned long maxFreq() const { return _maxFreq; }

    virtual int setSource(const QString &source);
    virtual int setEncoding(const QString &encoding);

    virtual int signal() const;

protected:
    V4LTuner(int fd, const QString &name, int channels, int type, int minw, int minh, int maxw, int maxh);

private:
    struct video_tuner* _vt;
    unsigned long _minFreq, _maxFreq;
    int _tunerNum;
};

#endif
