/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2007 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copyED of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-embed-prefs.h"
#include "kz-marshalers.h"


static void kz_embed_prefs_base_init (gpointer g_class);

GType
kz_embed_prefs_get_type (void)
{
	static GType type = 0;
	if (!type)
	{
		static const GTypeInfo info = {
			sizeof (KzEmbedPrefsIFace),
			kz_embed_prefs_base_init, /* base_init :*/
			NULL,                     /* base_finalize */
			NULL,                     /* class_init */
			NULL,                     /* class_finalize */
			NULL,                     /* class_data */
			0,
			0,                        /* n_preallocs */
			NULL,                     /* instance_init */
		};
		type = g_type_register_static(G_TYPE_INTERFACE, "KzEmbedPrefs",
					      &info, 0);
		g_type_interface_add_prerequisite(type,
						  G_TYPE_OBJECT);
	}
	return type;
}

static void
kz_embed_prefs_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (initialized) return;

	initialized = TRUE;
}

gboolean
kz_embed_prefs_init (KzEmbedPrefs *embed_prefs)
{
	return KZ_EMBED_PREFS_GET_IFACE(embed_prefs)->init(embed_prefs);
}

gboolean
kz_embed_prefs_get_font_list (KzEmbedPrefs *embed_prefs,
			      const gchar *lang_group,
			      const gchar *font_type,
			      GList      **font_list,
			      GList      **all_font_list,
			      gchar      **default_font)
{
	return KZ_EMBED_PREFS_GET_IFACE(embed_prefs)->get_font_list(embed_prefs,
								    lang_group,
								    font_type,
								    font_list,
								    all_font_list,
								    default_font);
}

gboolean
kz_embed_prefs_get_passwords (KzEmbedPrefs *embed_prefs, GList **passwords)
{
	return KZ_EMBED_PREFS_GET_IFACE(embed_prefs)->get_passwords(embed_prefs, passwords);
}

gboolean
kz_embed_prefs_remove_passwords (KzEmbedPrefs *embed_prefs, GList *passwords)
{
	return KZ_EMBED_PREFS_GET_IFACE(embed_prefs)->remove_passwords(embed_prefs, passwords);
}

